/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.jsontransformer.gson;

import com.ecwid.apiclient.v3.exception.JsonDeserializationException;
import com.ecwid.apiclient.v3.jsontransformer.JsonTransformer;
import com.ecwid.apiclient.v3.jsontransformer.PolymorphicType;
import com.ecwid.apiclient.v3.jsontransformer.gson.typeadapters.GsonPolymorphicDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J+\u0010\b\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/ecwid/apiclient/v3/jsontransformer/gson/GsonTransformer;", "Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;", "polymorphicTypes", "", "Lcom/ecwid/apiclient/v3/jsontransformer/PolymorphicType;", "(Ljava/util/List;)V", "gson", "Lcom/google/gson/Gson;", "deserialize", "V", "json", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "serialize", "src", "", "api-client"})
public final class GsonTransformer
implements JsonTransformer {
    private final Gson gson;

    @Override
    @NotNull
    public String serialize(@Nullable Object src) {
        String string = this.gson.toJson(src);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(src)");
        return string;
    }

    @Override
    @Nullable
    public <V> V deserialize(@NotNull String json, @NotNull Class<V> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        try {
            return (V)this.gson.fromJson(json, clazz);
        }
        catch (JsonParseException e) {
            throw (Throwable)new JsonDeserializationException(e.getMessage(), e);
        }
    }

    public GsonTransformer(@NotNull List<? extends PolymorphicType<?>> polymorphicTypes) {
        Intrinsics.checkParameterIsNotNull(polymorphicTypes, (String)"polymorphicTypes");
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss z");
        Iterable $this$forEach$iv = polymorphicTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PolymorphicType polymorphType = (PolymorphicType)element$iv;
            boolean bl = false;
            gsonBuilder.registerTypeAdapter((Type)polymorphType.getRootClass(), (Object)new GsonPolymorphicDeserializer(polymorphType));
        }
        Gson gson = gsonBuilder.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"gsonBuilder.create()");
        this.gson = gson;
    }
}

