package com.ecwid.apiclient.v3.impl

import com.ecwid.apiclient.v3.ApiClientHelper
import com.ecwid.apiclient.v3.StoreProfileApiClient
import com.ecwid.apiclient.v3.dto.profile.request.*
import com.ecwid.apiclient.v3.dto.profile.result.*

internal class StoreProfileApiClientImpl(
	private val apiClientHelper: ApiClientHelper
) : StoreProfileApiClient {
	override fun getStoreProfile(request: StoreProfileRequest) =
		apiClientHelper.makeObjectResultRequest<FetchedStoreProfile>(request)

	override fun updateStoreProfile(request: StoreProfileUpdateRequest) =
		apiClientHelper.makeObjectResultRequest<StoreProfileUpdateResult>(request)

	override fun getLatestStats(request: LatestStatsRequest) =
		apiClientHelper.makeObjectResultRequest<FetchedLatestStats>(request)

	override fun uploadStoreLogo(request: StoreLogoUploadRequest): StoreLogoUploadResult =
		apiClientHelper.makeObjectResultRequest(request)

	override fun removeStoreLogo(request: StoreLogoRemoveRequest): StoreLogoRemoveResult =
		apiClientHelper.makeObjectResultRequest(request)

	override fun uploadInvoiceLogo(request: InvoiceLogoUploadRequest): InvoiceLogoUploadResult =
		apiClientHelper.makeObjectResultRequest(request)

	override fun removeInvoiceLogo(request: InvoiceLogoRemoveRequest): InvoiceLogoRemoveResult =
		apiClientHelper.makeObjectResultRequest(request)

	override fun uploadEmailLogo(request: EmailLogoUploadRequest): EmailLogoUploadResult =
		apiClientHelper.makeObjectResultRequest(request)

	override fun removeEmailLogo(request: EmailLogoRemoveRequest): EmailLogoRemoveResult =
		apiClientHelper.makeObjectResultRequest(request)

	override fun searchExtrafieldConfigs(request: ExtrafieldConfigSearchRequest): ExtrafieldConfigSearchResult =
		apiClientHelper.makeObjectResultRequest(request)

	override fun getExtrafieldConfigDetails(request: ExtrafieldConfigDetailsRequest): FetchedExtrafieldConfig =
		apiClientHelper.makeObjectResultRequest(request)

	override fun createExtrafieldConfig(request: ExtrafieldConfigCreateRequest): ExtrafieldConfigCreateResult =
		apiClientHelper.makeObjectResultRequest(request)

	override fun updateExtrafieldConfig(request: ExtrafieldConfigUpdateRequest): ExtrafieldConfigUpdateResult =
		apiClientHelper.makeObjectResultRequest(request)

	override fun deleteExtrafieldConfig(request: ExtrafieldConfigDeleteRequest): ExtrafieldConfigDeleteResult =
		apiClientHelper.makeObjectResultRequest(request)
}
