/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.httptransport.impl;

import com.ecwid.apiclient.v3.httptransport.HttpRequest;
import com.ecwid.apiclient.v3.httptransport.HttpResponse;
import com.ecwid.apiclient.v3.httptransport.TransportHttpBody;
import com.ecwid.apiclient.v3.httptransport.impl.ApacheCommonsHttpClientTransportKt;
import com.ecwid.apiclient.v3.httptransport.impl.ConvertUtilsKt;
import com.ecwid.apiclient.v3.httptransport.impl.RateLimitRetryStrategy;
import com.ecwid.apiclient.v3.httptransport.impl.RateLimitedHttpClientWrapper;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ecwid/apiclient/v3/httptransport/impl/SleepForRetryAfterRateLimitRetryStrategy;", "Lcom/ecwid/apiclient/v3/httptransport/impl/RateLimitRetryStrategy;", "defaultRateLimitRetryInterval", "", "maxRateLimitRetryInterval", "defaultRateLimitAttempts", "", "onEverySecondOfWaiting", "Lkotlin/Function1;", "", "beforeEachRequestAttempt", "Lkotlin/Function0;", "(JJILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "executeWithRetryOnRateLimited", "Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;", "httpClient", "Lorg/apache/http/client/HttpClient;", "request", "Lorg/apache/http/client/methods/HttpUriRequest;", "executeWithoutRetry", "kotlin.jvm.PlatformType", "makeHttpRequest", "httpRequest", "Lcom/ecwid/apiclient/v3/httptransport/HttpRequest;", "ecwid-java-api-client"})
public final class SleepForRetryAfterRateLimitRetryStrategy
implements RateLimitRetryStrategy {
    private final long defaultRateLimitRetryInterval;
    private final long maxRateLimitRetryInterval;
    private final int defaultRateLimitAttempts;
    @NotNull
    private final Function1<Long, Unit> onEverySecondOfWaiting;
    @NotNull
    private final Function0<Unit> beforeEachRequestAttempt;

    public SleepForRetryAfterRateLimitRetryStrategy(long defaultRateLimitRetryInterval, long maxRateLimitRetryInterval, int defaultRateLimitAttempts, @NotNull Function1<? super Long, Unit> onEverySecondOfWaiting, @NotNull Function0<Unit> beforeEachRequestAttempt) {
        Intrinsics.checkNotNullParameter(onEverySecondOfWaiting, (String)"onEverySecondOfWaiting");
        Intrinsics.checkNotNullParameter(beforeEachRequestAttempt, (String)"beforeEachRequestAttempt");
        this.defaultRateLimitRetryInterval = defaultRateLimitRetryInterval;
        this.maxRateLimitRetryInterval = maxRateLimitRetryInterval;
        this.defaultRateLimitAttempts = defaultRateLimitAttempts;
        this.onEverySecondOfWaiting = onEverySecondOfWaiting;
        this.beforeEachRequestAttempt = beforeEachRequestAttempt;
    }

    public /* synthetic */ SleepForRetryAfterRateLimitRetryStrategy(long l, long l2, int n, Function1 function1, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            l = 60L;
        }
        if ((n2 & 2) != 0) {
            l2 = 10L;
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        if ((n2 & 8) != 0) {
            function1 = ApacheCommonsHttpClientTransportKt.getEMPTY_WAITING_REACTION();
        }
        if ((n2 & 0x10) != 0) {
            function0 = ApacheCommonsHttpClientTransportKt.getEMPTY_BEFORE_REQUEST_ACTION();
        }
        this(l, l2, n, function1, function0);
    }

    @Override
    @NotNull
    public HttpResponse makeHttpRequest(@NotNull HttpClient httpClient, @NotNull HttpRequest httpRequest) {
        HttpResponse httpResponse;
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        HttpUriRequest request = ConvertUtilsKt.toHttpUriRequest(httpRequest);
        if (httpRequest.getTransportHttpBody() instanceof TransportHttpBody.InputStreamBody) {
            HttpResponse httpResponse2 = this.executeWithoutRetry(httpClient, request);
            httpResponse = httpResponse2;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponse2, (String)"{\n\t\t\texecuteWithoutRetry(httpClient, request)\n\t\t}");
        } else {
            httpResponse = this.executeWithRetryOnRateLimited(httpClient, request);
        }
        return httpResponse;
    }

    private final HttpResponse executeWithoutRetry(HttpClient httpClient, HttpUriRequest request) {
        return (HttpResponse)httpClient.execute(request, SleepForRetryAfterRateLimitRetryStrategy::executeWithoutRetry$lambda$0);
    }

    private final HttpResponse executeWithRetryOnRateLimited(HttpClient httpClient, HttpUriRequest request) {
        HttpResponse httpResponse;
        try {
            Object t = new RateLimitedHttpClientWrapper(httpClient, this.defaultRateLimitRetryInterval, this.maxRateLimitRetryInterval, this.defaultRateLimitAttempts, this.onEverySecondOfWaiting, this.beforeEachRequestAttempt).execute(request, SleepForRetryAfterRateLimitRetryStrategy::executeWithRetryOnRateLimited$lambda$1);
            Intrinsics.checkNotNullExpressionValue(t, (String)"{\n\t\t\tRateLimitedHttpClie\u2026.toApiResponse()\n\t\t\t}\n\t\t}");
            httpResponse = (HttpResponse)t;
        }
        catch (IOException e) {
            httpResponse = new HttpResponse.TransportError(e);
        }
        return httpResponse;
    }

    private static final HttpResponse executeWithoutRetry$lambda$0(org.apache.http.HttpResponse response) {
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        return ConvertUtilsKt.toApiResponse(response);
    }

    private static final HttpResponse executeWithRetryOnRateLimited$lambda$1(org.apache.http.HttpResponse response) {
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        return ConvertUtilsKt.toApiResponse(response);
    }

    public SleepForRetryAfterRateLimitRetryStrategy() {
        this(0L, 0L, 0, null, null, 31, null);
    }
}

