/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3;

import com.ecwid.apiclient.v3.ApiClientHelperKt;
import com.ecwid.apiclient.v3.config.ApiAppCredentials;
import com.ecwid.apiclient.v3.config.ApiCredentials;
import com.ecwid.apiclient.v3.config.ApiServerDomain;
import com.ecwid.apiclient.v3.config.ApiStoreCredentials;
import com.ecwid.apiclient.v3.config.LoggingSettings;
import com.ecwid.apiclient.v3.dto.ApiRequest;
import com.ecwid.apiclient.v3.dto.common.EcwidApiError;
import com.ecwid.apiclient.v3.exception.EcwidApiException;
import com.ecwid.apiclient.v3.exception.JsonDeserializationException;
import com.ecwid.apiclient.v3.httptransport.HttpBody;
import com.ecwid.apiclient.v3.httptransport.HttpRequest;
import com.ecwid.apiclient.v3.httptransport.HttpResponse;
import com.ecwid.apiclient.v3.httptransport.HttpTransport;
import com.ecwid.apiclient.v3.impl.ByteArrayResponseParser;
import com.ecwid.apiclient.v3.impl.HttpMethod;
import com.ecwid.apiclient.v3.impl.ObjectResponseParser;
import com.ecwid.apiclient.v3.impl.ObjectWithExtResponseParser;
import com.ecwid.apiclient.v3.impl.ParsedResponseWithExt;
import com.ecwid.apiclient.v3.impl.RequestInfo;
import com.ecwid.apiclient.v3.impl.ResponseParser;
import com.ecwid.apiclient.v3.impl.StringResponseParser;
import com.ecwid.apiclient.v3.jsontransformer.JsonTransformer;
import com.ecwid.apiclient.v3.jsontransformer.JsonTransformerProvider;
import com.ecwid.apiclient.v3.metric.RequestSizeMetric;
import com.ecwid.apiclient.v3.metric.RequestTimeMetric;
import com.ecwid.apiclient.v3.metric.ResponseSizeMetric;
import com.ecwid.apiclient.v3.util.EncodeUtilsKt;
import com.ecwid.apiclient.v3.util.MaskUtilsKt;
import com.ecwid.apiclient.v3.util.SecurePattern;
import com.ecwid.apiclient.v3.util.SecurePatternsKt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eH\u0001J,\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001b2\n\u0010%\u001a\u00060&j\u0002`'H\u0002JJ\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0010\b\u0002\u0010%\u001a\n\u0018\u00010&j\u0004\u0018\u0001`'H\u0002J(\u0010/\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u00100\u001a\u00020-2\u0006\u0010$\u001a\u00020\u001bH\u0002J \u00101\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0001J&\u00106\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001b08H\u0002J.\u00109\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\b\u0010:\u001a\u0004\u0018\u00010\u001b2\n\u0010%\u001a\u00060&j\u0002`'H\u0002J\u0011\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0086\bJ\u001e\u0010?\u001a\u0002H@\"\u0006\b\u0000\u0010@\u0018\u00012\u0006\u0010=\u001a\u00020>H\u0086\b\u00a2\u0006\u0002\u0010AJ-\u0010B\u001a\u000e\u0012\u0004\u0012\u0002HD\u0012\u0004\u0012\u0002HE0C\"\u0006\b\u0000\u0010D\u0018\u0001\"\u0006\b\u0001\u0010E\u0018\u00012\u0006\u0010=\u001a\u00020>H\u0086\bJ,\u0010F\u001a\u0002H@\"\u0006\b\u0000\u0010@\u0018\u00012\u0006\u0010=\u001a\u00020>2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002H@0HH\u0081\b\u00a2\u0006\u0002\u0010IJ\u0011\u0010J\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020>H\u0086\bJ9\u0010K\u001a\u0002H@\"\u0004\b\u0000\u0010@2\u0006\u0010L\u001a\u00020M2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002H@0HH\u0001\u00a2\u0006\u0002\u0010NJ\u0014\u0010O\u001a\u000203*\u00020P2\u0006\u0010!\u001a\u00020\u001bH\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/ecwid/apiclient/v3/ApiClientHelper;", "", "apiServerDomain", "Lcom/ecwid/apiclient/v3/config/ApiServerDomain;", "storeCredentials", "Lcom/ecwid/apiclient/v3/config/ApiStoreCredentials;", "loggingSettings", "Lcom/ecwid/apiclient/v3/config/LoggingSettings;", "httpTransport", "Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;", "jsonTransformerProvider", "Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformerProvider;", "(Lcom/ecwid/apiclient/v3/config/ApiServerDomain;Lcom/ecwid/apiclient/v3/config/ApiStoreCredentials;Lcom/ecwid/apiclient/v3/config/LoggingSettings;Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformerProvider;)V", "credentials", "Lcom/ecwid/apiclient/v3/config/ApiCredentials;", "(Lcom/ecwid/apiclient/v3/config/ApiServerDomain;Lcom/ecwid/apiclient/v3/config/ApiCredentials;Lcom/ecwid/apiclient/v3/config/LoggingSettings;Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformerProvider;)V", "jsonTransformer", "Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;", "(Lcom/ecwid/apiclient/v3/config/ApiServerDomain;Lcom/ecwid/apiclient/v3/config/ApiCredentials;Lcom/ecwid/apiclient/v3/config/LoggingSettings;Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;)V", "getHttpTransport", "()Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;", "getJsonTransformer", "()Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "buildBaseEndpointPath", "", "createApiEndpointUri", "pathSegments", "", "logCannotParseResponseError", "", "requestId", "requestTime", "", "responseBody", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logEntry", "prefix", "logLevel", "Ljava/util/logging/Level;", "maxSectionLength", "", "sections", "logErrorResponseIfNeeded", "httpStatusCode", "logRequestIfNeeded", "httpRequest", "Lcom/ecwid/apiclient/v3/httptransport/HttpRequest;", "httpBody", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody;", "logSuccessfulResponseIfNeeded", "getResponseBody", "Lkotlin/Function0;", "logTransportErrorResponseIfNeeded", "errorMessage", "makeByteArrayResultRequest", "", "request", "Lcom/ecwid/apiclient/v3/dto/ApiRequest;", "makeObjectResultRequest", "V", "(Lcom/ecwid/apiclient/v3/dto/ApiRequest;)Ljava/lang/Object;", "makeObjectWithExtResultRequest", "Lcom/ecwid/apiclient/v3/impl/ParsedResponseWithExt;", "VBase", "VExt", "makeRequestInt", "responseParser", "Lcom/ecwid/apiclient/v3/impl/ResponseParser;", "(Lcom/ecwid/apiclient/v3/dto/ApiRequest;Lcom/ecwid/apiclient/v3/impl/ResponseParser;)Ljava/lang/Object;", "makeStringResultRequest", "processHttpResponse", "httpResponse", "Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;", "(Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;Ljava/lang/String;JLcom/ecwid/apiclient/v3/impl/ResponseParser;)Ljava/lang/Object;", "toHttpRequest", "Lcom/ecwid/apiclient/v3/impl/RequestInfo;", "ecwid-java-api-client"})
@SourceDebugExtension(value={"SMAP\nApiClientHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiClientHelper.kt\ncom/ecwid/apiclient/v3/ApiClientHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,474:1\n72#1,34:475\n72#1,34:509\n72#1,34:543\n72#1,34:577\n1#2:611\n*S KotlinDebug\n*F\n+ 1 ApiClientHelper.kt\ncom/ecwid/apiclient/v3/ApiClientHelper\n*L\n110#1:475,34\n115#1:509,34\n123#1:543,34\n128#1:577,34\n*E\n"})
public final class ApiClientHelper {
    @NotNull
    private final ApiServerDomain apiServerDomain;
    @NotNull
    private final ApiCredentials credentials;
    @NotNull
    private final LoggingSettings loggingSettings;
    @NotNull
    private final HttpTransport httpTransport;
    @NotNull
    private final JsonTransformer jsonTransformer;
    private final Logger log;

    private ApiClientHelper(ApiServerDomain apiServerDomain, ApiCredentials credentials, LoggingSettings loggingSettings, HttpTransport httpTransport, JsonTransformer jsonTransformer) {
        this.apiServerDomain = apiServerDomain;
        this.credentials = credentials;
        this.loggingSettings = loggingSettings;
        this.httpTransport = httpTransport;
        this.jsonTransformer = jsonTransformer;
        this.log = Logger.getLogger(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName());
    }

    @NotNull
    public final HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    @NotNull
    public final JsonTransformer getJsonTransformer() {
        return this.jsonTransformer;
    }

    public ApiClientHelper(@NotNull ApiServerDomain apiServerDomain, @NotNull ApiStoreCredentials storeCredentials, @NotNull LoggingSettings loggingSettings, @NotNull HttpTransport httpTransport, @NotNull JsonTransformerProvider jsonTransformerProvider) {
        Intrinsics.checkNotNullParameter((Object)apiServerDomain, (String)"apiServerDomain");
        Intrinsics.checkNotNullParameter((Object)storeCredentials, (String)"storeCredentials");
        Intrinsics.checkNotNullParameter((Object)loggingSettings, (String)"loggingSettings");
        Intrinsics.checkNotNullParameter((Object)httpTransport, (String)"httpTransport");
        Intrinsics.checkNotNullParameter((Object)jsonTransformerProvider, (String)"jsonTransformerProvider");
        this(apiServerDomain, (ApiCredentials)storeCredentials, loggingSettings, httpTransport, jsonTransformerProvider.build(CollectionsKt.listOf((Object)ApiClientHelperKt.access$createProductOptionsPolymorphicType())));
    }

    public ApiClientHelper(@NotNull ApiServerDomain apiServerDomain, @NotNull ApiCredentials credentials, @NotNull LoggingSettings loggingSettings, @NotNull HttpTransport httpTransport, @NotNull JsonTransformerProvider jsonTransformerProvider) {
        Intrinsics.checkNotNullParameter((Object)apiServerDomain, (String)"apiServerDomain");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)loggingSettings, (String)"loggingSettings");
        Intrinsics.checkNotNullParameter((Object)httpTransport, (String)"httpTransport");
        Intrinsics.checkNotNullParameter((Object)jsonTransformerProvider, (String)"jsonTransformerProvider");
        this(apiServerDomain, credentials, loggingSettings, httpTransport, jsonTransformerProvider.build(CollectionsKt.listOf((Object)ApiClientHelperKt.access$createProductOptionsPolymorphicType())));
    }

    @PublishedApi
    public final /* synthetic */ <V> V makeRequestInt(ApiRequest request, ResponseParser<V> responseParser) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseParser, (String)"responseParser");
        boolean $i$f$makeRequestInt = false;
        String requestId = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo = request.toRequestInfo();
        HttpRequest originalHttpRequest = this.toHttpRequest(requestInfo, requestId);
        RequestSizeMetric.HttpRequestAndCounter httpRequestAndCounter = RequestSizeMetric.INSTANCE.makeHttpRequestCountable(originalHttpRequest);
        HttpRequest httpRequest = httpRequestAndCounter.component1();
        AtomicLong requestSizeCounter = httpRequestAndCounter.component2();
        this.logRequestIfNeeded(requestId, httpRequest, requestInfo.getHttpBody());
        long startTime = new Date().getTime();
        HttpResponse httpResponse = this.getHttpTransport().makeHttpRequest(httpRequest);
        long requestTimeMs = new Date().getTime() - startTime;
        RequestTimeMetric.INSTANCE.observeRequest(request, requestInfo, requestTimeMs, httpResponse);
        RequestSizeMetric.INSTANCE.observeRequest(request, requestInfo, requestSizeCounter, httpResponse);
        ResponseSizeMetric.INSTANCE.observeResponse(request, requestInfo, httpResponse);
        return this.processHttpResponse(httpResponse, requestId, requestTimeMs, responseParser);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <V> V makeObjectResultRequest(ApiRequest request) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean $i$f$makeObjectResultRequest = false;
        ApiClientHelper apiClientHelper = this;
        JsonTransformer jsonTransformer = this.getJsonTransformer();
        Intrinsics.reifiedOperationMarker((int)4, (String)"V");
        ResponseParser responseParser$iv = new ObjectResponseParser<Object>(jsonTransformer, Object.class);
        boolean $i$f$makeRequestInt = false;
        String requestId$iv = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo$iv = request.toRequestInfo();
        HttpRequest originalHttpRequest$iv = this_$iv.toHttpRequest(requestInfo$iv, requestId$iv);
        RequestSizeMetric.HttpRequestAndCounter httpRequestAndCounter = RequestSizeMetric.INSTANCE.makeHttpRequestCountable(originalHttpRequest$iv);
        HttpRequest httpRequest$iv = httpRequestAndCounter.component1();
        AtomicLong requestSizeCounter$iv = httpRequestAndCounter.component2();
        this_$iv.logRequestIfNeeded(requestId$iv, httpRequest$iv, requestInfo$iv.getHttpBody());
        long startTime$iv = new Date().getTime();
        HttpResponse httpResponse$iv = this_$iv.getHttpTransport().makeHttpRequest(httpRequest$iv);
        long requestTimeMs$iv = new Date().getTime() - startTime$iv;
        RequestTimeMetric.INSTANCE.observeRequest(request, requestInfo$iv, requestTimeMs$iv, httpResponse$iv);
        RequestSizeMetric.INSTANCE.observeRequest(request, requestInfo$iv, requestSizeCounter$iv, httpResponse$iv);
        ResponseSizeMetric.INSTANCE.observeResponse(request, requestInfo$iv, httpResponse$iv);
        return this_$iv.processHttpResponse(httpResponse$iv, requestId$iv, requestTimeMs$iv, responseParser$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <VBase, VExt> ParsedResponseWithExt<VBase, VExt> makeObjectWithExtResultRequest(ApiRequest request) {
        void responseParser$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean $i$f$makeObjectWithExtResultRequest = false;
        ApiClientHelper apiClientHelper = this;
        JsonTransformer jsonTransformer = this.getJsonTransformer();
        Intrinsics.reifiedOperationMarker((int)4, (String)"VBase");
        Intrinsics.reifiedOperationMarker((int)4, (String)"VExt");
        ResponseParser responseParser = new ObjectWithExtResponseParser<Object, Object>(jsonTransformer, Object.class, Object.class);
        boolean $i$f$makeRequestInt = false;
        String requestId$iv = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo$iv = request.toRequestInfo();
        HttpRequest originalHttpRequest$iv = this_$iv.toHttpRequest(requestInfo$iv, requestId$iv);
        RequestSizeMetric.HttpRequestAndCounter httpRequestAndCounter = RequestSizeMetric.INSTANCE.makeHttpRequestCountable(originalHttpRequest$iv);
        HttpRequest httpRequest$iv = httpRequestAndCounter.component1();
        AtomicLong requestSizeCounter$iv = httpRequestAndCounter.component2();
        this_$iv.logRequestIfNeeded(requestId$iv, httpRequest$iv, requestInfo$iv.getHttpBody());
        long startTime$iv = new Date().getTime();
        HttpResponse httpResponse$iv = this_$iv.getHttpTransport().makeHttpRequest(httpRequest$iv);
        long requestTimeMs$iv = new Date().getTime() - startTime$iv;
        RequestTimeMetric.INSTANCE.observeRequest(request, requestInfo$iv, requestTimeMs$iv, httpResponse$iv);
        RequestSizeMetric.INSTANCE.observeRequest(request, requestInfo$iv, requestSizeCounter$iv, httpResponse$iv);
        ResponseSizeMetric.INSTANCE.observeResponse(request, requestInfo$iv, httpResponse$iv);
        return (ParsedResponseWithExt)this_$iv.processHttpResponse(httpResponse$iv, requestId$iv, requestTimeMs$iv, (ResponseParser)responseParser$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] makeByteArrayResultRequest(@NotNull ApiRequest request) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean $i$f$makeByteArrayResultRequest = false;
        ApiClientHelper apiClientHelper = this;
        ResponseParser responseParser$iv = new ByteArrayResponseParser();
        boolean $i$f$makeRequestInt = false;
        String requestId$iv = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo$iv = request.toRequestInfo();
        HttpRequest originalHttpRequest$iv = this_$iv.toHttpRequest(requestInfo$iv, requestId$iv);
        RequestSizeMetric.HttpRequestAndCounter httpRequestAndCounter = RequestSizeMetric.INSTANCE.makeHttpRequestCountable(originalHttpRequest$iv);
        HttpRequest httpRequest$iv = httpRequestAndCounter.component1();
        AtomicLong requestSizeCounter$iv = httpRequestAndCounter.component2();
        this_$iv.logRequestIfNeeded(requestId$iv, httpRequest$iv, requestInfo$iv.getHttpBody());
        long startTime$iv = new Date().getTime();
        HttpResponse httpResponse$iv = this_$iv.getHttpTransport().makeHttpRequest(httpRequest$iv);
        long requestTimeMs$iv = new Date().getTime() - startTime$iv;
        RequestTimeMetric.INSTANCE.observeRequest(request, requestInfo$iv, requestTimeMs$iv, httpResponse$iv);
        RequestSizeMetric.INSTANCE.observeRequest(request, requestInfo$iv, requestSizeCounter$iv, httpResponse$iv);
        ResponseSizeMetric.INSTANCE.observeResponse(request, requestInfo$iv, httpResponse$iv);
        return (byte[])this_$iv.processHttpResponse(httpResponse$iv, requestId$iv, requestTimeMs$iv, responseParser$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeStringResultRequest(@NotNull ApiRequest request) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        boolean $i$f$makeStringResultRequest = false;
        ApiClientHelper apiClientHelper = this;
        ResponseParser responseParser$iv = new StringResponseParser();
        boolean $i$f$makeRequestInt = false;
        String requestId$iv = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo$iv = request.toRequestInfo();
        HttpRequest originalHttpRequest$iv = this_$iv.toHttpRequest(requestInfo$iv, requestId$iv);
        RequestSizeMetric.HttpRequestAndCounter httpRequestAndCounter = RequestSizeMetric.INSTANCE.makeHttpRequestCountable(originalHttpRequest$iv);
        HttpRequest httpRequest$iv = httpRequestAndCounter.component1();
        AtomicLong requestSizeCounter$iv = httpRequestAndCounter.component2();
        this_$iv.logRequestIfNeeded(requestId$iv, httpRequest$iv, requestInfo$iv.getHttpBody());
        long startTime$iv = new Date().getTime();
        HttpResponse httpResponse$iv = this_$iv.getHttpTransport().makeHttpRequest(httpRequest$iv);
        long requestTimeMs$iv = new Date().getTime() - startTime$iv;
        RequestTimeMetric.INSTANCE.observeRequest(request, requestInfo$iv, requestTimeMs$iv, httpResponse$iv);
        RequestSizeMetric.INSTANCE.observeRequest(request, requestInfo$iv, requestSizeCounter$iv, httpResponse$iv);
        ResponseSizeMetric.INSTANCE.observeResponse(request, requestInfo$iv, httpResponse$iv);
        return (String)this_$iv.processHttpResponse(httpResponse$iv, requestId$iv, requestTimeMs$iv, responseParser$iv);
    }

    @PublishedApi
    public final <V> V processHttpResponse(@NotNull HttpResponse httpResponse, @NotNull String requestId, long requestTime, @NotNull ResponseParser<V> responseParser) {
        V parsedResponse;
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter(responseParser, (String)"responseParser");
        byte[] responseBytes = httpResponse.getResponseBytes();
        HttpResponse httpResponse2 = httpResponse;
        if (httpResponse2 instanceof HttpResponse.Success) {
            try {
                parsedResponse = responseParser.parse(responseBytes);
                Function0 getResponseBodyForLog2 = (Function0)new Function0<String>(responseParser, responseBytes){
                    final /* synthetic */ ResponseParser<V> $responseParser;
                    final /* synthetic */ byte[] $responseBytes;
                    {
                        this.$responseParser = $responseParser;
                        this.$responseBytes = $responseBytes;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$responseParser.getLogString(this.$responseBytes);
                    }
                };
                this.logSuccessfulResponseIfNeeded(requestId, requestTime, (Function0<String>)getResponseBodyForLog2);
            }
            catch (JsonDeserializationException e) {
                this.logCannotParseResponseError(requestId, requestTime, ApiClientHelperKt.asString(responseBytes), e);
                throw new EcwidApiException(null, null, null, e.getMessage(), e, 7, null);
            }
        } else {
            if (httpResponse2 instanceof HttpResponse.Error) {
                try {
                    String responseBody = ApiClientHelperKt.asString(responseBytes);
                    this.logErrorResponseIfNeeded(requestId, requestTime, ((HttpResponse.Error)httpResponse).getStatusCode(), responseBody);
                    EcwidApiError ecwidError = !StringsKt.isBlank((CharSequence)responseBody) ? this.jsonTransformer.deserialize(responseBody, EcwidApiError.class) : null;
                    EcwidApiError ecwidApiError = ecwidError;
                    EcwidApiError ecwidApiError2 = ecwidError;
                    throw new EcwidApiException(((HttpResponse.Error)httpResponse).getStatusCode(), ((HttpResponse.Error)httpResponse).getReasonPhrase(), ecwidApiError != null ? ecwidApiError.getErrorCode() : null, ecwidApiError2 != null ? ecwidApiError2.getErrorMessage() : null, null, 16, null);
                }
                catch (JsonDeserializationException e) {
                    throw new EcwidApiException(((HttpResponse.Error)httpResponse).getStatusCode(), ((HttpResponse.Error)httpResponse).getReasonPhrase(), null, e.getMessage(), e, 4, null);
                }
            }
            if (httpResponse2 instanceof HttpResponse.TransportError) {
                this.logTransportErrorResponseIfNeeded(requestId, requestTime, ((HttpResponse.TransportError)httpResponse).getException().getMessage(), ((HttpResponse.TransportError)httpResponse).getException());
                throw new EcwidApiException(null, null, null, ((HttpResponse.TransportError)httpResponse).getException().getMessage(), ((HttpResponse.TransportError)httpResponse).getException(), 7, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return parsedResponse;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final void logRequestIfNeeded(@NotNull String requestId, @NotNull HttpRequest httpRequest, @NotNull HttpBody httpBody) {
        void $this$logRequestIfNeeded_u24lambda_u240;
        List list;
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)httpBody, (String)"httpBody");
        if (!this.loggingSettings.getLogRequest()) {
            return;
        }
        List<SecurePattern> securePatterns = SecurePatternsKt.createSecurePatterns(this.loggingSettings);
        List list2 = list = (List)new ArrayList();
        int n = this.loggingSettings.getMaxLogSectionLength();
        String string = requestId;
        Level level = Level.INFO;
        String string2 = "Request";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        $this$logRequestIfNeeded_u24lambda_u240.add(httpRequest.getMethod() + " " + httpRequest.getUri());
        if (this.loggingSettings.getLogRequestParams()) {
            $this$logRequestIfNeeded_u24lambda_u240.add(MaskUtilsKt.maskLogString(ApiClientHelperKt.access$dumpToString(httpRequest.getParams()), securePatterns));
        }
        if (this.loggingSettings.getLogRequestBody()) {
            String string3 = httpBody.asString();
            if (string3 != null && (string3 = MaskUtilsKt.maskLogString(string3, securePatterns)) != null) {
                String p0 = string3;
                boolean bl2 = false;
                $this$logRequestIfNeeded_u24lambda_u240.add(p0);
            }
        }
        Unit unit = Unit.INSTANCE;
        ApiClientHelper.logEntry$default(apiClientHelper, string2, level, string, n, list, null, 32, null);
    }

    @PublishedApi
    @NotNull
    public final HttpRequest toHttpRequest(@NotNull RequestInfo $this$toHttpRequest, @NotNull String requestId) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter((Object)$this$toHttpRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toHttpRequest.getMethod().ordinal()]) {
            case 1: {
                httpRequest = new HttpRequest.HttpGetRequest(this.createApiEndpointUri($this$toHttpRequest.getPathSegments()), ApiClientHelperKt.withCredentialsParams($this$toHttpRequest.getParams(), this.credentials), ApiClientHelperKt.access$withRequestId($this$toHttpRequest.getHeaders(), requestId));
                break;
            }
            case 2: {
                httpRequest = new HttpRequest.HttpPostRequest(this.createApiEndpointUri($this$toHttpRequest.getPathSegments()), ApiClientHelperKt.withCredentialsParams($this$toHttpRequest.getParams(), this.credentials), ApiClientHelperKt.prepare($this$toHttpRequest.getHttpBody(), this.jsonTransformer), ApiClientHelperKt.access$withRequestId($this$toHttpRequest.getHeaders(), requestId));
                break;
            }
            case 3: {
                httpRequest = new HttpRequest.HttpPutRequest(this.createApiEndpointUri($this$toHttpRequest.getPathSegments()), ApiClientHelperKt.withCredentialsParams($this$toHttpRequest.getParams(), this.credentials), ApiClientHelperKt.prepare($this$toHttpRequest.getHttpBody(), this.jsonTransformer), ApiClientHelperKt.access$withRequestId($this$toHttpRequest.getHeaders(), requestId));
                break;
            }
            case 4: {
                httpRequest = new HttpRequest.HttpDeleteRequest(this.createApiEndpointUri($this$toHttpRequest.getPathSegments()), ApiClientHelperKt.withCredentialsParams($this$toHttpRequest.getParams(), this.credentials), ApiClientHelperKt.access$withRequestId($this$toHttpRequest.getHeaders(), requestId));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpRequest;
    }

    @PublishedApi
    @NotNull
    public final String createApiEndpointUri(@NotNull List<String> pathSegments) {
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        URI uri = new URI("https", null, this.apiServerDomain.getHost(), this.apiServerDomain.getSecurePort() == 443 ? -1 : this.apiServerDomain.getSecurePort(), null, null, null);
        String encodedPath = this.buildBaseEndpointPath(this.credentials) + "/" + EncodeUtilsKt.buildEndpointPath(pathSegments);
        return uri.toString() + encodedPath;
    }

    /*
     * WARNING - void declaration
     */
    private final void logSuccessfulResponseIfNeeded(String requestId, long requestTime, Function0<String> getResponseBody) {
        void $this$logSuccessfulResponseIfNeeded_u24lambda_u241;
        List list;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        List<SecurePattern> securePatterns = SecurePatternsKt.createSecurePatterns(this.loggingSettings);
        List list2 = list = (List)new ArrayList();
        int n = this.loggingSettings.getMaxLogSectionLength();
        String string = requestId;
        Level level = Level.INFO;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        $this$logSuccessfulResponseIfNeeded_u24lambda_u241.add("OK");
        $this$logSuccessfulResponseIfNeeded_u24lambda_u241.add(requestTime + " ms");
        if (this.loggingSettings.getLogSuccessfulResponseBody()) {
            $this$logSuccessfulResponseIfNeeded_u24lambda_u241.add(MaskUtilsKt.maskLogString((String)getResponseBody.invoke(), securePatterns));
        }
        Unit unit = Unit.INSTANCE;
        ApiClientHelper.logEntry$default(apiClientHelper, string2, level, string, n, list, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void logErrorResponseIfNeeded(String requestId, long requestTime, int httpStatusCode, String responseBody) {
        void $this$logErrorResponseIfNeeded_u24lambda_u242;
        List list;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        List list2 = list = (List)new ArrayList();
        int n = this.loggingSettings.getMaxLogSectionLength();
        String string = requestId;
        Level level = Level.INFO;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        $this$logErrorResponseIfNeeded_u24lambda_u242.add("ERR " + httpStatusCode);
        $this$logErrorResponseIfNeeded_u24lambda_u242.add(requestTime + " ms");
        if (this.loggingSettings.getLogFailedResponseBody()) {
            $this$logErrorResponseIfNeeded_u24lambda_u242.add(responseBody);
        }
        Unit unit = Unit.INSTANCE;
        ApiClientHelper.logEntry$default(apiClientHelper, string2, level, string, n, list, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void logTransportErrorResponseIfNeeded(String requestId, long requestTime, String errorMessage, Exception exception) {
        void $this$logTransportErrorResponseIfNeeded_u24lambda_u243;
        List list;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        List list2 = list = (List)new ArrayList();
        int n = this.loggingSettings.getMaxLogSectionLength();
        String string = requestId;
        Level level = Level.WARNING;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        $this$logTransportErrorResponseIfNeeded_u24lambda_u243.add("ERR");
        $this$logTransportErrorResponseIfNeeded_u24lambda_u243.add(requestTime + " ms");
        if (errorMessage != null) {
            $this$logTransportErrorResponseIfNeeded_u24lambda_u243.add(errorMessage);
        }
        Unit unit = Unit.INSTANCE;
        apiClientHelper.logEntry(string2, level, string, n, list, exception);
    }

    /*
     * WARNING - void declaration
     */
    private final void logCannotParseResponseError(String requestId, long requestTime, String responseBody, Exception exception) {
        void $this$logCannotParseResponseError_u24lambda_u244;
        List list;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        List list2 = list = (List)new ArrayList();
        int n = this.loggingSettings.getMaxLogSectionLength();
        String string = requestId;
        Level level = Level.WARNING;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl = false;
        $this$logCannotParseResponseError_u24lambda_u244.add("ERR");
        $this$logCannotParseResponseError_u24lambda_u244.add(requestTime + " ms");
        if (this.loggingSettings.getLogFailedResponseBody()) {
            $this$logCannotParseResponseError_u24lambda_u244.add(responseBody);
        }
        Unit unit = Unit.INSTANCE;
        apiClientHelper.logEntry(string2, level, string, n, list, exception);
    }

    private final void logEntry(String prefix, Level logLevel, String requestId, int maxSectionLength, List<String> sections, Exception exception) {
        String sectionsString2 = CollectionsKt.joinToString$default((Iterable)sections, (CharSequence)"; ", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(maxSectionLength){
            final /* synthetic */ int $maxSectionLength;
            {
                this.$maxSectionLength = $maxSectionLength;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.length() > this.$maxSectionLength ? (CharSequence)(StringsKt.take((String)it, (int)this.$maxSectionLength) + "\u2026") : (CharSequence)it;
            }
        }), (int)30, null);
        String logMessage = prefix + " [" + requestId + "]: " + sectionsString2;
        if (exception != null) {
            this.log.log(logLevel, logMessage, exception);
        } else {
            this.log.log(logLevel, logMessage);
        }
    }

    static /* synthetic */ void logEntry$default(ApiClientHelper apiClientHelper, String string, Level level, String string2, int n, List list, Exception exception, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            exception = null;
        }
        apiClientHelper.logEntry(string, level, string2, n, list, exception);
    }

    private final String buildBaseEndpointPath(ApiCredentials credentials) {
        Object object;
        ApiCredentials apiCredentials = credentials;
        if (apiCredentials instanceof ApiStoreCredentials) {
            object = "/api/v3/" + ((ApiStoreCredentials)credentials).getStoreId();
        } else if (apiCredentials instanceof ApiAppCredentials) {
            object = "/api/v3";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HttpMethod.values().length];
            try {
                nArray[HttpMethod.GET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.POST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.PUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HttpMethod.DELETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

