/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.util;

import com.ecwid.apiclient.v3.util.SecurePattern;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u0014\u0010\u0007\u001a\u00020\u0003*\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"FULL_MASKING_THRESHOLD", "", "maskLogString", "", "securePatterns", "", "Lcom/ecwid/apiclient/v3/util/SecurePattern;", "maskSensitive", "unmaskedLength", "ecwid-java-api-client"})
public final class MaskUtilsKt {
    private static final int FULL_MASKING_THRESHOLD = 4;

    @NotNull
    public static final String maskLogString(@NotNull String $this$maskLogString, @NotNull List<SecurePattern> securePatterns) {
        Intrinsics.checkNotNullParameter((Object)$this$maskLogString, (String)"<this>");
        Intrinsics.checkNotNullParameter(securePatterns, (String)"securePatterns");
        String result = $this$maskLogString;
        for (SecurePattern securePattern : securePatterns) {
            Regex regex = securePattern.component1();
            int unmaskedLength = securePattern.component2();
            CharSequence charSequence = result;
            Function1 function1 = (Function1)new Function1<MatchResult, CharSequence>(unmaskedLength){
                final /* synthetic */ int $unmaskedLength;
                {
                    this.$unmaskedLength = $unmaskedLength;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull MatchResult matchResult) {
                    Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
                    String patternValue = (String)matchResult.getGroupValues().get(0);
                    String secureValue = (String)matchResult.getGroupValues().get(1);
                    String maskedSecureValue = MaskUtilsKt.maskSensitive(secureValue, this.$unmaskedLength);
                    return StringsKt.replace$default((String)patternValue, (String)secureValue, (String)maskedSecureValue, (boolean)false, (int)4, null);
                }
            };
            result = regex.replace(charSequence, function1);
        }
        return result;
    }

    @NotNull
    public static final String maskSensitive(@Nullable String $this$maskSensitive, int unmaskedLength) {
        if ($this$maskSensitive == null) {
            return "";
        }
        if ($this$maskSensitive.length() - unmaskedLength < 4) {
            return "***";
        }
        int maskLength = $this$maskSensitive.length() - Math.min(unmaskedLength, $this$maskSensitive.length());
        maskLength = Math.max(maskLength, $this$maskSensitive.length() / 2);
        int maskedFirst = ($this$maskSensitive.length() - maskLength) / 2;
        int maskedLast = maskedFirst + maskLength;
        String string = $this$maskSensitive.substring(0, maskedFirst);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String prefix = string;
        String string2 = $this$maskSensitive.substring(maskedLast);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String suffix = string2;
        return prefix + "***" + suffix;
    }
}

