/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.metric;

import com.ecwid.apiclient.v3.dto.ApiRequest;
import com.ecwid.apiclient.v3.httptransport.HttpRequest;
import com.ecwid.apiclient.v3.httptransport.HttpResponse;
import com.ecwid.apiclient.v3.httptransport.TransportHttpBody;
import com.ecwid.apiclient.v3.impl.RequestInfo;
import com.ecwid.apiclient.v3.metric.CountingInputStream;
import com.ecwid.apiclient.v3.metric.MetricHelpersKt;
import com.ecwid.apiclient.v3.metric.RequestSizeMetricKt;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u00020\u0019*\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/ecwid/apiclient/v3/metric/RequestSizeMetric;", "", "()V", "metric", "Lio/prometheus/client/Histogram;", "makeHttpRequestCountable", "Lcom/ecwid/apiclient/v3/metric/RequestSizeMetric$HttpRequestAndCounter;", "httpRequest", "Lcom/ecwid/apiclient/v3/httptransport/HttpRequest;", "observeRequest", "", "apiRequest", "Lcom/ecwid/apiclient/v3/dto/ApiRequest;", "requestInfo", "Lcom/ecwid/apiclient/v3/impl/RequestInfo;", "size", "Ljava/util/concurrent/atomic/AtomicLong;", "httpResponse", "Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;", "wrapHttpRequestToCountable", "counter", "wrapTransportHttpBodyToCountable", "Lcom/ecwid/apiclient/v3/httptransport/TransportHttpBody;", "httpBody", "countSizeInBytes", "", "", "", "HttpRequestAndCounter", "ecwid-java-api-client"})
@SourceDebugExtension(value={"SMAP\nRequestSizeMetric.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestSizeMetric.kt\ncom/ecwid/apiclient/v3/metric/RequestSizeMetric\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class RequestSizeMetric {
    @NotNull
    public static final RequestSizeMetric INSTANCE = new RequestSizeMetric();
    @NotNull
    private static final Histogram metric;

    private RequestSizeMetric() {
    }

    public final void observeRequest(@NotNull ApiRequest apiRequest, @NotNull RequestInfo requestInfo, @NotNull AtomicLong size, @NotNull HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)apiRequest, (String)"apiRequest");
        Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        String[] stringArray = new String[]{apiRequest.getClass().getSimpleName(), MetricHelpersKt.getFirstPathSegment(requestInfo), requestInfo.getMethod().name(), MetricHelpersKt.extractStatusFromHttpResponse(httpResponse)};
        ((Histogram.Child)metric.labels(stringArray)).observe(size.doubleValue());
    }

    @NotNull
    public final HttpRequestAndCounter makeHttpRequestCountable(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        long parametersSizeInBytes = this.countSizeInBytes(httpRequest.getParams());
        long headersSizeInBytes = this.countSizeInBytes(httpRequest.getHeaders());
        AtomicLong counter = new AtomicLong(parametersSizeInBytes + headersSizeInBytes);
        return new HttpRequestAndCounter(this.wrapHttpRequestToCountable(httpRequest, counter), counter);
    }

    /*
     * WARNING - void declaration
     */
    private final long countSizeInBytes(Map<String, String> $this$countSizeInBytes) {
        Iterable iterable = $this$countSizeInBytes.entrySet();
        int n = 0;
        for (Object t : iterable) {
            void it;
            Map.Entry entry = (Map.Entry)t;
            int n2 = n;
            boolean bl = false;
            int n3 = ((String)it.getKey()).length() + ((String)it.getValue()).length();
            n = n2 + n3;
        }
        return n;
    }

    private final HttpRequest wrapHttpRequestToCountable(HttpRequest httpRequest, AtomicLong counter) {
        HttpRequest httpRequest2;
        HttpRequest httpRequest3 = httpRequest;
        if (httpRequest3 instanceof HttpRequest.HttpDeleteRequest) {
            httpRequest2 = httpRequest;
        } else if (httpRequest3 instanceof HttpRequest.HttpGetRequest) {
            httpRequest2 = httpRequest;
        } else if (httpRequest3 instanceof HttpRequest.HttpPostRequest) {
            httpRequest2 = HttpRequest.HttpPostRequest.copy$default((HttpRequest.HttpPostRequest)httpRequest, null, null, this.wrapTransportHttpBodyToCountable(httpRequest.getTransportHttpBody(), counter), null, 11, null);
        } else if (httpRequest3 instanceof HttpRequest.HttpPutRequest) {
            httpRequest2 = HttpRequest.HttpPutRequest.copy$default((HttpRequest.HttpPutRequest)httpRequest, null, null, this.wrapTransportHttpBodyToCountable(httpRequest.getTransportHttpBody(), counter), null, 11, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return httpRequest2;
    }

    private final TransportHttpBody wrapTransportHttpBodyToCountable(TransportHttpBody httpBody, AtomicLong counter) {
        TransportHttpBody transportHttpBody;
        TransportHttpBody transportHttpBody2 = httpBody;
        if (transportHttpBody2 instanceof TransportHttpBody.ByteArrayBody) {
            TransportHttpBody transportHttpBody3 = httpBody;
            TransportHttpBody.ByteArrayBody it = (TransportHttpBody.ByteArrayBody)transportHttpBody3;
            boolean bl = false;
            counter.addAndGet(((TransportHttpBody.ByteArrayBody)httpBody).getByteArray().length);
            transportHttpBody = transportHttpBody3;
        } else if (Intrinsics.areEqual((Object)transportHttpBody2, (Object)TransportHttpBody.EmptyBody.INSTANCE)) {
            transportHttpBody = httpBody;
        } else if (transportHttpBody2 instanceof TransportHttpBody.InputStreamBody) {
            transportHttpBody = new TransportHttpBody.InputStreamBody(new CountingInputStream(((TransportHttpBody.InputStreamBody)httpBody).getStream(), counter), httpBody.getMimeType());
        } else if (transportHttpBody2 instanceof TransportHttpBody.LocalFileBody) {
            TransportHttpBody transportHttpBody4 = httpBody;
            TransportHttpBody.LocalFileBody it = (TransportHttpBody.LocalFileBody)transportHttpBody4;
            boolean bl = false;
            try {
                counter.addAndGet(((TransportHttpBody.LocalFileBody)httpBody).getFile().length());
            }
            catch (Exception e) {
                RequestSizeMetricKt.access$getLog$p().log(Level.WARNING, "Unable to get file [" + ((TransportHttpBody.LocalFileBody)httpBody).getFile().getAbsolutePath() + "] size", e);
            }
            transportHttpBody = transportHttpBody4;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return transportHttpBody;
    }

    static {
        Object[] objectArray = new double[]{100.0, 500.0, 1000.0, 5000.0, 10000.0, 50000.0, 100000.0, 500000.0, 1000000.0, 5000000.0, 1.0E7, 2.5E7, 5.0E7, 1.0E8};
        Histogram.Builder builder = Histogram.build((String)"ecwid_api_client_request_size_bytes", (String)"Ecwid API client request size of parameters & body in bytes").buckets(objectArray);
        objectArray = new String[4];
        objectArray[0] = (double)"request_type";
        objectArray[1] = (double)"path";
        objectArray[2] = (double)"method";
        objectArray[3] = (double)"status";
        SimpleCollector simpleCollector = ((Histogram.Builder)builder.labelNames((String[])objectArray)).register();
        Intrinsics.checkNotNullExpressionValue((Object)simpleCollector, (String)"register(...)");
        metric = (Histogram)simpleCollector;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/ecwid/apiclient/v3/metric/RequestSizeMetric$HttpRequestAndCounter;", "", "httpRequest", "Lcom/ecwid/apiclient/v3/httptransport/HttpRequest;", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "(Lcom/ecwid/apiclient/v3/httptransport/HttpRequest;Ljava/util/concurrent/atomic/AtomicLong;)V", "getCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "getHttpRequest", "()Lcom/ecwid/apiclient/v3/httptransport/HttpRequest;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ecwid-java-api-client"})
    public static final class HttpRequestAndCounter {
        @NotNull
        private final HttpRequest httpRequest;
        @NotNull
        private final AtomicLong counter;

        public HttpRequestAndCounter(@NotNull HttpRequest httpRequest, @NotNull AtomicLong counter) {
            Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
            Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
            this.httpRequest = httpRequest;
            this.counter = counter;
        }

        @NotNull
        public final HttpRequest getHttpRequest() {
            return this.httpRequest;
        }

        @NotNull
        public final AtomicLong getCounter() {
            return this.counter;
        }

        @NotNull
        public final HttpRequest component1() {
            return this.httpRequest;
        }

        @NotNull
        public final AtomicLong component2() {
            return this.counter;
        }

        @NotNull
        public final HttpRequestAndCounter copy(@NotNull HttpRequest httpRequest, @NotNull AtomicLong counter) {
            Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
            Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
            return new HttpRequestAndCounter(httpRequest, counter);
        }

        public static /* synthetic */ HttpRequestAndCounter copy$default(HttpRequestAndCounter httpRequestAndCounter, HttpRequest httpRequest, AtomicLong atomicLong, int n, Object object) {
            if ((n & 1) != 0) {
                httpRequest = httpRequestAndCounter.httpRequest;
            }
            if ((n & 2) != 0) {
                atomicLong = httpRequestAndCounter.counter;
            }
            return httpRequestAndCounter.copy(httpRequest, atomicLong);
        }

        @NotNull
        public String toString() {
            return "HttpRequestAndCounter(httpRequest=" + this.httpRequest + ", counter=" + this.counter + ")";
        }

        public int hashCode() {
            int result = this.httpRequest.hashCode();
            result = result * 31 + this.counter.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HttpRequestAndCounter)) {
                return false;
            }
            HttpRequestAndCounter httpRequestAndCounter = (HttpRequestAndCounter)other;
            if (!Intrinsics.areEqual((Object)this.httpRequest, (Object)httpRequestAndCounter.httpRequest)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.counter, (Object)httpRequestAndCounter.counter);
        }
    }
}

