/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.metric;

import com.ecwid.apiclient.v3.dto.ApiRequest;
import com.ecwid.apiclient.v3.httptransport.HttpResponse;
import com.ecwid.apiclient.v3.impl.RequestInfo;
import com.ecwid.apiclient.v3.metric.MetricHelpersKt;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/ecwid/apiclient/v3/metric/RequestTimeMetric;", "", "()V", "metric", "Lio/prometheus/client/Histogram;", "observeRequest", "", "apiRequest", "Lcom/ecwid/apiclient/v3/dto/ApiRequest;", "requestInfo", "Lcom/ecwid/apiclient/v3/impl/RequestInfo;", "requestTimeMs", "", "httpResponse", "Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;", "ecwid-java-api-client"})
public final class RequestTimeMetric {
    @NotNull
    public static final RequestTimeMetric INSTANCE = new RequestTimeMetric();
    @NotNull
    private static final Histogram metric;

    private RequestTimeMetric() {
    }

    public final void observeRequest(@NotNull ApiRequest apiRequest, @NotNull RequestInfo requestInfo, long requestTimeMs, @NotNull HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)apiRequest, (String)"apiRequest");
        Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        String[] stringArray = new String[]{apiRequest.getClass().getSimpleName(), MetricHelpersKt.getFirstPathSegment(requestInfo), requestInfo.getMethod().name(), MetricHelpersKt.extractStatusFromHttpResponse(httpResponse)};
        ((Histogram.Child)metric.labels(stringArray)).observe((double)requestTimeMs / 1000.0);
    }

    static {
        Object[] objectArray = new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0, 25.0, 50.0, 100.0, 200.0};
        Histogram.Builder builder = Histogram.build((String)"ecwid_api_client_request_latency", (String)"Ecwid API client request latency").buckets(objectArray);
        objectArray = new String[4];
        objectArray[0] = (double)"request_type";
        objectArray[1] = (double)"path";
        objectArray[2] = (double)"method";
        objectArray[3] = (double)"status";
        SimpleCollector simpleCollector = ((Histogram.Builder)builder.labelNames((String[])objectArray)).register();
        Intrinsics.checkNotNullExpressionValue((Object)simpleCollector, (String)"register(...)");
        metric = (Histogram)simpleCollector;
    }
}

