/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.metric;

import com.ecwid.apiclient.v3.dto.ApiRequest;
import com.ecwid.apiclient.v3.httptransport.HttpResponse;
import com.ecwid.apiclient.v3.impl.RequestInfo;
import com.ecwid.apiclient.v3.metric.MetricHelpersKt;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/ecwid/apiclient/v3/metric/ResponseSizeMetric;", "", "()V", "metric", "Lio/prometheus/client/Histogram;", "observeResponse", "", "apiRequest", "Lcom/ecwid/apiclient/v3/dto/ApiRequest;", "requestInfo", "Lcom/ecwid/apiclient/v3/impl/RequestInfo;", "httpResponse", "Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;", "ecwid-java-api-client"})
public final class ResponseSizeMetric {
    @NotNull
    public static final ResponseSizeMetric INSTANCE = new ResponseSizeMetric();
    @NotNull
    private static final Histogram metric;

    private ResponseSizeMetric() {
    }

    public final void observeResponse(@NotNull ApiRequest apiRequest, @NotNull RequestInfo requestInfo, @NotNull HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)apiRequest, (String)"apiRequest");
        Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        String[] stringArray = new String[]{apiRequest.getClass().getSimpleName(), MetricHelpersKt.getFirstPathSegment(requestInfo), requestInfo.getMethod().name(), MetricHelpersKt.extractStatusFromHttpResponse(httpResponse)};
        ((Histogram.Child)metric.labels(stringArray)).observe((double)httpResponse.getResponseBytes().length);
    }

    static {
        Object[] objectArray = new double[]{100.0, 500.0, 1000.0, 5000.0, 10000.0, 50000.0, 100000.0, 500000.0, 1000000.0, 5000000.0, 1.0E7, 2.5E7, 5.0E7, 1.0E8};
        Histogram.Builder builder = Histogram.build((String)"ecwid_api_client_response_size_bytes", (String)"Ecwid API client response size in bytes").buckets(objectArray);
        objectArray = new String[4];
        objectArray[0] = (double)"request_type";
        objectArray[1] = (double)"path";
        objectArray[2] = (double)"method";
        objectArray[3] = (double)"status";
        SimpleCollector simpleCollector = ((Histogram.Builder)builder.labelNames((String[])objectArray)).register();
        Intrinsics.checkNotNullExpressionValue((Object)simpleCollector, (String)"register(...)");
        metric = (Histogram)simpleCollector;
    }
}

