/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.httptransport.impl;

import com.ecwid.apiclient.v3.httptransport.impl.RateLimitedHttpClientWrapperKt;
import com.ecwid.apiclient.v3.metric.RequestRetrySleepMetric;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0002\u0010\u000eJ'\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014\u00a2\u0006\u0002\u0010\u0015J1\u0010\u0016\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0002\u00a2\u0006\u0002\u0010\u0018J9\u0010\u0019\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0002\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/ecwid/apiclient/v3/httptransport/impl/RateLimitedHttpClientWrapper;", "", "httpClient", "Lorg/apache/http/client/HttpClient;", "defaultRateLimitRetryInterval", "", "maxRateLimitRetryInterval", "totalAttempts", "", "onEverySecondOfWaiting", "Lkotlin/Function1;", "", "beforeEachRequestAttempt", "Lkotlin/Function0;", "(Lorg/apache/http/client/HttpClient;JJILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "execute", "T", "request", "Lorg/apache/http/client/methods/HttpUriRequest;", "responseHandler", "Lorg/apache/http/client/ResponseHandler;", "(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;", "executeWithRetry", "attemptsLeft", "(Lorg/apache/http/client/methods/HttpUriRequest;ILorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;", "process429", "response", "Lorg/apache/http/HttpResponse;", "(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/HttpResponse;ILorg/apache/http/client/ResponseHandler;)Ljava/lang/Object;", "waitSeconds", "waitInterval", "ecwid-java-api-client"})
public class RateLimitedHttpClientWrapper {
    @NotNull
    private final HttpClient httpClient;
    private final long defaultRateLimitRetryInterval;
    private final long maxRateLimitRetryInterval;
    private final int totalAttempts;
    @NotNull
    private final Function1<Long, Unit> onEverySecondOfWaiting;
    @NotNull
    private final Function0<Unit> beforeEachRequestAttempt;

    public RateLimitedHttpClientWrapper(@NotNull HttpClient httpClient, long defaultRateLimitRetryInterval, long maxRateLimitRetryInterval, int totalAttempts, @NotNull Function1<? super Long, Unit> onEverySecondOfWaiting, @NotNull Function0<Unit> beforeEachRequestAttempt) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter(onEverySecondOfWaiting, (String)"onEverySecondOfWaiting");
        Intrinsics.checkNotNullParameter(beforeEachRequestAttempt, (String)"beforeEachRequestAttempt");
        this.httpClient = httpClient;
        this.defaultRateLimitRetryInterval = defaultRateLimitRetryInterval;
        this.maxRateLimitRetryInterval = maxRateLimitRetryInterval;
        this.totalAttempts = totalAttempts;
        this.onEverySecondOfWaiting = onEverySecondOfWaiting;
        this.beforeEachRequestAttempt = beforeEachRequestAttempt;
    }

    public /* synthetic */ RateLimitedHttpClientWrapper(HttpClient httpClient, long l, long l2, int n, Function1 function1, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            l = 10L;
        }
        if ((n2 & 4) != 0) {
            l2 = 60L;
        }
        if ((n2 & 8) != 0) {
            n = 2;
        }
        if ((n2 & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n2 & 0x20) != 0) {
            function0 = 2.INSTANCE;
        }
        this(httpClient, l, l2, n, (Function1<? super Long, Unit>)function1, (Function0<Unit>)function0);
    }

    public final <T> T execute(@NotNull HttpUriRequest request, @NotNull ResponseHandler<T> responseHandler) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseHandler, (String)"responseHandler");
        return this.executeWithRetry(request, this.totalAttempts, responseHandler);
    }

    private final <T> T executeWithRetry(HttpUriRequest request, int attemptsLeft, ResponseHandler<T> responseHandler) {
        this.beforeEachRequestAttempt.invoke();
        return (T)this.httpClient.execute(request, arg_0 -> RateLimitedHttpClientWrapper.executeWithRetry$lambda$0(attemptsLeft, this, request, responseHandler, arg_0));
    }

    private final <T> T process429(HttpUriRequest request, HttpResponse response, int attemptsLeft, ResponseHandler<T> responseHandler) {
        Object object;
        long waitInterval;
        Object object2 = response.getFirstHeader("Retry-After");
        long l = object2 != null && (object2 = object2.getValue()) != null ? Long.parseLong((String)object2) : (waitInterval = this.defaultRateLimitRetryInterval);
        if (waitInterval <= this.maxRateLimitRetryInterval) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            RateLimitedHttpClientWrapperKt.access$getLog$p().info("Request " + request.getURI().getPath() + " rate-limited: waiting " + waitInterval + " seconds...");
            this.waitSeconds(waitInterval, this.onEverySecondOfWaiting);
            RateLimitedHttpClientWrapperKt.access$getLog$p().info("Retrying " + request.getURI().getPath() + " after " + waitInterval + "-s pause...");
            object = this.executeWithRetry(request, attemptsLeft, responseHandler);
        } else {
            RateLimitedHttpClientWrapperKt.access$getLog$p().warning("Request " + request.getURI().getPath() + " rate-limited: too long to wait (" + waitInterval + ").");
            object = responseHandler.handleResponse(response);
        }
        return (T)object;
    }

    private final void waitSeconds(long waitInterval, Function1<? super Long, Unit> onEverySecondOfWaiting) {
        long second = 1L;
        if (second <= waitInterval) {
            while (true) {
                TimeUnit.SECONDS.sleep(1L);
                onEverySecondOfWaiting.invoke((Object)second);
                RequestRetrySleepMetric.INSTANCE.inc();
                if (second == waitInterval) break;
                ++second;
            }
        }
    }

    private static final Object executeWithRetry$lambda$0(int $attemptsLeft, RateLimitedHttpClientWrapper this$0, HttpUriRequest $request, ResponseHandler $responseHandler, HttpResponse response) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$responseHandler, (String)"$responseHandler");
        if (response.getStatusLine().getStatusCode() == 429 && $attemptsLeft > 0) {
            Intrinsics.checkNotNull((Object)response);
            object = this$0.process429($request, response, $attemptsLeft - 1, $responseHandler);
        } else if (response.getStatusLine().getStatusCode() == 429 && $attemptsLeft <= 0) {
            RateLimitedHttpClientWrapperKt.access$getLog$p().warning("Request " + $request.getURI().getPath() + " rate-limited: no more attempts.");
            object = $responseHandler.handleResponse(response);
        } else {
            object = $responseHandler.handleResponse(response);
        }
        return object;
    }
}

