/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.metric;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/ecwid/apiclient/v3/metric/CountingInputStream;", "Ljava/io/InputStream;", "peer", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "(Ljava/io/InputStream;Ljava/util/concurrent/atomic/AtomicLong;)V", "available", "", "close", "", "mark", "readLimit", "markSupported", "", "read", "b", "", "off", "len", "reset", "skip", "", "n", "ecwid-java-api-client"})
public final class CountingInputStream
extends InputStream {
    @NotNull
    private final InputStream peer;
    @NotNull
    private final AtomicLong counter;

    public CountingInputStream(@NotNull InputStream peer, @NotNull AtomicLong counter) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        this.peer = peer;
        this.counter = counter;
    }

    @Override
    public int read() throws IOException {
        int readByte = this.peer.read();
        if (readByte != -1) {
            this.counter.incrementAndGet();
        }
        return readByte;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int readBytes = this.peer.read(b);
        if (readBytes != -1) {
            this.counter.addAndGet(readBytes);
        }
        return readBytes;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int readBytes = this.peer.read(b, off, len);
        if (readBytes != -1) {
            this.counter.addAndGet(readBytes);
        }
        return readBytes;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.peer.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.peer.available();
    }

    @Override
    public void close() throws IOException {
        this.peer.close();
    }

    @Override
    public void mark(int readLimit) {
        this.peer.mark(readLimit);
    }

    @Override
    public void reset() throws IOException {
        this.peer.reset();
    }

    @Override
    public boolean markSupported() {
        return this.peer.markSupported();
    }
}

