/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3.util;

import com.ecwid.apiclient.v3.dto.webhook.Webhook;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ecwid/apiclient/v3/util/WebhooksUtils;", "", "()V", "WEBHOOK_SIGNATURE_HEADER_NAME", "", "isSignatureValid", "", "signature", "webhook", "Lcom/ecwid/apiclient/v3/dto/webhook/Webhook;", "clientSecret", "ecwid-java-api-client"})
public final class WebhooksUtils {
    @NotNull
    public static final WebhooksUtils INSTANCE = new WebhooksUtils();
    @NotNull
    public static final String WEBHOOK_SIGNATURE_HEADER_NAME = "X-Ecwid-Webhook-Signature";

    private WebhooksUtils() {
    }

    @JvmStatic
    public static final boolean isSignatureValid(@Nullable String signature, @Nullable Webhook webhook, @NotNull String clientSecret) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        if (webhook == null || (charSequence = (CharSequence)signature) == null || charSequence.length() == 0) {
            return false;
        }
        byte[] bt = new HmacUtils(HmacAlgorithms.HMAC_SHA_256, clientSecret).hmac(webhook.getEventCreated() + "." + webhook.getEventId());
        String result = Base64.encodeBase64String((byte[])bt);
        return Intrinsics.areEqual((Object)signature, (Object)result);
    }
}

