package com.ecwid.apiclient.v3.dto.customergroup.request

import com.ecwid.apiclient.v3.dto.ApiRequest
import com.ecwid.apiclient.v3.impl.RequestInfo
import com.ecwid.apiclient.v3.responsefields.ResponseFields

data class CustomerGroupsSearchRequest(
	val offset: Int = 0,
	val limit: Int = 100,
	val keyword: String? = null,
	val customerGroupIds: List<Int>? = null,
	val responseFields: ResponseFields = ResponseFields.All,
) : ApiRequest {
	override fun toRequestInfo() = RequestInfo.createGetRequest(
		pathSegments = listOf(
			"customer_groups"
		),
		params = toParams(),
		responseFields = responseFields,
	)

	private fun toParams(): Map<String, String> {
		val request = this
		return mutableMapOf<String, String>().apply {
			put("offset", request.offset.toString())
			put("limit", request.limit.toString())
			if (!request.keyword.isNullOrBlank()) {
				put("keyword", request.keyword)
			}
			if (!request.customerGroupIds.isNullOrEmpty()) {
				put("customerGroupIds", request.customerGroupIds.joinToString(","))
			}
		}.toMap()
	}
}
