/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.apiclient.v3;

import com.ecwid.apiclient.v3.ApiClientHelper$WhenMappings;
import com.ecwid.apiclient.v3.ApiClientHelperKt;
import com.ecwid.apiclient.v3.config.ApiAppCredentials;
import com.ecwid.apiclient.v3.config.ApiCredentials;
import com.ecwid.apiclient.v3.config.ApiServerDomain;
import com.ecwid.apiclient.v3.config.ApiStoreCredentials;
import com.ecwid.apiclient.v3.config.LoggingSettings;
import com.ecwid.apiclient.v3.dto.ApiRequest;
import com.ecwid.apiclient.v3.dto.common.EcwidApiError;
import com.ecwid.apiclient.v3.exception.EcwidApiException;
import com.ecwid.apiclient.v3.exception.JsonDeserializationException;
import com.ecwid.apiclient.v3.httptransport.HttpBody;
import com.ecwid.apiclient.v3.httptransport.HttpRequest;
import com.ecwid.apiclient.v3.httptransport.HttpResponse;
import com.ecwid.apiclient.v3.httptransport.HttpTransport;
import com.ecwid.apiclient.v3.impl.ByteArrayResponseParser;
import com.ecwid.apiclient.v3.impl.ObjectResponseParser;
import com.ecwid.apiclient.v3.impl.ObjectWithExtResponseParser;
import com.ecwid.apiclient.v3.impl.ParsedResponseWithExt;
import com.ecwid.apiclient.v3.impl.RequestInfo;
import com.ecwid.apiclient.v3.impl.ResponseParser;
import com.ecwid.apiclient.v3.impl.StringResponseParser;
import com.ecwid.apiclient.v3.jsontransformer.JsonTransformer;
import com.ecwid.apiclient.v3.jsontransformer.JsonTransformerProvider;
import com.ecwid.apiclient.v3.util.EncodeUtilsKt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eH\u0001J,\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001b2\n\u0010%\u001a\u00060&j\u0002`'H\u0002JB\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010!\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0010\b\u0002\u0010%\u001a\n\u0018\u00010&j\u0004\u0018\u0001`'H\u0002J(\u0010-\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010.\u001a\u00020/2\u0006\u0010$\u001a\u00020\u001bH\u0002J \u00100\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0001J \u00105\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001bH\u0002J.\u00106\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\b\u00107\u001a\u0004\u0018\u00010\u001b2\n\u0010%\u001a\u00060&j\u0002`'H\u0002J\u0011\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0086\bJ\u001e\u0010<\u001a\u0002H=\"\u0006\b\u0000\u0010=\u0018\u00012\u0006\u0010:\u001a\u00020;H\u0086\b\u00a2\u0006\u0002\u0010>J-\u0010?\u001a\u000e\u0012\u0004\u0012\u0002HA\u0012\u0004\u0012\u0002HB0@\"\u0006\b\u0000\u0010A\u0018\u0001\"\u0006\b\u0001\u0010B\u0018\u00012\u0006\u0010:\u001a\u00020;H\u0086\bJ,\u0010C\u001a\u0002H=\"\u0006\b\u0000\u0010=\u0018\u00012\u0006\u0010:\u001a\u00020;2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002H=0EH\u0081\b\u00a2\u0006\u0002\u0010FJ\u0011\u0010G\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020;H\u0086\bJ9\u0010H\u001a\u0002H=\"\u0004\b\u0000\u0010=2\u0006\u0010I\u001a\u00020J2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002H=0EH\u0001\u00a2\u0006\u0002\u0010KJ\f\u0010L\u001a\u000202*\u00020MH\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/ecwid/apiclient/v3/ApiClientHelper;", "", "apiServerDomain", "Lcom/ecwid/apiclient/v3/config/ApiServerDomain;", "storeCredentials", "Lcom/ecwid/apiclient/v3/config/ApiStoreCredentials;", "loggingSettings", "Lcom/ecwid/apiclient/v3/config/LoggingSettings;", "httpTransport", "Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;", "jsonTransformerProvider", "Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformerProvider;", "(Lcom/ecwid/apiclient/v3/config/ApiServerDomain;Lcom/ecwid/apiclient/v3/config/ApiStoreCredentials;Lcom/ecwid/apiclient/v3/config/LoggingSettings;Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformerProvider;)V", "credentials", "Lcom/ecwid/apiclient/v3/config/ApiCredentials;", "(Lcom/ecwid/apiclient/v3/config/ApiServerDomain;Lcom/ecwid/apiclient/v3/config/ApiCredentials;Lcom/ecwid/apiclient/v3/config/LoggingSettings;Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformerProvider;)V", "jsonTransformer", "Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;", "(Lcom/ecwid/apiclient/v3/config/ApiServerDomain;Lcom/ecwid/apiclient/v3/config/ApiCredentials;Lcom/ecwid/apiclient/v3/config/LoggingSettings;Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;)V", "getHttpTransport", "()Lcom/ecwid/apiclient/v3/httptransport/HttpTransport;", "getJsonTransformer", "()Lcom/ecwid/apiclient/v3/jsontransformer/JsonTransformer;", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "buildBaseEndpointPath", "", "createApiEndpointUri", "pathSegments", "", "logCannotParseResponseError", "", "requestId", "requestTime", "", "responseBody", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logEntry", "prefix", "logLevel", "Ljava/util/logging/Level;", "sections", "logErrorResponseIfNeeded", "httpStatusCode", "", "logRequestIfNeeded", "httpRequest", "Lcom/ecwid/apiclient/v3/httptransport/HttpRequest;", "httpBody", "Lcom/ecwid/apiclient/v3/httptransport/HttpBody;", "logSuccessfulResponseIfNeeded", "logTransportErrorResponseIfNeeded", "errorMessage", "makeByteArrayResultRequest", "", "request", "Lcom/ecwid/apiclient/v3/dto/ApiRequest;", "makeObjectResultRequest", "V", "(Lcom/ecwid/apiclient/v3/dto/ApiRequest;)Ljava/lang/Object;", "makeObjectWithExtResultRequest", "Lcom/ecwid/apiclient/v3/impl/ParsedResponseWithExt;", "VBase", "VExt", "makeRequestInt", "responseParser", "Lcom/ecwid/apiclient/v3/impl/ResponseParser;", "(Lcom/ecwid/apiclient/v3/dto/ApiRequest;Lcom/ecwid/apiclient/v3/impl/ResponseParser;)Ljava/lang/Object;", "makeStringResultRequest", "processHttpResponse", "httpResponse", "Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;", "(Lcom/ecwid/apiclient/v3/httptransport/HttpResponse;Ljava/lang/String;JLcom/ecwid/apiclient/v3/impl/ResponseParser;)Ljava/lang/Object;", "toHttpRequest", "Lcom/ecwid/apiclient/v3/impl/RequestInfo;", "ecwid-java-api-client"})
public final class ApiClientHelper {
    private final Logger log;
    private final ApiServerDomain apiServerDomain;
    private final ApiCredentials credentials;
    private final LoggingSettings loggingSettings;
    @NotNull
    private final HttpTransport httpTransport;
    @NotNull
    private final JsonTransformer jsonTransformer;

    @PublishedApi
    public final /* synthetic */ <V> V makeRequestInt(ApiRequest request, ResponseParser<V> responseParser) {
        int $i$f$makeRequestInt = 0;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseParser, (String)"responseParser");
        String requestId = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo = request.toRequestInfo();
        HttpRequest httpRequest = this.toHttpRequest(requestInfo);
        this.logRequestIfNeeded(requestId, httpRequest, requestInfo.getHttpBody());
        long startTime = new Date().getTime();
        HttpResponse httpResponse = this.getHttpTransport().makeHttpRequest(httpRequest);
        return this.processHttpResponse(httpResponse, requestId, new Date().getTime() - startTime, responseParser);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <V> V makeObjectResultRequest(ApiRequest request) {
        void this_$iv;
        int $i$f$makeObjectResultRequest = 0;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ApiClientHelper apiClientHelper = this;
        JsonTransformer jsonTransformer = this.getJsonTransformer();
        Intrinsics.reifiedOperationMarker((int)4, (String)"V");
        ResponseParser responseParser$iv = new ObjectResponseParser<Object>(jsonTransformer, Object.class);
        boolean $i$f$makeRequestInt = false;
        String requestId$iv = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo$iv = request.toRequestInfo();
        HttpRequest httpRequest$iv = this_$iv.toHttpRequest(requestInfo$iv);
        this_$iv.logRequestIfNeeded(requestId$iv, httpRequest$iv, requestInfo$iv.getHttpBody());
        long startTime$iv = new Date().getTime();
        HttpResponse httpResponse$iv = this_$iv.getHttpTransport().makeHttpRequest(httpRequest$iv);
        return this_$iv.processHttpResponse(httpResponse$iv, requestId$iv, new Date().getTime() - startTime$iv, responseParser$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <VBase, VExt> ParsedResponseWithExt<VBase, VExt> makeObjectWithExtResultRequest(ApiRequest request) {
        void this_$iv;
        int $i$f$makeObjectWithExtResultRequest = 0;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ApiClientHelper apiClientHelper = this;
        JsonTransformer jsonTransformer = this.getJsonTransformer();
        Intrinsics.reifiedOperationMarker((int)4, (String)"VBase");
        Intrinsics.reifiedOperationMarker((int)4, (String)"VExt");
        ResponseParser responseParser$iv = new ObjectWithExtResponseParser<Object, Object>(jsonTransformer, Object.class, Object.class);
        boolean $i$f$makeRequestInt = false;
        String requestId$iv = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo$iv = request.toRequestInfo();
        HttpRequest httpRequest$iv = this_$iv.toHttpRequest(requestInfo$iv);
        this_$iv.logRequestIfNeeded(requestId$iv, httpRequest$iv, requestInfo$iv.getHttpBody());
        long startTime$iv = new Date().getTime();
        HttpResponse httpResponse$iv = this_$iv.getHttpTransport().makeHttpRequest(httpRequest$iv);
        return (ParsedResponseWithExt)this_$iv.processHttpResponse(httpResponse$iv, requestId$iv, new Date().getTime() - startTime$iv, responseParser$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] makeByteArrayResultRequest(@NotNull ApiRequest request) {
        void this_$iv;
        int $i$f$makeByteArrayResultRequest = 0;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ApiClientHelper apiClientHelper = this;
        ResponseParser responseParser$iv = new ByteArrayResponseParser();
        boolean $i$f$makeRequestInt = false;
        String requestId$iv = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo$iv = request.toRequestInfo();
        HttpRequest httpRequest$iv = this_$iv.toHttpRequest(requestInfo$iv);
        this_$iv.logRequestIfNeeded(requestId$iv, httpRequest$iv, requestInfo$iv.getHttpBody());
        long startTime$iv = new Date().getTime();
        HttpResponse httpResponse$iv = this_$iv.getHttpTransport().makeHttpRequest(httpRequest$iv);
        return (byte[])this_$iv.processHttpResponse(httpResponse$iv, requestId$iv, new Date().getTime() - startTime$iv, responseParser$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeStringResultRequest(@NotNull ApiRequest request) {
        void this_$iv;
        int $i$f$makeStringResultRequest = 0;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ApiClientHelper apiClientHelper = this;
        ResponseParser responseParser$iv = new StringResponseParser();
        boolean $i$f$makeRequestInt = false;
        String requestId$iv = ApiClientHelperKt.generateRequestId();
        RequestInfo requestInfo$iv = request.toRequestInfo();
        HttpRequest httpRequest$iv = this_$iv.toHttpRequest(requestInfo$iv);
        this_$iv.logRequestIfNeeded(requestId$iv, httpRequest$iv, requestInfo$iv.getHttpBody());
        long startTime$iv = new Date().getTime();
        HttpResponse httpResponse$iv = this_$iv.getHttpTransport().makeHttpRequest(httpRequest$iv);
        return (String)this_$iv.processHttpResponse(httpResponse$iv, requestId$iv, new Date().getTime() - startTime$iv, responseParser$iv);
    }

    @PublishedApi
    public final <V> V processHttpResponse(@NotNull HttpResponse httpResponse, @NotNull String requestId, long requestTime, @NotNull ResponseParser<V> responseParser) {
        V parsedResponse;
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter(responseParser, (String)"responseParser");
        byte[] responseBytes = httpResponse.getResponseBytes();
        HttpResponse httpResponse2 = httpResponse;
        if (httpResponse2 instanceof HttpResponse.Success) {
            try {
                parsedResponse = responseParser.parse(responseBytes);
                String responseBodyForLog = responseParser.getLogString(responseBytes);
                this.logSuccessfulResponseIfNeeded(requestId, requestTime, responseBodyForLog);
            }
            catch (JsonDeserializationException e) {
                this.logCannotParseResponseError(requestId, requestTime, ApiClientHelperKt.asString(responseBytes), e);
                throw (Throwable)new EcwidApiException(null, null, null, e.getMessage(), e, 7, null);
            }
        } else {
            if (httpResponse2 instanceof HttpResponse.Error) {
                try {
                    String responseBody = ApiClientHelperKt.asString(responseBytes);
                    this.logErrorResponseIfNeeded(requestId, requestTime, ((HttpResponse.Error)httpResponse).getStatusCode(), responseBody);
                    EcwidApiError ecwidError = this.jsonTransformer.deserialize(responseBody, EcwidApiError.class);
                    EcwidApiError ecwidApiError = ecwidError;
                    EcwidApiError ecwidApiError2 = ecwidError;
                    throw (Throwable)new EcwidApiException(((HttpResponse.Error)httpResponse).getStatusCode(), ((HttpResponse.Error)httpResponse).getReasonPhrase(), ecwidApiError != null ? ecwidApiError.getErrorCode() : null, ecwidApiError2 != null ? ecwidApiError2.getErrorMessage() : null, null, 16, null);
                }
                catch (JsonDeserializationException e) {
                    throw (Throwable)new EcwidApiException(((HttpResponse.Error)httpResponse).getStatusCode(), ((HttpResponse.Error)httpResponse).getReasonPhrase(), null, e.getMessage(), e, 4, null);
                }
            }
            if (httpResponse2 instanceof HttpResponse.TransportError) {
                this.logTransportErrorResponseIfNeeded(requestId, requestTime, ((HttpResponse.TransportError)httpResponse).getException().getMessage(), ((HttpResponse.TransportError)httpResponse).getException());
                throw (Throwable)new EcwidApiException(null, null, null, ((HttpResponse.TransportError)httpResponse).getException().getMessage(), ((HttpResponse.TransportError)httpResponse).getException(), 7, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return parsedResponse;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final void logRequestIfNeeded(@NotNull String requestId, @NotNull HttpRequest httpRequest, @NotNull HttpBody httpBody) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)httpBody, (String)"httpBody");
        if (!this.loggingSettings.getLogRequest()) {
            return;
        }
        Map params = this.loggingSettings.getMaskRequestApiToken() ? ApiClientHelperKt.access$withMaskedApiTokenParam(httpRequest.getParams()) : httpRequest.getParams();
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List list2 = list;
        String string = requestId;
        Level level = Level.INFO;
        String string2 = "Request";
        ApiClientHelper apiClientHelper = this;
        boolean bl4 = false;
        $this$apply.add(httpRequest.getMethod() + ' ' + httpRequest.getUri());
        $this$apply.add(ApiClientHelperKt.access$dumpToString(params));
        if (this.loggingSettings.getLogRequestBody()) {
            String string3 = httpBody.asString();
            if (string3 != null) {
                String string4 = string3;
                boolean bl5 = false;
                boolean bl6 = false;
                String it = string4;
                boolean bl7 = false;
                $this$apply.add(it);
            }
        }
        Unit unit = Unit.INSTANCE;
        ApiClientHelper.logEntry$default(apiClientHelper, string2, level, string, list, null, 16, null);
    }

    @PublishedApi
    @NotNull
    public final HttpRequest toHttpRequest(@NotNull RequestInfo $this$toHttpRequest) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter((Object)$this$toHttpRequest, (String)"$this$toHttpRequest");
        switch (ApiClientHelper$WhenMappings.$EnumSwitchMapping$0[$this$toHttpRequest.getMethod().ordinal()]) {
            case 1: {
                httpRequest = new HttpRequest.HttpGetRequest(this.createApiEndpointUri($this$toHttpRequest.getPathSegments()), ApiClientHelperKt.withCredentialsParams($this$toHttpRequest.getParams(), this.credentials));
                break;
            }
            case 2: {
                httpRequest = new HttpRequest.HttpPostRequest(this.createApiEndpointUri($this$toHttpRequest.getPathSegments()), ApiClientHelperKt.withCredentialsParams($this$toHttpRequest.getParams(), this.credentials), ApiClientHelperKt.prepare($this$toHttpRequest.getHttpBody(), this.jsonTransformer));
                break;
            }
            case 3: {
                httpRequest = new HttpRequest.HttpPutRequest(this.createApiEndpointUri($this$toHttpRequest.getPathSegments()), ApiClientHelperKt.withCredentialsParams($this$toHttpRequest.getParams(), this.credentials), ApiClientHelperKt.prepare($this$toHttpRequest.getHttpBody(), this.jsonTransformer));
                break;
            }
            case 4: {
                httpRequest = new HttpRequest.HttpDeleteRequest(this.createApiEndpointUri($this$toHttpRequest.getPathSegments()), ApiClientHelperKt.withCredentialsParams($this$toHttpRequest.getParams(), this.credentials));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpRequest;
    }

    @PublishedApi
    @NotNull
    public final String createApiEndpointUri(@NotNull List<String> pathSegments) {
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        URI uri = new URI("https", null, this.apiServerDomain.getHost(), this.apiServerDomain.getSecurePort() == 443 ? -1 : this.apiServerDomain.getSecurePort(), null, null, null);
        String encodedPath = this.buildBaseEndpointPath(this.credentials) + "/" + EncodeUtilsKt.buildEndpointPath(pathSegments);
        return uri.toString() + encodedPath;
    }

    /*
     * WARNING - void declaration
     */
    private final void logSuccessfulResponseIfNeeded(String requestId, long requestTime, String responseBody) {
        void $this$apply;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List list2 = list;
        String string = requestId;
        Level level = Level.INFO;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl4 = false;
        $this$apply.add("OK");
        $this$apply.add(requestTime + " ms");
        if (this.loggingSettings.getLogSuccessfulResponseBody()) {
            $this$apply.add(responseBody);
        }
        Unit unit = Unit.INSTANCE;
        ApiClientHelper.logEntry$default(apiClientHelper, string2, level, string, list, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void logErrorResponseIfNeeded(String requestId, long requestTime, int httpStatusCode, String responseBody) {
        void $this$apply;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List list2 = list;
        String string = requestId;
        Level level = Level.INFO;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl4 = false;
        $this$apply.add("ERR " + httpStatusCode);
        $this$apply.add(requestTime + " ms");
        if (this.loggingSettings.getLogFailedResponseBody()) {
            $this$apply.add(responseBody);
        }
        Unit unit = Unit.INSTANCE;
        ApiClientHelper.logEntry$default(apiClientHelper, string2, level, string, list, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void logTransportErrorResponseIfNeeded(String requestId, long requestTime, String errorMessage, Exception exception) {
        void $this$apply;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List list2 = list;
        String string = requestId;
        Level level = Level.WARNING;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl4 = false;
        $this$apply.add("ERR");
        $this$apply.add(requestTime + " ms");
        if (errorMessage != null) {
            $this$apply.add(errorMessage);
        }
        Unit unit = Unit.INSTANCE;
        apiClientHelper.logEntry(string2, level, string, list, exception);
    }

    /*
     * WARNING - void declaration
     */
    private final void logCannotParseResponseError(String requestId, long requestTime, String responseBody, Exception exception) {
        void $this$apply;
        if (!this.loggingSettings.getLogResponse()) {
            return;
        }
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List list2 = list;
        String string = requestId;
        Level level = Level.WARNING;
        String string2 = "Response";
        ApiClientHelper apiClientHelper = this;
        boolean bl4 = false;
        $this$apply.add("ERR");
        $this$apply.add(requestTime + " ms");
        if (this.loggingSettings.getLogFailedResponseBody()) {
            $this$apply.add(responseBody);
        }
        Unit unit = Unit.INSTANCE;
        apiClientHelper.logEntry(string2, level, string, list, exception);
    }

    private final void logEntry(String prefix, Level logLevel, String requestId, List<String> sections, Exception exception) {
        String logMessage = prefix + " [" + requestId + "]: " + CollectionsKt.joinToString$default((Iterable)sections, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
        if (exception != null) {
            this.log.log(logLevel, logMessage, exception);
        } else {
            this.log.log(logLevel, logMessage);
        }
    }

    static /* synthetic */ void logEntry$default(ApiClientHelper apiClientHelper, String string, Level level, String string2, List list, Exception exception, int n, Object object) {
        if ((n & 0x10) != 0) {
            exception = null;
        }
        apiClientHelper.logEntry(string, level, string2, list, exception);
    }

    private final String buildBaseEndpointPath(ApiCredentials credentials) {
        String string;
        ApiCredentials apiCredentials = credentials;
        if (apiCredentials instanceof ApiStoreCredentials) {
            string = "/api/v3/" + ((ApiStoreCredentials)credentials).getStoreId();
        } else if (apiCredentials instanceof ApiAppCredentials) {
            string = "/api/v3";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    @NotNull
    public final JsonTransformer getJsonTransformer() {
        return this.jsonTransformer;
    }

    private ApiClientHelper(ApiServerDomain apiServerDomain, ApiCredentials credentials, LoggingSettings loggingSettings, HttpTransport httpTransport, JsonTransformer jsonTransformer) {
        this.apiServerDomain = apiServerDomain;
        this.credentials = credentials;
        this.loggingSettings = loggingSettings;
        this.httpTransport = httpTransport;
        this.jsonTransformer = jsonTransformer;
        this.log = Logger.getLogger(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName());
    }

    public ApiClientHelper(@NotNull ApiServerDomain apiServerDomain, @NotNull ApiStoreCredentials storeCredentials, @NotNull LoggingSettings loggingSettings, @NotNull HttpTransport httpTransport, @NotNull JsonTransformerProvider jsonTransformerProvider) {
        Intrinsics.checkNotNullParameter((Object)apiServerDomain, (String)"apiServerDomain");
        Intrinsics.checkNotNullParameter((Object)storeCredentials, (String)"storeCredentials");
        Intrinsics.checkNotNullParameter((Object)loggingSettings, (String)"loggingSettings");
        Intrinsics.checkNotNullParameter((Object)httpTransport, (String)"httpTransport");
        Intrinsics.checkNotNullParameter((Object)jsonTransformerProvider, (String)"jsonTransformerProvider");
        this(apiServerDomain, (ApiCredentials)storeCredentials, loggingSettings, httpTransport, jsonTransformerProvider.build(CollectionsKt.listOf((Object)ApiClientHelperKt.access$createProductOptionsPolymorphicType())));
    }

    public ApiClientHelper(@NotNull ApiServerDomain apiServerDomain, @NotNull ApiCredentials credentials, @NotNull LoggingSettings loggingSettings, @NotNull HttpTransport httpTransport, @NotNull JsonTransformerProvider jsonTransformerProvider) {
        Intrinsics.checkNotNullParameter((Object)apiServerDomain, (String)"apiServerDomain");
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)loggingSettings, (String)"loggingSettings");
        Intrinsics.checkNotNullParameter((Object)httpTransport, (String)"httpTransport");
        Intrinsics.checkNotNullParameter((Object)jsonTransformerProvider, (String)"jsonTransformerProvider");
        this(apiServerDomain, credentials, loggingSettings, httpTransport, jsonTransformerProvider.build(CollectionsKt.listOf((Object)ApiClientHelperKt.access$createProductOptionsPolymorphicType())));
    }
}

