/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.ec.service.user;

import com.eduworks.ec.remote.EcRemote;
import com.eduworks.ec.remote.FormData;
import com.eduworks.ec.service.user.model.EcLoginCredentials;
import com.eduworks.ec.service.user.model.User;
import org.stjs.javascript.Global;
import org.stjs.javascript.JSGlobal;
import org.stjs.javascript.JSObjectAdapter;
import org.stjs.javascript.functions.Callback1;

public class SessionManager {
    private static final String LOGIN = "login";
    private static String selectedServer = "http://localhost:9722/api";
    private static String sessionId = "";
    private static boolean isLoggedIn = false;
    private static User currentUser = null;

    public static void setServer(String server) {
        selectedServer = server;
    }

    public static String getSessionId() {
        if (sessionId == null) {
            sessionId = (String)Global.sessionStorage.$get("ecSessionId");
        }
        return sessionId;
    }

    private static void setSessionId(String id) {
        sessionId = id;
        Global.sessionStorage.$put("ecSessionId", (Object)sessionId);
    }

    public static void clearSessionId() {
        Global.sessionStorage.$delete("ecSessionId");
    }

    public static boolean getLoggedIn() {
        return isLoggedIn;
    }

    public static User getCurrentUser() {
        String userObj;
        if (currentUser == null && (userObj = (String)Global.sessionStorage.$get("currentUser")) != null) {
            currentUser = User._parse(JSGlobal.JSON.parse(userObj));
        }
        return currentUser;
    }

    public static void setCurrentUser(User user) {
        currentUser = user;
        Global.sessionStorage.$put("currentUser", (Object)JSGlobal.JSON.stringify((Object)currentUser));
    }

    public static void clearCurrentUser() {
        currentUser = null;
        Global.sessionStorage.$delete("currentUser");
    }

    public static void login(String username, String password, final Callback1<Object> success, final Callback1<String> fail) {
        EcLoginCredentials c = new EcLoginCredentials(username, password);
        FormData fd = new FormData();
        fd.append("user", JSGlobal.JSON.stringify((Object)c));
        EcRemote.postExpectingObject((String)selectedServer, (String)LOGIN, (FormData)fd, (Callback1)new Callback1<Object>(){

            public void $invoke(Object object) {
                SessionManager.setSessionId((String)JSObjectAdapter.$properties((Object)object).$get("sessionId"));
                SessionManager.setCurrentUser(User._parse(object));
                isLoggedIn = true;
                if (success != null) {
                    success.$invoke(object);
                }
            }
        }, (Callback1)new Callback1<String>(){

            public void $invoke(String p1) {
                SessionManager.clearSessionId();
                SessionManager.clearCurrentUser();
                isLoggedIn = false;
                if (fail != null) {
                    fail.$invoke((Object)p1);
                }
            }
        });
    }

    public static void logout(Callback1<Object> success, Callback1<String> fail) {
        SessionManager.clearCurrentUser();
        if (success != null) {
            success.$invoke(null);
        }
    }

    static {
        sessionId = (String)Global.sessionStorage.$get("ecSessionId");
        String userObj = (String)Global.sessionStorage.$get("currentUser");
        if (userObj != null && sessionId != null) {
            isLoggedIn = true;
            currentUser = User._parse(JSGlobal.JSON.parse(userObj));
        }
    }
}

