/**
 *  Manages the Current User and SessionId information, stores the sessionId in the browser session storage
 *  for now (we could change this or try setting it on startup later).
 * 
 *  @author djunker
 */
var SessionManager = function() {};
SessionManager = stjs.extend(SessionManager, null, [], function(constructor, prototype) {
    constructor.LOGIN = "login";
    constructor.selectedServer = "http://localhost:9722/api";
    constructor.sessionId = "";
    constructor.isLoggedIn = false;
    constructor.currentUser = null;
    constructor.setServer = function(server) {
        SessionManager.selectedServer = server;
    };
    constructor.getSessionId = function() {
        if (SessionManager.sessionId == null) {
            SessionManager.sessionId = sessionStorage["ecSessionId"];
        }
        return SessionManager.sessionId;
    };
    constructor.setSessionId = function(id) {
        SessionManager.sessionId = id;
        sessionStorage["ecSessionId"] = SessionManager.sessionId;
    };
    constructor.clearSessionId = function() {
        delete sessionStorage["ecSessionId"];
    };
    constructor.getLoggedIn = function() {
        return SessionManager.isLoggedIn;
    };
    constructor.getCurrentUser = function() {
        if (SessionManager.currentUser == null) {
            var userObj = sessionStorage["currentUser"];
            if (userObj != null) 
                SessionManager.currentUser = User._parse(JSON.parse(userObj));
        }
        return SessionManager.currentUser;
    };
    constructor.setCurrentUser = function(user) {
        SessionManager.currentUser = user;
        sessionStorage["currentUser"] = JSON.stringify(SessionManager.currentUser);
    };
    constructor.clearCurrentUser = function() {
        SessionManager.currentUser = null;
        delete sessionStorage["currentUser"];
    };
    constructor.login = function(username, password, success, fail) {
        var c = new EcLoginCredentials(username, password);
        var fd = new FormData();
        fd.append("user", JSON.stringify(c));
        EcRemote.postExpectingObject(SessionManager.selectedServer, SessionManager.LOGIN, fd, function(object) {
            SessionManager.setSessionId((object)["sessionId"]);
            SessionManager.setCurrentUser(User._parse(object));
            SessionManager.isLoggedIn = true;
            if (success != null) 
                success(object);
        }, function(p1) {
            SessionManager.clearSessionId();
            SessionManager.clearCurrentUser();
            SessionManager.isLoggedIn = false;
            if (fail != null) 
                fail(p1);
        });
    };
    constructor.logout = function(success, fail) {
        SessionManager.clearCurrentUser();
        if (success != null) 
            success(null);
    };
}, {currentUser: "User"}, {});
(function() {
    SessionManager.sessionId = sessionStorage["ecSessionId"];
    var userObj = sessionStorage["currentUser"];
    if (userObj != null && SessionManager.sessionId != null) {
        SessionManager.isLoggedIn = true;
        SessionManager.currentUser = User._parse(JSON.parse(userObj));
    }
})();
