var User = function(id, loginDate, ip) {
    this.userId = id;
    this.lastLogin = new Date(parseInt(loginDate));
    this.lastIp = ip;
};
User = stjs.extend(User, null, [], function(constructor, prototype) {
    prototype.userId = null;
    prototype.lastLogin = null;
    prototype.lastIp = null;
    constructor._parse = function(obj) {
        if (obj == null) 
            return null;
        var userId, loginDate, lastIp;
        userId = (obj)["userId"];
        loginDate = (obj)["lastLogin"];
        lastIp = (obj)["lastIp"];
        return new User(userId, loginDate, lastIp);
    };
    constructor.createUser = function(username, password, success, failure) {
        UserManager.createUser(username, password, function(p1) {
            if (success != null) 
                success(p1);
        }, failure);
    };
    prototype.getUserId = function() {
        return this.userId;
    };
    prototype.getLastLogin = function() {
        return this.lastLogin;
    };
    prototype.getLastIp = function() {
        return this.lastIp;
    };
}, {lastLogin: "Date"}, {});
