/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.lang;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public class EwList<E>
extends ArrayList<E>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public EwList() {
    }

    public EwList(int size) {
        super(size);
    }

    public EwList(E[] that) {
        this.addAll(that);
    }

    public EwList(Collection<? extends E> that) {
        if (that != null) {
            this.addAll(that);
        }
    }

    public EwList(List<Object> that) {
        for (Object o : that) {
            this.add(o);
        }
    }

    public EwList(AbstractCollection<E> that) {
        this.addAll(that);
    }

    public EwList(JSONArray ja) {
        if (ja != null) {
            for (int i = 0; i < ja.length(); ++i) {
                if (ja.isNull(i)) continue;
                try {
                    this.add(ja.get(i));
                    continue;
                }
                catch (JSONException e) {
                    try {
                        throw new RuntimeException("Types differ: " + ja.get(i).toString());
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    public EwList(Object object) {
        if (object instanceof AbstractCollection) {
            this.addAll((AbstractCollection)object);
        } else if (object instanceof JSONArray) {
            JSONArray ja = (JSONArray)object;
            for (int i = 0; i < ja.length(); ++i) {
                if (ja.isNull(i)) continue;
                try {
                    this.add(ja.get(i));
                    continue;
                }
                catch (JSONException e) {
                    try {
                        throw new RuntimeException("Types differ: " + ja.get(i));
                    }
                    catch (JSONException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        } else {
            this.add(object);
        }
    }

    public boolean containsAny(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (!this.contains(e.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(Collection<?> c, Comparator<E> comparator) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (!this.contains(e.next(), comparator)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(E[] c) {
        for (int i = 0; i < c.length; ++i) {
            if (!this.contains(c[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsByToString(String str) {
        for (Object e : this) {
            if (!e.toString().equals(str)) continue;
            return true;
        }
        return false;
    }

    public String join(String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public int indexOfByObject(E e) {
        int i = 0;
        for (Object e2 : this) {
            if (e == e2) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        try {
            return super.equals(o);
        }
        catch (StackOverflowError e) {
            e.printStackTrace();
            return false;
        }
    }

    public EwList<E> trimEmpty() {
        EwList list = new EwList();
        for (Object e : this) {
            if (e == null || e.toString() == "") continue;
            list.add(e);
        }
        return list;
    }

    public String combine(String delim) {
        StringBuilder sb = new StringBuilder();
        for (Object e : this) {
            if (e != this.get(0)) {
                sb.append(delim);
            }
            sb.append(e.toString());
        }
        return sb.toString();
    }

    public AbstractCollection<String> toStrings() {
        EwList<String> list = new EwList<String>();
        for (Object e : this) {
            if (e == null) continue;
            list.add(e.toString());
        }
        return list;
    }

    public String[] toStringArray() {
        String[] list = new String[this.size()];
        int i = 0;
        for (Object e : this) {
            list[i++] = e.toString();
        }
        return list;
    }

    public EwList<String> toStringsEwList() {
        return (EwList)this.toStrings();
    }

    public Set<String> toStringsSet() {
        HashSet<String> list = new HashSet<String>();
        for (Object e : this) {
            list.add(e.toString());
        }
        return list;
    }

    public void addAll(AbstractCollection<E> objects) {
        for (E e : objects) {
            this.add(e);
        }
    }

    public void addAll(E[] that) {
        for (E e : that) {
            this.add(e);
        }
    }

    public void addAllNoDuplicate(AbstractCollection<E> objects) {
        for (E e : objects) {
            if (this.contains(e)) continue;
            this.add(e);
        }
    }

    public void addAllNoDuplicate(List<E> objects) {
        for (E e : objects) {
            if (this.contains(e)) continue;
            this.add(e);
        }
    }

    public void addAllNoDuplicate(AbstractCollection<E> objects, Comparator<E> comp) {
        for (E e : objects) {
            if (this.contains(e, comp)) continue;
            this.add(e);
        }
    }

    public void addAllNoDuplicate(List<E> objects, Comparator<E> comp) {
        for (E e : objects) {
            if (this.contains(e, comp)) continue;
            this.add(e);
        }
    }

    public boolean contains(E e, Comparator<E> comp) {
        for (Object ee : this) {
            if (comp.compare(e, ee) != 0) continue;
            return true;
        }
        return false;
    }

    public void addAllNoDuplicateByToString(EwList<E> clone) {
        for (Object e : clone) {
            AbstractCollection<String> strings = this.toStrings();
            if (strings.contains(e.toString())) continue;
            this.add(e);
        }
    }

    public void addAllNoDuplicateByToString(E[] clone) {
        for (E e : clone) {
            AbstractCollection<String> strings = this.toStrings();
            if (strings.contains(e.toString())) continue;
            this.add(e);
        }
    }

    public void addAllNoDuplicateByObjectReference(EwList<E> clone) {
        for (Object e : clone) {
            if (this.containsObjectReference(e)) continue;
            this.add(e);
        }
    }

    public void addAllNoDuplicateByObjectReferenceFast(EwList<E> clone) {
        LinkedHashSet hs = new LinkedHashSet(this);
        for (Object e : clone) {
            if (hs.contains(e)) continue;
            hs.add(e);
            this.add(e);
        }
    }

    public boolean containsObjectReference(E e) {
        for (Object e2 : this) {
            if (e != e2) continue;
            return true;
        }
        return false;
    }

    public EwList<E> intersect(EwList<E> organizations, Comparator<E> comparator) {
        EwList list = new EwList();
        for (Object e : this) {
            if (!organizations.contains(e, comparator)) continue;
            list.add(e);
        }
        return list;
    }

    public EwList<E> intersect(AbstractCollection<?> organizations) {
        EwList list = new EwList();
        for (Object e : this) {
            if (!organizations.contains(e)) continue;
            list.add(e);
        }
        return list;
    }

    public EwList<E> intersect(JSONArray organizations) throws JSONException {
        EwList list = new EwList();
        for (Object e : this) {
            for (int i = 0; i < organizations.length(); ++i) {
                if (!organizations.get(i).equals(e)) continue;
                list.add(e);
            }
        }
        return list;
    }

    public EwList<E> union(List<E> that) {
        EwList<E> list = new EwList<E>();
        list.addAll(this);
        if (that != null) {
            list.addAllNoDuplicate(that);
        }
        return list;
    }

    public EwList<E> removeDuplicates() {
        List clone = (List)this.clone();
        this.clear();
        this.addAllNoDuplicate(clone);
        return this;
    }

    public EwList<E> removeDuplicates(Comparator<E> comp) {
        List clone = (List)this.clone();
        this.clear();
        this.addAllNoDuplicate(clone, comp);
        return this;
    }

    public EwList<E> removeDuplicatesCompareByToString() {
        EwList<E> clone = new EwList<E>((List)this.clone());
        this.clear();
        this.addAllNoDuplicateByToString(clone);
        return this;
    }

    public EwList<E> removeDuplicatesByObjectReference() {
        for (int i = 0; i < this.size(); ++i) {
            for (int j = i; j < this.size(); ++j) {
                if (i == j || this.get(i) != this.get(j)) continue;
                this.remove(j);
                j = i;
            }
        }
        return this;
    }

    public void printAll() {
        for (Object e : this) {
            System.out.println(e);
        }
    }

    public int indexOf(E e, int pos) {
        for (int i = pos; i < this.size(); ++i) {
            if (!e.equals(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    public EwList<E> removeWhiteSpace() {
        EwList el = new EwList();
        for (Object e : this) {
            if (e.toString().trim().isEmpty()) continue;
            el.add(e);
        }
        return el;
    }

    public EwList<E> removeEmpty() {
        EwList el = new EwList();
        for (Object e : this) {
            if (e.toString().equals("")) continue;
            el.add(e);
        }
        return el;
    }

    public EwList<E> removeEmptyOnThis() {
        EwList e = new EwList();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).toString().equals("")) continue;
            e.add(this.get(i));
        }
        for (Object x : e) {
            this.remove(x);
        }
        return this;
    }

    public List<E> toNormalList() {
        return new ArrayList(this);
    }

    public boolean containsType(Class<? extends E> class1) {
        for (Object e : this) {
            if (!class1.isInstance(e)) continue;
            return true;
        }
        return false;
    }

    public E get(Class<? extends E> class1) {
        for (Object e : this) {
            if (!class1.isInstance(e)) continue;
            return e;
        }
        return null;
    }

    public static <E extends Comparable<? super E>> List<E> sort(List<E> list) {
        Collections.sort(list);
        return list;
    }

    public static <E> List<E> sort(List<E> list, Comparator<E> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public E last() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(this.size() - 1);
    }

    public E first() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    public EwList<E> first(int count) {
        EwList results = new EwList();
        for (int i = 0; i < count && i < this.size(); ++i) {
            results.add(this.get(i));
        }
        return results;
    }

    public boolean containsIgnoreCase(E e) {
        for (Object e2 : this) {
            if (!e.toString().equalsIgnoreCase(e2.toString())) continue;
            return true;
        }
        return false;
    }

    public int indexOfIgnoreCase(E e) {
        int i = 0;
        for (Object e2 : this) {
            if (e.toString().equalsIgnoreCase(e2.toString())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean containsIgnoreCaseByToString(String e) {
        for (Object e2 : this) {
            if (!e.toString().equalsIgnoreCase(e2.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnyIgnoreCase(AbstractCollection<String> organizationFragments) {
        for (Object e2 : this) {
            for (String e : organizationFragments) {
                if (!e.toString().equalsIgnoreCase(e2.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public EwList<E> reverse() {
        Collections.reverse(this);
        return this;
    }

    public static void ensureSize(ArrayList<?> list, int size) {
        list.ensureCapacity(size);
        while (list.size() < size) {
            list.add(null);
        }
    }
}

