/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.lang.json.impl;

import com.eduworks.lang.json.EwJsonCollection;
import com.eduworks.lang.json.impl.EwJsonObject;
import com.eduworks.lang.util.EwJson;
import com.eduworks.lang.util.EwUri;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Deprecated
public class EwJsonArray
extends JSONArray
implements EwJsonCollection {
    public static EwJsonArray convert(JSONArray array) {
        if (array == null) {
            return null;
        }
        if (array instanceof EwJsonArray) {
            return (EwJsonArray)array;
        }
        try {
            return new EwJsonArray(array);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static EwJsonArray getJSONArray(EwJsonCollection json, Object ref) throws JSONException {
        EwJsonArray jsonArray;
        Object object = json.get(ref);
        if (object instanceof EwJsonArray) {
            return (EwJsonArray)object;
        }
        if (object instanceof JSONArray) {
            return EwJsonArray.convert((JSONArray)object);
        }
        if (object instanceof Collection) {
            return new EwJsonArray((Collection)object);
        }
        if (object instanceof String && (jsonArray = EwJsonArray.convert(EwJson.getJsonArray((String)object))) != null) {
            json.put(ref, jsonArray);
            return jsonArray;
        }
        throw EwJsonArray.buildGetterException(ref, "is not a JSONArray. Is " + object.getClass().getName());
    }

    public static EwJsonArray merge(EwJsonArray into, EwJsonCollection from, Object ref) throws JSONException {
        int putDex;
        if (into == null && from == null) {
            return null;
        }
        if (into == null) {
            return from instanceof EwJsonArray ? (EwJsonArray)from : null;
        }
        if (from == null) {
            return into;
        }
        int index = EwJson.keyToIndex(ref);
        int n = putDex = index >= 0 ? index : into.length();
        if (from instanceof JSONArray) {
            EwJson.merge(into, (JSONArray)from, 0, putDex, from.length());
        } else if (!EwJson.isJson(from) || EwJson.getElements(from) > 0) {
            into.put(putDex, (Object)from);
        }
        return into;
    }

    public static EwJsonArray parse(String source) throws JSONException {
        return EwJsonArray.mergeFromString(null, source, null);
    }

    public static EwJsonArray mergeFromString(JSONArray array, String source, Integer index) throws JSONException {
        int mergeIndex;
        EwJsonArray ewArray;
        EwJsonArray ewJsonArray = ewArray = array == null ? new EwJsonArray() : EwJsonArray.convert(array);
        if (EwJson.isNull(source)) {
            return ewArray;
        }
        JSONTokener tokener = new JSONTokener(source);
        if (tokener.nextClean() != '[') {
            throw tokener.syntaxError("EwJsonArray text must start with '['");
        }
        int n = mergeIndex = index == null || index < 0 ? ewArray.length() : index.intValue();
        if (tokener.nextClean() != ']') {
            tokener.back();
            block4: while (true) {
                if (tokener.nextClean() == ',') {
                    tokener.back();
                    ewArray.put(mergeIndex++, (Object)null);
                } else {
                    tokener.back();
                    ewArray.put(mergeIndex++, tokener.nextValue());
                }
                switch (tokener.nextClean()) {
                    case ']': {
                        break block4;
                    }
                    case ',': 
                    case ';': {
                        if (tokener.nextClean() == ']') break block4;
                        tokener.back();
                        continue block4;
                    }
                    default: {
                        throw tokener.syntaxError("Expected a ',' or ']'");
                    }
                }
                break;
            }
        }
        if (tokener.more()) {
            throw tokener.syntaxError("More unknown characters.");
        }
        return ewArray;
    }

    public static EwJsonCollection tryMergeAny(JSONArray into, Object from, Object ref) throws JSONException {
        if (into == null) {
            return null;
        }
        EwJsonArray converted = EwJsonArray.convert(into);
        if (!EwJson.isNull(from)) {
            Object wrapped = EwJson.wrap(from, true);
            if (wrapped instanceof EwJsonCollection) {
                return EwJsonArray.merge(converted, (EwJsonCollection)wrapped, ref);
            }
            if (EwJson.isValidIndex(ref)) {
                return converted.putOpt(ref, wrapped);
            }
            if (wrapped != null) {
                converted.put(wrapped);
            }
        }
        return converted;
    }

    public EwJsonArray() {
    }

    public EwJsonArray(int size) {
        this();
        while (size > this.length()) {
            super.put(null);
        }
    }

    public EwJsonArray(String source) throws JSONException {
        this();
        EwJsonArray.mergeFromString(this, source, new Integer(0));
    }

    public EwJsonArray(Collection collection) {
        this();
        if (collection != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                this.put(EwJson.wrap(iter.next()));
            }
        }
    }

    public EwJsonArray(EwJsonCollection collection) throws JSONException {
        this();
        EwJsonArray.merge(this, collection, 0);
    }

    public EwJsonArray(Object source) throws JSONException {
        this();
        if (EwJson.isNull(source)) {
            return;
        }
        if (source.getClass().isArray()) {
            int length = Array.getLength(source);
            for (int i = 0; i < length; ++i) {
                this.put(EwJson.wrap(Array.get(source, i)));
            }
        } else if (source instanceof JSONArray) {
            EwJson.merge(this, (JSONArray)source);
        } else if (source instanceof String) {
            EwJsonArray.mergeFromString(this, (String)source, new Integer(0));
        } else {
            EwJsonArray.tryMergeAny(this, source, null);
        }
    }

    @Override
    public EwJsonCollection accumulate(Object ref, Object value) throws JSONException {
        if (!EwJson.isValidIndex(ref)) {
            throw EwJsonArray.buildGetterException(ref, "not found");
        }
        return EwJson.accumulate(this, ref, value);
    }

    @Override
    public boolean contains(Object element) {
        return EwJson.contains(this, element);
    }

    @Override
    public Object get(Object ref) throws JSONException {
        try {
            int keyToIndex = EwJson.keyToIndex(ref);
            if (keyToIndex == -1) {
                return null;
            }
            return super.get(keyToIndex);
        }
        catch (JSONException je) {
            Object object = this.opt(ref);
            if (object == null) {
                throw je;
            }
            return object;
        }
    }

    @Override
    public boolean getBoolean(Object ref) throws JSONException {
        try {
            return EwJson.parseBoolean(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonArray.buildGetterException(ref, "is not a boolean");
        }
    }

    @Override
    public double getDouble(Object ref) throws JSONException {
        try {
            return EwJson.parseDouble(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonArray.buildGetterException(ref, "is not a double");
        }
    }

    @Override
    public int getInt(Object ref) throws JSONException {
        try {
            return EwJson.parseInt(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonArray.buildGetterException(ref, "is not an integer");
        }
    }

    public EwJsonArray getJSONArray(int index) throws JSONException {
        return EwJsonArray.getJSONArray(this, new Integer(index));
    }

    @Override
    public EwJsonArray getJSONArray(Object ref) throws JSONException {
        return EwJsonArray.getJSONArray(this, ref);
    }

    public EwJsonObject getJSONObject(int index) throws JSONException {
        return this.getJSONObject(new Integer(index));
    }

    @Override
    public EwJsonObject getJSONObject(Object ref) throws JSONException {
        try {
            return EwJsonObject.getJSONObject(this, ref);
        }
        catch (JSONException je) {
            throw EwJsonArray.buildGetterException(ref, "is not a JSONObject", je.getMessage());
        }
    }

    @Override
    public EwJsonCollection getJSONCollection(Object ref) throws JSONException {
        EwJsonCollection collection = EwJson.tryConvert(this.opt(ref));
        if (collection != null) {
            return collection;
        }
        throw EwJsonArray.buildGetterException(ref, "is not an EwJsonCollection");
    }

    @Override
    public long getLong(Object ref) throws JSONException {
        try {
            return EwJson.parseLong(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonArray.buildGetterException(ref, "is not a long");
        }
    }

    @Override
    public String getString(Object ref) throws JSONException {
        try {
            return EwJson.parseString(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonArray.buildGetterException(ref, "is not a string");
        }
    }

    @Override
    public EwJsonArray emptyInstance() {
        return new EwJsonArray();
    }

    @Override
    public boolean hasComplex(Object ref) {
        if (this.hasSimple(ref)) {
            return true;
        }
        return !this.isNull(ref);
    }

    @Override
    public boolean hasSimple(Object ref) {
        if (EwJson.isValidIndex(ref)) {
            return !this.isNull(ref);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return super.length() < 1;
    }

    public boolean isNull(int index) {
        return super.isNull(index) || EwJson.isNull(this.opt(index));
    }

    @Override
    public boolean isNull(Object ref) {
        return ref == null || EwJson.isNull(this.opt(ref));
    }

    @Override
    public EwJsonArray merge(EwJsonCollection value) throws JSONException {
        return EwJsonArray.merge(this, value, null);
    }

    @Override
    public EwJsonArray merge(Object value) throws JSONException {
        return (EwJsonArray)EwJsonArray.tryMergeAny(this, value, null);
    }

    public Object opt(int index) {
        return this.opt(new Integer(index), null);
    }

    @Override
    public Object opt(Object ref) {
        return this.opt(ref, null);
    }

    @Override
    public Object opt(Object ref, Object defaultValue) {
        Object object = super.opt(EwJson.keyToIndex(ref));
        if (object == null && ref instanceof String) {
            try {
                if (EwJson.isComplexKey(ref)) {
                    return EwJson.derefComplexKey(this, (String)ref);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return object == null ? defaultValue : object;
    }

    @Override
    public boolean optBoolean(Object ref) {
        return this.optBoolean(ref, false);
    }

    @Override
    public boolean optBoolean(Object ref, boolean defaultValue) {
        try {
            return this.getBoolean(ref);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public double optDouble(Object ref) {
        return this.optDouble(ref, Double.NaN);
    }

    @Override
    public double optDouble(Object ref, double defaultValue) {
        try {
            return this.getDouble(ref);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public int optInt(Object ref) {
        return this.optInt(ref, 0);
    }

    @Override
    public int optInt(Object ref, int defaultValue) {
        try {
            return this.getInt(ref);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public EwJsonArray optJSONArray(int index) {
        return this.optJSONArray(new Integer(index));
    }

    @Override
    public EwJsonArray optJSONArray(Object ref) {
        return this.optJSONArray(ref, (JSONArray)EwJson.DEFAULT_VALUE);
    }

    @Override
    public EwJsonArray optJSONArray(Object ref, JSONArray defaultValue) {
        try {
            return EwJsonArray.getJSONArray(this, ref);
        }
        catch (JSONException jSONException) {
            return EwJsonArray.convert(defaultValue);
        }
    }

    public EwJsonObject optJSONObject(int index) {
        return this.optJSONObject(new Integer(index));
    }

    @Override
    public EwJsonObject optJSONObject(Object ref) {
        return this.optJSONObject(ref, (JSONObject)EwJson.DEFAULT_VALUE);
    }

    @Override
    public EwJsonObject optJSONObject(Object ref, JSONObject defaultValue) {
        try {
            return EwJsonObject.getJSONObject(this, ref);
        }
        catch (JSONException jSONException) {
            return EwJsonObject.convert(defaultValue);
        }
    }

    @Override
    public EwJsonCollection optJSONCollection(Object ref) {
        return this.optJSONCollection(ref, (EwJsonCollection)EwJson.DEFAULT_VALUE);
    }

    @Override
    public EwJsonCollection optJSONCollection(Object ref, EwJsonCollection defaultValue) {
        return EwJson.tryConvert(this.opt(ref));
    }

    @Override
    public long optLong(Object ref) {
        return this.optLong(ref, 0L);
    }

    @Override
    public long optLong(Object ref, long defaultValue) {
        try {
            return this.getLong(ref);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public String optString(Object ref) {
        return this.optString(ref, "");
    }

    @Override
    public String optString(Object ref, String defaultValue) {
        try {
            return this.getString(ref);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public EwJsonArray put(boolean value) {
        return this.put(new Boolean(value));
    }

    @Override
    public EwJsonArray put(Object ref, boolean value) throws JSONException {
        return this.put(ref, (Object)new Boolean(value));
    }

    public EwJsonArray put(Collection value) {
        return this.put((Object)value);
    }

    @Override
    public EwJsonArray put(Object ref, Collection value) throws JSONException {
        return this.put(ref, (Object)value);
    }

    public EwJsonArray put(double value) {
        return this.put(new Double(value));
    }

    @Override
    public EwJsonArray put(Object ref, double value) throws JSONException {
        return this.put(ref, (Object)new Double(value));
    }

    public EwJsonArray put(int value) {
        return this.put(new Integer(value));
    }

    @Override
    public EwJsonArray put(Object ref, int value) throws JSONException {
        return this.put(ref, (Object)new Integer(value));
    }

    public EwJsonArray put(long value) {
        return this.put(new Long(value));
    }

    @Override
    public EwJsonArray put(Object ref, long value) throws JSONException {
        return this.put(ref, (Object)new Long(value));
    }

    public EwJsonArray put(Map value) {
        return this.put((Object)value);
    }

    @Override
    public EwJsonArray put(Object ref, Map value) throws JSONException {
        return this.put(ref, (Object)value);
    }

    @Override
    public EwJsonArray put(Object ref, Object value) throws JSONException {
        return this.put(EwJson.keyToIndex(ref), value);
    }

    public EwJsonArray put(Object value) {
        super.put(EwJson.wrap(value));
        return this;
    }

    public EwJsonArray put(int index, Object value) throws JSONException {
        Object wrapped = EwJson.wrap(value);
        if (EwJson.isNull(wrapped)) {
            super.put(index, null);
        } else {
            super.put(index, wrapped);
        }
        return this;
    }

    @Override
    public EwJsonArray putOpt(Object ref, Object value) {
        return this.putOpt(EwJson.keyToIndex(ref), value);
    }

    @Override
    public EwJsonArray putOnce(Object ref, Object value) throws JSONException {
        return this.putOnce(EwJson.keyToIndex(ref), value);
    }

    @Override
    public Object reduce() {
        return EwJson.reduce(this);
    }

    @Override
    public String urlDecode(Object ref) {
        return EwUri.decodeValue(this.optString(ref));
    }

    @Override
    public String urlEncode(Object ref) {
        return EwUri.encodeValue(this.optString(ref));
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        Object wrapped = EwJson.wrap(object);
        if (this == wrapped) {
            return true;
        }
        if (EwJson.isNull(wrapped)) {
            return false;
        }
        if (wrapped instanceof EwJsonCollection) {
            return EwJson.equals(this, (EwJsonCollection)wrapped);
        }
        return false;
    }

    public EwJsonArray putOpt(Object value) {
        return this.putOpt(this.length(), value);
    }

    public EwJsonArray putOpt(int index, Object value) {
        try {
            this.put(index, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public EwJsonArray putOnce(int index, Object value) throws JSONException {
        Object existing = super.opt(index);
        if (!EwJson.isNull(existing)) {
            throw new JSONException("Duplicate index \"" + index + "\"");
        }
        return this.put(index, value);
    }

    private static JSONException buildGetterException(Object ref, String issue) {
        return EwJsonArray.buildGetterException(ref, issue, null);
    }

    private static JSONException buildGetterException(Object ref, String issue, String description) {
        if (ref == null) {
            ref = "null";
        }
        if (issue == null) {
            issue = "null";
        }
        if (description == null) {
            description = "";
        }
        StringBuilder message = new StringBuilder(32 + issue.length() + description.length());
        message.append("EwJsonArray[").append(ref).append("] ").append(issue);
        if (!description.isEmpty()) {
            message.append(": ").append(description);
        }
        return new JSONException(message.append('.').toString());
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> r = new LinkedHashSet<String>();
        for (int i = 0; i < this.length(); ++i) {
            try {
                r.add(this.getString(i));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return r;
    }

    public Iterator keys() {
        return this.keySet().iterator();
    }
}

