/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.lang.threading;

import com.eduworks.lang.threading.EwThreading;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class ConcurrentBlockingQueue<T>
extends ConcurrentLinkedQueue<T>
implements BlockingQueue<T> {
    @Override
    public void put(T e) throws InterruptedException {
        super.add(e);
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        return super.add(e);
    }

    @Override
    public T take() throws InterruptedException {
        return (T)super.poll();
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        long future = System.nanoTime() + nanos;
        while (System.nanoTime() < future) {
            T t = null;
            Object e = super.poll();
            t = (T)e;
            if (e == null) {
                EwThreading.sleep(10L);
            }
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        Object e;
        int count = 0;
        Object t = null;
        do {
            e = super.poll();
            t = e;
        } while (e != null);
        c.add(t);
        return ++count;
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        Object e;
        int count = 0;
        Object t = null;
        do {
            e = super.poll();
            t = e;
        } while (e != null && maxElements < count);
        c.add(t);
        return ++count;
    }
}

