/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.lang.util;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EwCache<K, V> {
    public static boolean cache = true;
    public static EwCache<String, SoftReference<EwCache<Object, Object>>> caches = new EwCache(20);
    private static final float hashTableLoadFactor = 0.75f;
    private ConcurrentHashMap<K, V> map;
    private int cacheSize;

    public static synchronized EwCache<Object, Object> getCache(String name) {
        return EwCache.getCache(name, 2000);
    }

    public static synchronized EwCache<Object, Object> getCache(String name, int count) {
        EwCache<Object, Object> cacheActual;
        if (!cache) {
            return null;
        }
        SoftReference<EwCache<Object, Object>> cache = caches.get(name);
        if (cache != null && (cacheActual = cache.get()) != null) {
            return cacheActual;
        }
        System.out.println("Creating cache: " + name);
        cacheActual = new EwCache(count);
        caches.put(name, new SoftReference(cacheActual));
        return cacheActual;
    }

    public EwCache(int cacheSize) {
        this.cacheSize = cacheSize;
        int hashTableCapacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.map = new ConcurrentHashMap<K, V>(hashTableCapacity, 0.75f){
            private static final long serialVersionUID = 1L;
        };
    }

    public synchronized V get(K key) {
        if (key == null) {
            return null;
        }
        return this.map.get(key);
    }

    public synchronized void put(K key, V value) {
        if (cache) {
            if (value == null) {
                this.remove(key);
            } else {
                this.map.put(key, value);
            }
        }
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized int usedEntries() {
        return this.map.size();
    }

    public synchronized Collection<Map.Entry<K, V>> getAll() {
        return new ArrayList<Map.Entry<K, V>>(this.map.entrySet());
    }

    public void remove(K name) {
        this.map.remove(name);
    }

    public static void clearAll() {
        caches.clear();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }
}

