/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.net.mail;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public final class EwMail {
    private static Session getSession(String smtpHost, String smtpPort, String smtpUser, String smtpPass) {
        Authenticator authenticator = new Authenticator(smtpUser, smtpPass);
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.submitter", authenticator.getPasswordAuthentication().getUserName());
        properties.setProperty("mail.smtp.auth", Boolean.TRUE.toString());
        properties.setProperty("mail.smtp.host", smtpHost);
        properties.setProperty("mail.smtp.port", smtpPort);
        properties.setProperty("mail.smtp.user", smtpUser);
        properties.setProperty("mail.smtp.timeout", "20000");
        properties.setProperty("mail.smtp.starttls.enable", Boolean.TRUE.toString());
        return Session.getInstance((Properties)properties, (javax.mail.Authenticator)authenticator);
    }

    public static void sendEmail(String smtpHost, String smtpPort, String smtpUser, String smtpPass, String aFromEmailAddr, String aToEmailAddr, String aSubject, String aBody) throws AddressException, MessagingException {
        Session session = EwMail.getSession(smtpHost, smtpPort, smtpUser, smtpPass);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(aFromEmailAddr));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(aToEmailAddr));
        message.setSubject(aSubject);
        message.setText(aBody);
        Transport.send((Message)message);
    }

    public static void sendHtmlEmail(String smtpHost, String smtpPort, String smtpUser, String smtpPass, String aFromEmailAddr, String aToEmailAddr, String aSubject, String aBody) throws AddressException, MessagingException {
        Session session = EwMail.getSession(smtpHost, smtpPort, smtpUser, smtpPass);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(aFromEmailAddr));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(aToEmailAddr));
        message.setSubject(aSubject);
        MimeMultipart mp = new MimeMultipart("related");
        MimeBodyPart bp = new MimeBodyPart();
        bp.setContent((Object)aBody, "text/html");
        mp.addBodyPart((BodyPart)bp);
        message.setContent((Multipart)mp);
        Transport.send((Message)message);
    }

    private static class Authenticator
    extends javax.mail.Authenticator {
        private final PasswordAuthentication authentication;

        public Authenticator(String smtpUser, String smtpPass) {
            this.authentication = new PasswordAuthentication(smtpUser, smtpPass);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

