/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.numerics;

import com.eduworks.lang.EwList;
import com.eduworks.util.Tuple;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EwNumerics {
    public static double[] normalize(double[] list) {
        double max = 0.0;
        for (double ws : list) {
            max = Math.max(max, ws);
        }
        double[] results = new double[list.length];
        for (int i = 0; i < list.length; ++i) {
            results[i] = list[i] / max;
        }
        return results;
    }

    public static double rootMeanSquared(List<Double> value) {
        Double result = 0.0;
        for (Double d : value) {
            result = result + d * d;
        }
        return Math.sqrt(result / (double)value.size());
    }

    public static double sum(List<Double> value) {
        Double result = 0.0;
        for (Double d : value) {
            result = result + d;
        }
        return result;
    }

    public static double rootMeanSquared(JSONArray value) throws JSONException {
        Double result = 0.0;
        for (int i = 0; i < value.length(); ++i) {
            result = result + value.getDouble(i) * value.getDouble(i);
        }
        return Math.sqrt(result / (double)value.length());
    }

    public static double average(List<Double> value) {
        Double result = 0.0;
        for (Double d : value) {
            result = result + d;
        }
        return result / (double)value.size();
    }

    public static double average(JSONArray value) throws JSONException {
        Double result = 0.0;
        for (int i = 0; i < value.length(); ++i) {
            result = result + value.getDouble(i);
        }
        return result / (double)value.length();
    }

    public static Double max(JSONArray objAsJsonArray) throws JSONException {
        Double result = -1.7976931348623157E308;
        for (int i = 0; i < objAsJsonArray.length(); ++i) {
            result = Math.max(result, objAsJsonArray.getDouble(i));
        }
        return result;
    }

    public static Double min(JSONArray objAsJsonArray) throws JSONException {
        Double result = Double.MAX_VALUE;
        for (int i = 0; i < objAsJsonArray.length(); ++i) {
            result = Math.min(result, objAsJsonArray.getDouble(i));
        }
        return result;
    }

    public static double[] calculateCentroid(Collection<double[]> values) {
        double[] centroid = new double[values.iterator().next().length];
        for (double[] value : values) {
            for (int i = 0; i < value.length; ++i) {
                int n = i;
                centroid[n] = centroid[n] + value[i];
            }
        }
        int i = 0;
        while (i < centroid.length) {
            int n = i++;
            centroid[n] = centroid[n] / (double)values.size();
        }
        return centroid;
    }

    public static double distance(double[] centroid, double[] vertex) {
        double result = 0.0;
        for (int i = 0; i < centroid.length; ++i) {
            double sub = vertex[i] - centroid[i];
            result += sub * sub;
        }
        return Math.sqrt(result);
    }

    public static double vectorDistance(JSONObject o1, JSONObject o2) {
        String key = "";
        double result = 0.0;
        Iterator it = o1.keys();
        while (it.hasNext()) {
            double d2;
            double d1;
            if (o2.has(key) && !Double.isNaN(d1 = o1.optDouble(key)) && !Double.isNaN(d2 = o2.optDouble(key))) {
                result += (d2 - d1) * (d2 - d1);
            }
            key = (String)it.next();
        }
        return Math.sqrt(result);
    }

    public static double vectorDistanceAmplified(JSONObject o1, JSONObject o2) {
        String key = "";
        double result = 0.0;
        double count = 0.0;
        Iterator it = o1.keys();
        while (it.hasNext()) {
            double d2;
            double d1;
            if (o2.has(key) && !Double.isNaN(d1 = o1.optDouble(key)) && !Double.isNaN(d2 = o2.optDouble(key))) {
                result += (d2 - d1) * (d2 - d1);
                count += 1.0;
            }
            key = (String)it.next();
        }
        return Math.sqrt(result) / (count * count);
    }

    public static Double max(Collection<Double> values) {
        Double d = Double.MIN_VALUE;
        for (Double dd : values) {
            d = Math.max(d, dd);
        }
        return d;
    }

    public static Tuple<Double, Double> maxGap(Collection<Double> values) {
        EwList<Double> intermediate = new EwList<Double>(values);
        EwList.sort(intermediate);
        HashMap<Double, Tuple<Double, Double>> gapRegistry = new HashMap<Double, Tuple<Double, Double>>();
        Double maxGap = new Double(-2.147483648E9);
        Double oldD = null;
        for (Double d : intermediate) {
            if (oldD != null) {
                Double gap = d - oldD;
                maxGap = Math.max(maxGap, gap);
                gapRegistry.put(gap, new Tuple<Double, Double>(oldD, d));
            }
            oldD = d;
        }
        return (Tuple)gapRegistry.get(maxGap);
    }

    public static Tuple<Double, Double> bestBisect(Collection<Double> values) {
        EwList<Double> intermediate = new EwList<Double>(values);
        EwList.sort(intermediate);
        Double sumsqMin = Double.MAX_VALUE;
        int iMin = 0;
        for (int i = 0; i < values.size(); ++i) {
            Object d2;
            List l1 = intermediate.subList(0, i);
            List l2 = intermediate.subList(i, intermediate.size());
            if (l1.size() == 0 || l2.size() == 0) continue;
            Double avg1 = 0.0;
            for (Object d2 : l1) {
                avg1 = avg1 + (Double)d2;
            }
            avg1 = avg1 / (double)l1.size();
            Double avg2 = 0.0;
            d2 = l2.iterator();
            while (d2.hasNext()) {
                Double d3 = (Double)d2.next();
                avg2 = avg2 + d3;
            }
            avg2 = avg2 / (double)l2.size();
            Double sumsq1 = 0.0;
            for (Double d4 : l1) {
                sumsq1 = sumsq1 + (avg1 - d4) * (avg1 - d4);
            }
            Double sumsq2 = 0.0;
            for (Double d5 : l2) {
                sumsq2 = sumsq2 + (avg2 - d5) * (avg2 - d5);
            }
            if (!(sumsqMin > sumsq1 * 2.0 + sumsq2)) continue;
            sumsqMin = sumsq1 * 2.0 + sumsq2;
            iMin = i;
        }
        List l1 = intermediate.subList(0, iMin);
        List l2 = intermediate.subList(iMin, intermediate.size());
        return new Tuple<Double, Double>((Double)l1.get(l1.size() - 1), (Double)l2.get(0));
    }
}

