/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.util.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class InMemoryFile {
    public String name;
    public String mime;
    public byte[] data;
    public String path;

    public InMemoryFile() {
    }

    public InMemoryFile(File source) throws IOException {
        this.name = source.getName();
        this.data = FileUtils.readFileToByteArray((File)source);
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public File toTemporaryFile() {
        try {
            File f = null;
            f = this.name == null ? File.createTempFile("foo", "unk") : File.createTempFile("foo", this.name);
            FileUtils.writeByteArrayToFile((File)f, (byte[])this.data);
            return f;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.name;
    }
}

