/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.lang;

import com.eduworks.lang.EwHashMap;
import com.eduworks.lang.EwList;
import com.eduworks.lang.EwMap;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import sun.misc.GC;

public class EwCacheMap<E, T>
implements Map<E, T> {
    private static final long serialVersionUID = 1L;
    Map<E, SoftReference<T>> map = Collections.synchronizedMap(new EwMap());
    long lastCleaned = System.currentTimeMillis();

    @Override
    public void clear() {
        this.map.clear();
    }

    private void cull() {
        long current = System.currentTimeMillis() - GC.maxObjectInspectionAge();
        if (current == this.lastCleaned) {
            return;
        }
        if (current < this.lastCleaned + 300000L) {
            return;
        }
        this.lastCleaned = current;
        try {
            EwList<E> removeThese = new EwList<E>();
            for (Map.Entry<E, SoftReference<T>> e : this.map.entrySet()) {
                if (e.getValue().get() != null) continue;
                removeThese.add(e.getKey());
            }
            while (!removeThese.isEmpty()) {
                this.remove(removeThese.remove(0));
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.map.get(arg0) != null;
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.map.containsValue(new WeakReference<Object>(arg0));
    }

    @Override
    public Set<Map.Entry<E, T>> entrySet() {
        EwHashMap set = new EwHashMap();
        for (Map.Entry<E, SoftReference<T>> r : this.map.entrySet()) {
            T value = r.getValue().get();
            if (value == null) continue;
            set.put(r.getKey(), value);
        }
        return set.entrySet();
    }

    @Override
    public T get(Object arg0) {
        this.cull();
        return this.getInner(arg0);
    }

    private T getInner(Object arg0) {
        SoftReference<T> weakReference = this.map.get(arg0);
        if (weakReference != null) {
            return weakReference.get();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (SoftReference<T> t : this.map.values()) {
            if (t.get() == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<E> keySet() {
        return this.map.keySet();
    }

    @Override
    public T put(E arg0, T arg1) {
        this.cull();
        this.map.put(arg0, new SoftReference<T>(arg1));
        return arg1;
    }

    @Override
    public void putAll(Map<? extends E, ? extends T> arg0) {
        for (E e : arg0.keySet()) {
            this.put(e, arg0.get(e));
        }
    }

    @Override
    public T remove(Object arg0) {
        SoftReference<T> remove = this.map.remove(arg0);
        if (remove == null) {
            return null;
        }
        return remove.get();
    }

    @Override
    public int size() {
        int i = 0;
        for (SoftReference<T> t : this.map.values()) {
            if (t.get() == null) continue;
            ++i;
        }
        return i;
    }

    @Override
    public Collection<T> values() {
        EwList<T> results = new EwList<T>();
        for (SoftReference<T> t : this.map.values()) {
            T t2 = t.get();
            if (t2 == null) continue;
            results.add(t2);
        }
        return results;
    }
}

