/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.lang;

public class EwStringUtil {
    public static String join(String[] strings, String delim) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) continue;
            if (i > 0) {
                result.append(delim);
            }
            result.append(strings[i]);
        }
        return result.toString();
    }

    public static String tabs(int tablevel) {
        StringBuilder sb = new StringBuilder(tablevel);
        while (tablevel > 0) {
            sb.append('\t');
            --tablevel;
        }
        return sb.toString();
    }

    public static String spaces(int tablevel) {
        StringBuilder sb = new StringBuilder(tablevel);
        while (tablevel > 0) {
            sb.append(' ');
            --tablevel;
        }
        return sb.toString();
    }

    public static String stringToHTMLString(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastWasBlankChar = true;
                sb.append(' ');
                continue;
            }
            lastWasBlankChar = false;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\n') {
                sb.append("&lt;br/&gt;");
                continue;
            }
            int ci = 0xFFFF & c;
            if (ci < 160) {
                sb.append(c);
                continue;
            }
            sb.append("&#");
            sb.append(new Integer(ci).toString());
            sb.append(';');
        }
        return sb.toString();
    }
}

