/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.lang.json.impl;

import com.eduworks.lang.EwList;
import com.eduworks.lang.json.EwJsonCollection;
import com.eduworks.lang.json.impl.EwJsonArray;
import com.eduworks.lang.util.EwJson;
import com.eduworks.lang.util.EwUri;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Deprecated
public class EwJsonObject
extends JSONObject
implements EwJsonCollection {
    private LinkedHashSet<String> orderedKeys = new LinkedHashSet();
    boolean sortedKeys = false;

    public static EwJsonObject convert(JSONObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EwJsonObject) {
            return (EwJsonObject)object;
        }
        try {
            return new EwJsonObject(object);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static EwJsonObject getJSONObject(EwJsonCollection json, Object ref) throws JSONException {
        EwJsonObject jsonObject;
        Object object = json.get(ref);
        if (object instanceof EwJsonObject) {
            return (EwJsonObject)object;
        }
        if (object instanceof JSONObject) {
            return EwJsonObject.convert((JSONObject)object);
        }
        if (object instanceof Collection) {
            return new EwJsonObject(object);
        }
        if (object instanceof String && (jsonObject = EwJsonObject.convert(EwJson.getJsonObject((String)object))) != null) {
            json.put(ref, jsonObject);
            return jsonObject;
        }
        throw EwJsonObject.buildGetterException(ref, "is not a JSONObject");
    }

    public static EwJsonObject merge(EwJsonObject into, EwJsonCollection from, Object ref) throws JSONException {
        if (into == null && from == null) {
            return null;
        }
        if (into == null) {
            return from instanceof EwJsonObject ? (EwJsonObject)from : null;
        }
        if (from == null) {
            return into;
        }
        if (ref != null) {
            Object existing = into.opt(ref);
            if (EwJson.isJson(existing)) {
                EwJson.tryMerge(existing, from, null);
            } else {
                into.put(ref, (Object)from);
            }
        } else if (from instanceof JSONArray) {
            for (int i = 0; i < from.length(); ++i) {
                into.put(new Integer(i).toString(), EwJson.wrap(from.get(i)));
            }
        } else if (from instanceof JSONObject) {
            EwJson.merge(into, (JSONObject)from);
        }
        return into;
    }

    public static EwJsonObject parse(String source) throws JSONException {
        return EwJsonObject.mergeFromString(null, source, null);
    }

    public static EwJsonObject mergeFromString(JSONObject object, String source, Object ref) throws JSONException {
        boolean putParsed;
        EwJsonObject ewObject;
        EwJsonObject ewJsonObject = ewObject = object == null || ref != null ? new EwJsonObject() : EwJsonObject.convert(object);
        if (EwJson.isNull(source)) {
            return ewObject;
        }
        JSONTokener tokener = new JSONTokener(source);
        if (tokener.nextClean() != '{') {
            throw tokener.syntaxError("EwJsonObject text must begin with '{'");
        }
        block12: while (true) {
            switch (tokener.nextClean()) {
                case '\u0000': {
                    throw tokener.syntaxError("EwJsonObject text must end with '}'");
                }
                case '}': {
                    break block12;
                }
                default: {
                    tokener.back();
                    String key = tokener.nextValue().toString();
                    switch (tokener.nextClean()) {
                        case ':': {
                            break;
                        }
                        case '=': {
                            if (tokener.next() == '>') break;
                            tokener.back();
                            break;
                        }
                        default: {
                            throw tokener.syntaxError("Expected a ':', '=' or '=>' after a key");
                        }
                    }
                    Object next = tokener.nextValue();
                    ewObject.putOnce(key, next);
                    switch (tokener.nextClean()) {
                        case '}': {
                            break block12;
                        }
                        case ',': 
                        case ';': {
                            if (tokener.nextClean() == '}') break block12;
                            tokener.back();
                            break;
                        }
                        default: {
                            throw tokener.syntaxError("Expected a ',' or ';' delimiting a pair");
                        }
                    }
                    continue block12;
                }
            }
            break;
        }
        boolean bl = putParsed = ref != null;
        if (object == null && putParsed) {
            return new EwJsonObject().put(ref, (Object)ewObject);
        }
        if (putParsed) {
            return EwJsonObject.convert(object).put(ref, (Object)ewObject);
        }
        return ewObject;
    }

    public static EwJsonCollection tryMergeAny(JSONObject into, Object from, Object ref) throws JSONException {
        if (into == null) {
            return null;
        }
        EwJsonObject converted = EwJsonObject.convert(into);
        if (!EwJson.isNull(from)) {
            Object wrapped = EwJson.wrap(from, true);
            if (EwJson.isJson(wrapped)) {
                return EwJsonObject.merge(converted, EwJson.tryConvert(wrapped), ref);
            }
            if (wrapped != null && ref instanceof String) {
                return converted.put((String)ref, wrapped);
            }
        }
        return converted;
    }

    public EwJsonObject() {
    }

    public EwJsonObject(String source) throws JSONException {
        this();
        EwJsonObject.mergeFromString(this, source, null);
    }

    public EwJsonObject(Map map) {
        this();
        if (map == null) {
            return;
        }
        try {
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                this.put(entry.getKey(), EwJson.wrap(value));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public EwJsonObject(EwJsonCollection collection) throws JSONException {
        this();
        EwJsonObject.merge(this, collection, null);
    }

    public EwJsonObject(JSONObject object, String[] names) throws JSONException {
        super(object, names);
    }

    public EwJsonObject(Object object, String[] names) throws JSONException {
        super(object, names);
    }

    public EwJsonObject(Object source) throws JSONException {
        this();
        if (EwJson.isNull(source)) {
            return;
        }
        if (source instanceof JSONObject) {
            EwJson.merge(this, (JSONObject)source);
        } else if (source instanceof String) {
            EwJsonObject.mergeFromString(this, (String)source, null);
        } else {
            EwJsonObject.tryMergeAny(this, source, null);
        }
    }

    public EwJsonObject accumulate(String key, Object value) throws JSONException {
        return (EwJsonObject)this.accumulate((Object)key, value);
    }

    @Override
    public EwJsonCollection accumulate(Object ref, Object value) throws JSONException {
        if (ref == null) {
            throw new JSONException("Null key.");
        }
        return EwJson.accumulate(this, ref, value);
    }

    @Override
    public boolean contains(Object element) {
        return EwJson.contains(this, element);
    }

    @Override
    public Object get(Object ref) throws JSONException {
        if (ref == null) {
            throw new JSONException("Null key.");
        }
        String key = ref instanceof String ? (String)ref : ref.toString();
        return super.get(key);
    }

    @Override
    public boolean getBoolean(Object ref) throws JSONException {
        try {
            return EwJson.parseBoolean(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonObject.buildGetterException(ref, "is not a boolean");
        }
    }

    @Override
    public double getDouble(Object ref) throws JSONException {
        try {
            return EwJson.parseDouble(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonObject.buildGetterException(ref, "is not a double");
        }
    }

    @Override
    public int getInt(Object ref) throws JSONException {
        try {
            return EwJson.parseInt(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonObject.buildGetterException(ref, "is not an integer");
        }
    }

    public EwJsonArray getJSONArray(String key) throws JSONException {
        return this.getJSONArray((Object)key);
    }

    @Override
    public EwJsonArray getJSONArray(Object ref) throws JSONException {
        try {
            return EwJsonArray.getJSONArray(this, ref);
        }
        catch (JSONException je) {
            throw EwJsonObject.buildGetterException(ref, "is not a JSONArray", je.getMessage());
        }
    }

    public EwJsonObject getJSONObject(String key) throws JSONException {
        return EwJsonObject.getJSONObject(this, key);
    }

    @Override
    public EwJsonObject getJSONObject(Object ref) throws JSONException {
        return EwJsonObject.getJSONObject(this, ref);
    }

    @Override
    public EwJsonCollection getJSONCollection(Object ref) throws JSONException {
        EwJsonCollection collection = EwJson.tryConvert(this.opt(ref));
        if (collection != null) {
            return collection;
        }
        throw EwJsonObject.buildGetterException(ref, "is not an EwJsonCollection");
    }

    @Override
    public long getLong(Object ref) throws JSONException {
        try {
            return EwJson.parseLong(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonObject.buildGetterException(ref, "is not a long");
        }
    }

    @Override
    public String getString(Object ref) throws JSONException {
        try {
            return EwJson.parseString(this.get(ref));
        }
        catch (JSONException je) {
            throw EwJsonObject.buildGetterException(ref, "is not a string");
        }
    }

    @Override
    public EwJsonObject emptyInstance() {
        return new EwJsonObject();
    }

    @Override
    public boolean hasComplex(Object ref) {
        if (this.hasSimple(ref)) {
            return true;
        }
        try {
            return EwJson.hasComplexKey(this, (String)ref);
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    @Override
    public boolean hasSimple(Object ref) {
        if (ref instanceof String) {
            return super.has((String)ref);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return super.length() < 1;
    }

    public boolean isNull(String key) {
        return super.isNull(key) || this.isNull((Object)key);
    }

    @Override
    public boolean isNull(Object ref) {
        return ref == null || EwJson.isNull(this.opt(ref));
    }

    @Override
    public String join(String separator) throws JSONException {
        StringBuilder joined = new StringBuilder();
        Iterator keys = this.sortedKeys();
        if (keys.hasNext()) {
            EwJsonObject.joinNextKeyAndValue(this, keys, joined);
            while (keys.hasNext()) {
                EwJsonObject.joinNextKeyAndValue(this, keys, joined.append(separator));
            }
        }
        return joined.toString();
    }

    public Iterator sortedKeys() {
        ArrayList<String> l = new ArrayList<String>(this.keySet());
        Collections.sort(l);
        return l.iterator();
    }

    public EwList<String> keySetUnsorted() {
        EwList<String> results = new EwList<String>();
        Iterator i = this.orderedKeys.iterator();
        while (i.hasNext()) {
            results.add((String)i.next());
        }
        return results;
    }

    @Override
    public EwJsonObject merge(EwJsonCollection value) throws JSONException {
        return EwJsonObject.merge(this, value, null);
    }

    @Override
    public EwJsonObject merge(Object value) throws JSONException {
        return (EwJsonObject)EwJsonObject.tryMergeAny(this, value, null);
    }

    public Object opt(String key) {
        return this.opt(key, null);
    }

    @Override
    public Object opt(Object ref) {
        return this.opt(ref, null);
    }

    @Override
    public Object opt(Object ref, Object defaultValue) {
        if (ref instanceof String) {
            Object object = super.opt((String)ref);
            if (object == null) {
                try {
                    if (EwJson.isComplexKey(ref)) {
                        return EwJson.derefComplexKey(this, (String)ref);
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return object;
        }
        return defaultValue;
    }

    @Override
    public boolean optBoolean(Object ref) {
        return super.optBoolean((String)ref, false);
    }

    @Override
    public boolean optBoolean(Object ref, boolean defaultValue) {
        if (ref instanceof String) {
            return super.optBoolean((String)ref, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public double optDouble(Object ref) {
        return super.optDouble((String)ref, Double.NaN);
    }

    @Override
    public double optDouble(Object ref, double defaultValue) {
        if (ref instanceof String) {
            return super.optDouble((String)ref, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int optInt(Object ref) {
        return super.optInt((String)ref, 0);
    }

    @Override
    public int optInt(Object ref, int defaultValue) {
        if (ref instanceof String) {
            return super.optInt((String)ref, defaultValue);
        }
        return defaultValue;
    }

    public EwJsonArray optJSONArray(String key) {
        return this.optJSONArray((Object)key);
    }

    @Override
    public EwJsonArray optJSONArray(Object ref) {
        return this.optJSONArray(ref, (JSONArray)EwJson.DEFAULT_VALUE);
    }

    @Override
    public EwJsonArray optJSONArray(Object ref, JSONArray defaultValue) {
        try {
            return EwJsonArray.getJSONArray(this, ref);
        }
        catch (JSONException jSONException) {
            return EwJsonArray.convert(defaultValue);
        }
    }

    public EwJsonObject optJSONObject(String key) {
        return this.optJSONObject((Object)key);
    }

    @Override
    public EwJsonObject optJSONObject(Object ref) {
        return this.optJSONObject(ref, (JSONObject)EwJson.DEFAULT_VALUE);
    }

    @Override
    public EwJsonObject optJSONObject(Object ref, JSONObject defaultValue) {
        try {
            return EwJsonObject.getJSONObject(this, ref);
        }
        catch (JSONException jSONException) {
            return EwJsonObject.convert(defaultValue);
        }
    }

    @Override
    public EwJsonCollection optJSONCollection(Object ref) {
        return this.optJSONCollection(ref, (EwJsonCollection)EwJson.DEFAULT_VALUE);
    }

    @Override
    public EwJsonCollection optJSONCollection(Object ref, EwJsonCollection defaultValue) {
        return EwJson.tryConvert(this.opt(ref));
    }

    @Override
    public long optLong(Object ref) {
        return super.optLong((String)ref, 0L);
    }

    @Override
    public long optLong(Object ref, long defaultValue) {
        if (ref instanceof String) {
            return super.optLong((String)ref, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public String optString(Object ref) {
        return super.optString((String)ref, "");
    }

    @Override
    public String optString(Object ref, String defaultValue) {
        if (ref instanceof String) {
            return super.optString((String)ref, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public EwJsonObject put(Object ref, boolean value) throws JSONException {
        return this.put(ref, (Object)new Boolean(value));
    }

    public EwJsonObject put(String key, Collection value) throws JSONException {
        return this.put((Object)key, (Object)value);
    }

    @Override
    public EwJsonObject put(Object ref, Collection value) throws JSONException {
        return this.put(ref, (Object)value);
    }

    @Override
    public EwJsonObject put(Object ref, double value) throws JSONException {
        return this.put(ref, (Object)new Double(value));
    }

    @Override
    public EwJsonObject put(Object ref, int value) throws JSONException {
        return this.put(ref, (Object)new Integer(value));
    }

    @Override
    public EwJsonObject put(Object ref, long value) throws JSONException {
        return this.put(ref, (Object)new Long(value));
    }

    public EwJsonObject put(String key, Map value) throws JSONException {
        return this.put((Object)key, (Object)value);
    }

    @Override
    public EwJsonObject put(Object ref, Map value) throws JSONException {
        return this.put(ref, (Object)value);
    }

    public synchronized EwJsonObject put(String key, Object value) throws JSONException {
        Object wrapped = EwJson.wrap(value);
        this.orderedKeys.add(key);
        if (EwJson.isNull(wrapped)) {
            super.put(key, null);
        } else {
            super.put(key, wrapped);
        }
        return this;
    }

    @Override
    public synchronized EwJsonObject put(Object ref, Object value) throws JSONException {
        if (ref instanceof String) {
            return this.put((String)ref, value);
        }
        throw EwJsonObject.buildGetterException(ref, "is null or is not a string");
    }

    public EwJsonObject putOnce(String key, Object value) throws JSONException {
        return this.put((Object)key, value);
    }

    @Override
    public EwJsonObject putOnce(Object ref, Object value) throws JSONException {
        Object existing = this.opt(ref);
        if (!EwJson.isNull(existing)) {
            throw new JSONException("Duplicate key \"" + (String)ref + "\"");
        }
        return this.put(ref, value);
    }

    @Override
    public EwJsonObject putOpt(Object ref, Object value) {
        try {
            this.put(ref, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Object reduce() {
        return EwJson.reduce(this);
    }

    @Override
    public String urlDecode(Object ref) {
        return EwUri.decodeValue(this.optString(ref));
    }

    @Override
    public String urlEncode(Object ref) {
        return EwUri.encodeValue(this.optString(ref));
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        Object wrapped = EwJson.wrap(object);
        if (this == wrapped) {
            return true;
        }
        if (EwJson.isNull(wrapped)) {
            return false;
        }
        if (wrapped instanceof EwJsonCollection) {
            return EwJson.equals(this, (EwJsonCollection)wrapped);
        }
        return false;
    }

    private static JSONException buildGetterException(Object ref, String issue) {
        return EwJsonObject.buildGetterException(ref, issue, null);
    }

    private static JSONException buildGetterException(Object ref, String issue, String description) {
        if (ref == null) {
            ref = "null";
        }
        if (issue == null) {
            issue = "null";
        }
        if (description == null) {
            description = "";
        }
        StringBuilder message = new StringBuilder(32 + issue.length() + description.length());
        message.append("EwJsonObject.").append(ref).append(' ').append(issue);
        if (!description.isEmpty()) {
            message.append(": ").append(description);
        }
        return new JSONException(message.append('.').toString());
    }

    private static String joinNextKeyAndValue(EwJsonObject json, Iterator keys, StringBuilder joined) throws JSONException {
        String key = keys.next().toString();
        joined.append('\"').append(key).append("\":");
        joined.append(EwJson.valueToString(json.opt(key)));
        return key;
    }

    public Iterator keys() {
        EwList<String> collection = new EwList<String>((AbstractCollection<String>)this.orderedKeys);
        if (this.sortedKeys) {
            EwList.sort(collection);
        }
        return collection.iterator();
    }

    public Object remove(String arg0) {
        this.orderedKeys.remove(arg0);
        return super.remove(arg0);
    }

    @Override
    public Set<String> keySet() {
        LinkedHashSet<String> r = new LinkedHashSet<String>();
        Iterator sortedKeys = this.orderedKeys.iterator();
        while (sortedKeys.hasNext()) {
            r.add((String)sortedKeys.next());
        }
        return r;
    }

    public String toString() {
        this.sortedKeys = true;
        String result = super.toString();
        this.sortedKeys = false;
        return result;
    }
}

