/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.lang.threading;

import com.eduworks.lang.EwList;
import com.eduworks.lang.threading.ConcurrentBlockingQueue;
import java.io.IOException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class EwThreading {
    static List<ThreadPoolExecutor> tpses = Collections.synchronizedList(new EwList());
    static Thread watcher = null;
    static Logger log = Logger.getLogger(EwThreading.class);
    public static int threads = Math.min(50, Math.max(5, Runtime.getRuntime().availableProcessors() * 5));

    public EwThreading() {
        EwThreading.startThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setThreadCount(int threadBoost) {
        List<ThreadPoolExecutor> list = tpses;
        synchronized (list) {
            for (ThreadPoolExecutor tps : tpses) {
                tps.setCorePoolSize(threadBoost);
                tps.setMaximumPoolSize(threadBoost);
            }
        }
    }

    public static long getTaskCount() {
        int taskCount = 0;
        try {
            for (ThreadPoolExecutor tps : tpses) {
                taskCount = (int)((long)taskCount + (tps.getTaskCount() - tps.getCompletedTaskCount()));
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return taskCount;
    }

    public static long getTaskCount(int level) {
        return tpses.get(level).getTaskCount() - tpses.get(level).getCompletedTaskCount();
    }

    private static ThreadPoolExecutor getTps() {
        int level = EwThreading.getThreadLevel();
        if (tpses.size() <= level) {
            return null;
        }
        return tpses.get(level);
    }

    public static int getThreadLevel() {
        int level = 0;
        if (Thread.currentThread().getName().length() > 5) {
            return level;
        }
        try {
            level = Integer.parseInt(Thread.currentThread().getName());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return level;
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static ThreadPoolExecutor getExecutorPool() {
        ThreadPoolExecutor tps = EwThreading.getTps();
        if (tps == null) {
            tps = EwThreading.startThreadPool();
        }
        return tps;
    }

    static synchronized ThreadPoolExecutor startThreadPool() {
        if (EwThreading.getTps() != null) {
            return EwThreading.getTps();
        }
        log.info((Object)("Using " + threads + " number of threads."));
        while (tpses.size() - 1 < EwThreading.getThreadLevel()) {
            tpses.add(new ThreadPoolExecutor(threads, threads, 60L, TimeUnit.SECONDS, new ConcurrentBlockingQueue<Runnable>()));
        }
        int level = tpses.size() - 1;
        try {
            tpses.get(level).allowCoreThreadTimeOut(true);
            tpses.get(level).setThreadFactory(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable arg0) {
                    Thread thread = new Thread(arg0);
                    thread.setPriority(1);
                    return thread;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread thisThread = Thread.currentThread();
        return tpses.get(level);
    }

    public static void forkAccm(MyFutureList placeToAdd, MyRunnable r) {
        placeToAdd.add(EwThreading.fork(r));
    }

    public static void parallel(boolean forkSlowly, MyRunnable ... rs) {
        MyFutureList list = new MyFutureList();
        for (MyRunnable r : rs) {
            EwThreading.forkAccm(list, forkSlowly, r);
        }
        list.nowPause();
    }

    public static void forkAccm(MyFutureList placeToAdd, boolean forkSlowly, MyRunnable r) {
        placeToAdd.add(EwThreading.fork(forkSlowly, r, Integer.MAX_VALUE));
    }

    public static void forkAccm(MyFutureList placeToAdd, boolean forkSlowly, MyRunnable r, int forkLimit) {
        placeToAdd.add(EwThreading.fork(forkSlowly, r, forkLimit));
        if (forkSlowly && placeToAdd.size() % 10000 == 0) {
            log.info((Object)("So far " + placeToAdd.size()));
        }
    }

    public static void fork(int min, int lessthan, MyRunnable r) {
        EwThreading.fork(min, lessthan, false, r);
    }

    public static Future<?> fork(MyRunnable r) {
        return EwThreading.fork(false, r, Integer.MAX_VALUE);
    }

    public static Future<?> fork(boolean forkSlowly, MyRunnable r) {
        return EwThreading.fork(false, r, Integer.MAX_VALUE);
    }

    public static Future<?> fork(boolean forkSlowly, final MyRunnable r, int forkLimit) {
        ThreadPoolExecutor tps = EwThreading.getTps();
        if (tps == null) {
            tps = EwThreading.startThreadPool();
        }
        try {
            Future<2> submit;
            if (forkSlowly || forkLimit != Integer.MAX_VALUE) {
                while (EwThreading.getTaskCount(EwThreading.getThreadLevel()) > (long)threads || EwThreading.getTaskCount(EwThreading.getThreadLevel()) > (long)forkLimit) {
                    EwThreading.sleep(1L);
                }
            }
            final int nextLevel = EwThreading.getThreadLevel() + 1;
            MyRunnable run = new MyRunnable(){
                int level;
                {
                    this.level = nextLevel;
                }

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setName(Integer.toString(this.level));
                        r.run();
                    }
                    catch (RuntimeException e) {
                        this.ex = e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            run.f = submit = tps.submit(run, run);
            r.f = submit;
            return submit;
        }
        catch (RejectedExecutionException e) {
            tpses.remove(EwThreading.getThreadLevel());
            return EwThreading.fork(r);
        }
    }

    public static void foreach(List<?> list, MyRunnable r) {
        for (Object o : list) {
            try {
                MyRunnable clone = (MyRunnable)r.clone();
                clone.o = o;
                clone.run();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void fork(List<?> list, MyRunnable r) {
        EwThreading.fork(list, false, false, r);
    }

    public static void fork(List<?> list, boolean report, MyRunnable r) {
        EwThreading.fork(list, report, false, r);
    }

    public static void fork(List<?> list, boolean report, boolean forkSlowly, MyRunnable r) {
        MyFutureList futures = new MyFutureList();
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            try {
                MyRunnable clone = (MyRunnable)r.clone();
                clone.o = list.get(0);
                clone.run();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (forkSlowly) {
                while (EwThreading.getTaskCount() > (long)(threads / 2)) {
                    EwThreading.sleep(10L);
                }
            }
            try {
                MyRunnable clone = (MyRunnable)r.clone();
                clone.o = list.get(i);
                clone.i = i;
                futures.add(EwThreading.fork(clone));
                continue;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        futures.nowPause(report);
    }

    public static void fork(int min, int lessthan, boolean report, MyRunnable r) {
        MyFutureList futures = new MyFutureList();
        for (int i = min; i < lessthan; ++i) {
            try {
                MyRunnable clone = (MyRunnable)r.clone();
                clone.i = i;
                futures.add(EwThreading.fork(clone));
                continue;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        futures.nowPause(report);
    }

    public static void invokeLater(Runnable runnable) {
        ThreadPoolExecutor tps = EwThreading.getTps();
        if (tps == null) {
            tps = EwThreading.startThreadPool();
        }
        try {
            tps.submit(runnable);
        }
        catch (RejectedExecutionException e) {
            EwThreading.invokeLater(runnable);
        }
    }

    public static void execSynchronous(MyFutureList placeToAdd, MyRunnable myRunnable) {
        myRunnable.run();
    }

    public static abstract class MyRunnable
    implements Runnable,
    Cloneable {
        protected int i;
        public Object o;
        public Future f;
        public Throwable ex;
        public boolean cancel = false;

        public Object clone() throws CloneNotSupportedException {
            Object o2 = super.clone();
            return o2;
        }
    }

    public static class MyFutureList
    extends ConcurrentLinkedQueue<Future<?>> {
        private static final long serialVersionUID = -8460295382838816873L;
        long ms = System.currentTimeMillis();
        long zero = System.currentTimeMillis();
        long count = 0L;

        public void nowPause() {
            this.nowPause(false);
        }

        @Override
        public boolean add(Future<?> fork) {
            ++this.count;
            return super.add(fork);
        }

        public void nowPause(boolean report) {
            int pause = 1;
            Date reportNext = new Date();
            while (true) {
                if (this.count == 0L) {
                    return;
                }
                try {
                    if (System.in.available() >= 1 && System.in.read() == 96) {
                        log.debug((Object)"Aborted.");
                        return;
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                boolean go_on = true;
                int i = 0;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    Future f = (Future)it.next();
                    if (!f.isDone()) {
                        go_on = false;
                        ++i;
                        continue;
                    }
                    try {
                        MyRunnable ex = (MyRunnable)f.get();
                        if (ex != null && ex.ex != null && ex.ex instanceof RuntimeException) {
                            ex.ex.printStackTrace();
                            throw (RuntimeException)ex.ex;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                    it.remove();
                }
                if (go_on) break;
                Date d = new Date();
                d.setTime(d.getTime() - 10000L);
                if (report && reportNext.before(d)) {
                    long current = System.currentTimeMillis();
                    long future = (long)(((double)this.count / (double)(this.count - (long)i) - 1.0) * (double)(current - this.zero) + (double)current);
                    String stuff = "Started: " + new Date(this.zero).toString() + " Estd Done: " + new Date(future).toString();
                    if (this.count - (long)i != 0L) {
                        log.info((Object)("So far " + (this.count - (long)i) + "/" + this.count + "(" + (double)(this.count - (long)i) / (double)this.count + ") " + stuff));
                    }
                    reportNext = new Date();
                }
                try {
                    pause *= 2;
                    pause = Math.min(pause, 100);
                    Thread.sleep(pause);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void nowKill() {
            for (Future f : this) {
                f.cancel(true);
            }
        }
    }
}

