/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.lang.util;

import com.eduworks.interfaces.EwJsonSerializable;
import com.eduworks.lang.EwList;
import com.eduworks.lang.json.EwJsonCollection;
import com.eduworks.lang.json.impl.EwJsonArray;
import com.eduworks.lang.json.impl.EwJsonObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

public class EwJson {
    public static final boolean DEFAULT_BOOLEAN = false;
    public static final double DEFAULT_DOUBLE = Double.NaN;
    public static final int DEFAULT_INT = 0;
    public static final int DEFAULT_INDEX = -1;
    public static final long DEFAULT_LONG = 0L;
    public static final String DEFAULT_STRING = "";
    public static final Object DEFAULT_VALUE = null;
    private static final Pattern KEY_PATTERN = Pattern.compile("\\.");
    private static final char ARR_OPEN = '[';
    private static final char ARR_CLOSE = ']';
    private static final char KEY_DELIM = '.';
    private static final char INDEX_DELIM = ':';

    private EwJson() {
    }

    @Deprecated
    public static EwJsonCollection accumulate(EwJsonCollection json, Object ref, Object value) throws JSONException {
        if (json == null) {
            return null;
        }
        EwJson.validateDecimal(value);
        Object object = json.opt(ref);
        if (EwJson.isNull(object)) {
            json.putOpt(ref, value instanceof JSONArray ? new EwJsonArray().put(value) : value);
        } else if (object instanceof JSONArray) {
            EwJsonArray.convert((JSONArray)object).put(value);
        } else {
            json.putOpt(ref, new EwJsonArray().put(object).put(value));
        }
        return json;
    }

    @Deprecated
    public static boolean contains(JSONArray json, Object element) {
        if (json == null || element == null) {
            return false;
        }
        for (int i = 0; i < json.length(); ++i) {
            try {
                if (!EwJson.elementsEqual(json.get(i), element)) continue;
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    @Deprecated
    public static boolean contains(JSONObject json, Object element) {
        if (json == null || element == null) {
            return false;
        }
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            try {
                if (!EwJson.elementsEqual(json.get((String)keys.next()), element)) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }

    @Deprecated
    public static boolean equals(EwJsonCollection thisOne, EwJsonCollection thatOne) {
        if (thisOne == null && thatOne == null) {
            return true;
        }
        if (thisOne == null || thatOne == null) {
            return false;
        }
        for (String key : thisOne.keySet()) {
            if (!thatOne.hasComplex(key)) {
                return false;
            }
            if (thisOne.opt(key).equals(thatOne.opt(key))) continue;
            return false;
        }
        for (String key : thatOne.keySet()) {
            if (!thisOne.hasComplex(key)) {
                return false;
            }
            if (thatOne.opt(key).equals(thisOne.opt(key))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    private static boolean elementsEqual(Object value, Object element) {
        return value != null && value.equals(element);
    }

    @Deprecated
    public static Set<String> getNodes(EwJsonCollection coll) {
        HashSet<String> nodes;
        block5: {
            block4: {
                nodes = new HashSet<String>();
                if (!(coll instanceof JSONArray)) break block4;
                JSONArray array = (JSONArray)coll;
                for (int i = 0; i < array.length(); ++i) {
                    Object inner = EwJson.wrap(array.opt(i), true);
                    if (inner instanceof EwJsonCollection) {
                        nodes.addAll(EwJson.getNodes((EwJsonCollection)inner));
                        continue;
                    }
                    if (!EwJson.isNode(inner)) continue;
                    nodes.add(inner.toString());
                }
                break block5;
            }
            if (!(coll instanceof JSONObject)) break block5;
            JSONObject object = (JSONObject)coll;
            Iterator keys = object.keys();
            while (keys.hasNext()) {
                Object inner = EwJson.wrap(object.opt((String)keys.next()), true);
                if (inner instanceof EwJsonCollection) {
                    nodes.addAll(EwJson.getNodes((EwJsonCollection)inner));
                    continue;
                }
                if (!EwJson.isNode(inner)) continue;
                nodes.add(inner.toString());
            }
        }
        return nodes;
    }

    @Deprecated
    public static Set<String> getNodesByKey(EwJsonCollection coll, String key) {
        HashSet<String> nodes = new HashSet<String>();
        if (coll instanceof JSONArray) {
            JSONArray array = (JSONArray)coll;
            for (int i = 0; i < array.length(); ++i) {
                Object inner = EwJson.wrap(array.opt(i), true);
                if (!(inner instanceof EwJsonCollection)) continue;
                nodes.addAll(EwJson.getNodesByKey((EwJsonCollection)inner, key));
            }
        } else if (coll instanceof JSONObject) {
            Object inner = EwJson.wrap(coll.opt(key), true);
            if (inner instanceof EwJsonCollection) {
                nodes.addAll(EwJson.getNodesByKey((EwJsonCollection)inner, key));
            } else if (EwJson.isNode(inner)) {
                nodes.add(inner.toString());
            }
        }
        return nodes;
    }

    @Deprecated
    private static boolean isNode(Object node) {
        return node instanceof String && !((String)node).trim().isEmpty();
    }

    @Deprecated
    public static JSONArray merge(JSONArray into, JSONArray from) {
        return EwJson.merge(into, from, 0, into.length(), from.length());
    }

    @Deprecated
    public static JSONArray merge(JSONArray into, JSONArray from, int startCopy, int startPut, int length) {
        if (into == null) {
            return null;
        }
        if (from == null) {
            return into;
        }
        if (!EwJson.isValidIndex(from, startCopy)) {
            return into;
        }
        try {
            int to;
            int limit = startCopy + length;
            int here = to = startPut < 0 ? into.length() : startPut;
            for (int there = startCopy; there < limit && there < from.length(); ++there) {
                into.put(here, EwJson.wrap(from.get(there)));
                ++here;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return into;
    }

    @Deprecated
    public static JSONObject merge(JSONObject into, JSONObject from) {
        if (into == null) {
            return null;
        }
        if (from == null) {
            return into;
        }
        try {
            Iterator keys = from.keys();
            while (keys.hasNext()) {
                String s = (String)keys.next();
                into.put(s, EwJson.wrap(from.get(s)));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return into;
    }

    public static List<String> getKeys(JSONObject edges) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator sortedKeys = edges.keys();
        while (sortedKeys.hasNext()) {
            keys.add((String)sortedKeys.next());
        }
        if (!(edges instanceof EwJsonObject)) {
            EwList.sort(keys);
        }
        return keys;
    }

    public static List getValues(JSONObject edges) throws JSONException {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator sortedKeys = edges.keys();
        while (sortedKeys.hasNext()) {
            values.add(edges.get((String)sortedKeys.next()));
        }
        return values;
    }

    public static List<String> getKeysUnsorted(JSONObject edges) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator unsortedKeys = edges.keys();
        while (unsortedKeys.hasNext()) {
            keys.add((String)unsortedKeys.next());
        }
        return keys;
    }

    public static JSONArray copyFromObject(JSONObject object) throws JSONException {
        EwJsonArray result = new EwJsonArray();
        for (String key : EwJson.getKeys(object)) {
            result.put(object.get(key));
        }
        return result;
    }

    @Deprecated
    public static Object derefComplexKey(Object object, String key) throws JSONException {
        if (EwJson.isNull(object)) {
            return null;
        }
        if (!EwJson.isComplexKey(key)) {
            return EwJson.getElement(object, key);
        }
        EwList<Object> results = EwJson.processComplexKey(object, KEY_PATTERN.split(key));
        switch (results.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return results.get(0);
            }
        }
        return results;
    }

    @Deprecated
    public static boolean hasComplexKey(Object object, String key) throws JSONException {
        Object json = EwJson.tryParseJson(object, true);
        if (!EwJson.isComplexKey(key) || !EwJson.isJson(json)) {
            return false;
        }
        return EwJson.processComplexKey(json, KEY_PATTERN.split(key)).size() > 0;
    }

    @Deprecated
    private static EwList<Object> processComplexKey(Object object, String[] innerKeys) throws JSONException {
        if (EwJson.isNull(object) || innerKeys == null) {
            return new EwList<Object>();
        }
        EwList<Object> results = new EwList<Object>();
        int lastIndex = innerKeys.length - 1;
        String lastKey = innerKeys[lastIndex];
        switch (lastIndex) {
            case -1: {
                return results;
            }
            case 0: {
                results.add(EwJson.derefCompositeKey(object, lastKey));
                return results;
            }
        }
        results.add(EwJson.tryParseJson(object, false));
        for (int i = 0; i < lastIndex; ++i) {
            String innerKey = innerKeys[i];
            for (Object o : (EwList)results.clone()) {
                Object value = EwJson.derefCompositeKey(o, innerKey);
                results.clear();
                if (value instanceof JSONObject) {
                    results.add(value);
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONArray ja = (JSONArray)value;
                    for (int j = 0; j < ja.length(); ++j) {
                        Object innerValue = EwJson.derefCompositeKey(ja, new Integer(j).toString());
                        if (!EwJson.isJson(innerValue)) continue;
                        results.add(innerValue);
                    }
                    continue;
                }
                return results;
            }
        }
        EwList<Object> finalResults = new EwList<Object>();
        for (Object e : results) {
            Object value = EwJson.derefCompositeKey(e, lastKey);
            if (EwJson.isNull(value)) continue;
            finalResults.add(value);
        }
        return finalResults;
    }

    @Deprecated
    private static Object derefCompositeKey(Object object, String key) throws JSONException {
        return EwJson.derefCompositeKey(object, key, false);
    }

    @Deprecated
    private static Object derefCompositeKey(Object object, String key, boolean reduce) throws JSONException {
        if (object instanceof String) {
            object = EwJson.tryParseJson(object, false, reduce);
        }
        if (object instanceof JSONObject) {
            JSONObject jo = (JSONObject)object;
            if (jo.has(key)) {
                return jo.get(key);
            }
            if (EwJson.isBracketedKey(key)) {
                return EwJson.derefBracketedKey(object, key);
            }
            if (EwJson.isObjectIndexKey(key)) {
                return EwJson.derefObjectIndexKey(object, key);
            }
        } else if (object instanceof JSONArray) {
            if (EwJson.isValidIndex(key)) {
                return ((JSONArray)object).opt(EwJson.keyToIndex(key));
            }
            if (EwJson.isBracketedKey(key)) {
                return EwJson.derefBracketedKey(object, key);
            }
            if (EwJson.isObjectIndexKey(key)) {
                return EwJson.derefObjectIndexKey(object, key);
            }
        }
        return reduce ? null : EwJson.derefCompositeKey(object, key, true);
    }

    @Deprecated
    private static Object derefBracketedKey(Object object, String key) throws JSONException {
        String nextKey;
        Object jsonObject = EwJson.tryParseJson(object, true);
        if (jsonObject == null || key == null) {
            return null;
        }
        if (key.indexOf(46) != -1) {
            return EwJson.derefComplexKey(jsonObject, key);
        }
        if (!EwJson.isBracketedKey(key)) {
            return EwJson.getElement(jsonObject, key);
        }
        int keyDelim = key.indexOf(91);
        int keyLength = key.indexOf(93) + 1;
        String outerKey = key.substring(0, keyDelim);
        String innerKey = key.substring(keyDelim + 1, keyLength - 1);
        if (EwJson.isBracketedKey(innerKey)) {
            throw new JSONException("Invalid inner key: " + key);
        }
        String string = nextKey = keyLength < key.length() ? key.substring(keyLength) : DEFAULT_STRING;
        if (nextKey.length() > 0 && nextKey.charAt(0) != '[') {
            throw new JSONException("Invalid next key: " + key);
        }
        Object nextObject = outerKey.isEmpty() ? EwJson.getElement(jsonObject, innerKey) : EwJson.derefCompositeKey(EwJson.getElement(jsonObject, outerKey), innerKey);
        return nextKey.isEmpty() ? nextObject : EwJson.derefCompositeKey(nextObject, nextKey);
    }

    @Deprecated
    private static Object derefObjectIndexKey(Object object, String key) throws JSONException {
        if ((object = EwJson.tryParseJson(object, true)) == null || key == null) {
            return null;
        }
        if (key.indexOf(46) != -1) {
            return EwJson.derefComplexKey(object, key);
        }
        if (EwJson.isObjectIndexKey(key)) {
            int delimIndex = key.indexOf(58);
            String outerKey = key.substring(0, delimIndex);
            String innerKey = key.substring(delimIndex + 1);
            Object deref = outerKey.isEmpty() ? object : (EwJson.isBracketedKey(outerKey) ? EwJson.derefBracketedKey(object, outerKey) : EwJson.getElement(object, outerKey));
            return EwJson.derefObjectIndexKey(deref, innerKey);
        }
        if (EwJson.isValidIndex(key) && object instanceof JSONObject) {
            JSONObject jo = (JSONObject)object;
            List<String> keys = EwJson.getKeys(jo);
            int index = EwJson.keyToIndex(key);
            return keys.size() > index ? jo.opt(keys.get(index)) : null;
        }
        return EwJson.getElement(object, key);
    }

    @Deprecated
    private static Object getElement(Object object, Object ref) {
        Object json = EwJson.tryParseJson(object, true);
        if (json == null || ref == null) {
            return null;
        }
        if (json instanceof JSONArray) {
            return ((JSONArray)json).opt(EwJson.keyToIndex(ref));
        }
        if (json instanceof JSONObject) {
            return ((JSONObject)json).opt(ref.toString());
        }
        return null;
    }

    @Deprecated
    public static int getElements(Object object) {
        Object json = EwJson.tryParseJson(object, true);
        if (json instanceof JSONArray) {
            return ((JSONArray)json).length();
        }
        if (json instanceof JSONObject) {
            return ((JSONObject)json).length();
        }
        return 0;
    }

    public static JSONArray getInstanceOfJsonArray(Object object) {
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        if (object instanceof JSONObject) {
            return null;
        }
        if (object instanceof String && object.toString().startsWith("[")) {
            return EwJson.getJsonArray((String)object);
        }
        if (object != null) {
            return EwJson.getJsonArray(object.toString());
        }
        return null;
    }

    public static JSONObject getInstanceOfJsonObject(Object object) {
        if (object instanceof JSONArray) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof String && object.toString().startsWith("{")) {
            return EwJson.getJsonObject((String)object);
        }
        if (object != null) {
            return EwJson.getJsonObject(object.toString());
        }
        return null;
    }

    @Deprecated
    public static JSONArray getJsonArray(String json) {
        if (!EwJson.isNull(json) && json.trim().startsWith("[")) {
            try {
                return EwJsonArray.parse(json);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    public static JSONObject getJsonObject(String json) {
        if (!EwJson.isNull(json) && json.trim().startsWith("{")) {
            try {
                return EwJsonObject.parse(json);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    public static int keyToIndex(Object ref) {
        int index;
        if (ref == null) {
            index = -1;
        } else if (ref instanceof Number) {
            index = ((Number)ref).intValue();
        } else {
            try {
                String key = (String)ref;
                int start = 0;
                int end = key.length();
                if (key.charAt(start) == '[' && key.charAt(end - 1) == ']') {
                    ++start;
                    --end;
                }
                index = Integer.valueOf(key.substring(start, end));
            }
            catch (Exception e) {
                return -1;
            }
        }
        return index >= 0 ? index : -1;
    }

    @Deprecated
    public static boolean isComplexKey(Object ref) throws JSONException {
        if (ref == null || !(ref instanceof String)) {
            return false;
        }
        String key = (String)ref;
        return key.indexOf(46) != -1 || EwJson.isBracketedKey(key) || EwJson.isObjectIndexKey(key);
    }

    @Deprecated
    private static boolean isBracketedKey(String key) {
        if (key == null) {
            return false;
        }
        return key.indexOf(91) != -1 && key.charAt(key.length() - 1) == ']';
    }

    @Deprecated
    private static boolean isObjectIndexKey(String key) {
        if (key == null) {
            return false;
        }
        int delimIndex = key.indexOf(58);
        if (-1 < delimIndex && delimIndex == key.lastIndexOf(58)) {
            String innerKey = key.substring(delimIndex + 1);
            return !EwJson.isBracketedKey(innerKey) && EwJson.isValidIndex(innerKey);
        }
        return false;
    }

    @Deprecated
    public static boolean isBadDecimal(Object object) throws JSONException {
        float f;
        double d;
        return object instanceof Double ? Double.isInfinite(d = ((Number)object).doubleValue()) || Double.isNaN(d) : object instanceof Float && (Float.isInfinite(f = ((Number)object).floatValue()) || Float.isNaN(f));
    }

    public static boolean isJson(Object object) {
        return object instanceof JSONArray || object instanceof JSONObject;
    }

    public static boolean isJson(String json) {
        return EwJson.isJsonArray(json) || EwJson.isJsonObject(json);
    }

    public static boolean isJsonArray(String json) {
        return EwJson.getJsonArray(json) != null;
    }

    public static boolean isJsonObject(String json) {
        return EwJson.getJsonObject(json) != null;
    }

    @Deprecated
    public static boolean isNull(Object object) {
        return object == null || JSONObject.NULL.equals(object) || JSONObject.NULL.toString().equals(object);
    }

    @Deprecated
    public static boolean isValidIndex(JSONArray array, int index) {
        if (array == null) {
            return false;
        }
        return -1 < index && index < array.length();
    }

    @Deprecated
    public static boolean isValidIndex(Object key) {
        return -1 < EwJson.keyToIndex(key);
    }

    @Deprecated
    public static Object reduce(JSONArray array) {
        if (array == null) {
            return null;
        }
        switch (array.length()) {
            case 0: {
                return null;
            }
            case 1: {
                return array.opt(0);
            }
        }
        return array;
    }

    @Deprecated
    public static Object reduce(JSONObject object) {
        if (object == null) {
            return null;
        }
        switch (object.length()) {
            case 0: {
                return null;
            }
            case 1: {
                return object.opt((String)object.keys().next());
            }
        }
        return object;
    }

    @Deprecated
    public static Object reduce(Object object) {
        if (object instanceof JSONArray) {
            return EwJson.reduce((JSONArray)object);
        }
        if (object instanceof JSONObject) {
            return EwJson.reduce((JSONObject)object);
        }
        return object;
    }

    @Deprecated
    public static boolean parseBoolean(Object object) throws JSONException {
        if (Boolean.FALSE.equals(object)) {
            return false;
        }
        if (Boolean.TRUE.equals(object)) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (Boolean.FALSE.toString().equalsIgnoreCase(string)) {
                return false;
            }
            if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
                return true;
            }
        }
        throw new JSONException("Object is not a boolean.");
    }

    @Deprecated
    public static double parseDouble(Object object) throws JSONException {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble((String)object);
        }
        catch (Exception exception) {
            throw new JSONException("Object is not a double.");
        }
    }

    @Deprecated
    public static int parseInt(Object object) throws JSONException {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new JSONException("Object is not an integer.");
    }

    @Deprecated
    public static long parseLong(Object object) throws JSONException {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong((String)object);
        }
        catch (Exception exception) {
            throw new JSONException("Object is not a long.");
        }
    }

    @Deprecated
    public static String parseString(Object object) throws JSONException {
        if (object instanceof String) {
            return (String)object;
        }
        throw new JSONException("Object is not a string");
    }

    @Deprecated
    public static EwJsonCollection tryConvert(Object object) {
        Object converted = EwJson.tryParseJson(object, false);
        if (converted instanceof JSONArray) {
            return EwJsonArray.convert((JSONArray)converted);
        }
        if (converted instanceof JSONObject) {
            return EwJsonObject.convert((JSONObject)converted);
        }
        return null;
    }

    @Deprecated
    public static EwJsonCollection tryMerge(Object into, Object from, Object ref) {
        if (EwJson.isJson(into)) {
            EwJsonCollection converted = EwJson.tryConvert(into);
            try {
                if (converted instanceof JSONArray) {
                    return EwJsonArray.tryMergeAny((JSONArray)converted, from, ref);
                }
                if (converted instanceof JSONObject) {
                    return EwJsonObject.tryMergeAny((JSONObject)converted, from, ref);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    public static Object tryParseJson(Object object, boolean nullify) {
        return EwJson.tryParseJson(object, nullify, false);
    }

    @Deprecated
    public static Object tryParseJson(Object object, boolean nullify, boolean reduce) {
        if (EwJson.isNull(object)) {
            return null;
        }
        JSONArray ja = EwJson.getInstanceOfJsonArray(object);
        if (ja != null) {
            return reduce ? EwJson.tryReduce(ja, nullify) : ja;
        }
        JSONObject jo = EwJson.getInstanceOfJsonObject(object);
        if (jo != null) {
            return reduce ? EwJson.tryReduce(jo, nullify) : jo;
        }
        return nullify ? null : object;
    }

    @Deprecated
    public static Object tryReduce(Object object, boolean nullify) {
        if (EwJson.isNull(object)) {
            return null;
        }
        if (object instanceof JSONArray) {
            return EwJson.reduce((JSONArray)object);
        }
        if (object instanceof JSONObject) {
            return EwJson.reduce((JSONObject)object);
        }
        return nullify ? null : object;
    }

    public static EwList<Object> toArray(JSONArray inner) throws JSONException {
        EwList<Object> elements = new EwList<Object>();
        if (inner == null) {
            return elements;
        }
        for (int i = 0; i < inner.length(); ++i) {
            if (inner.isNull(i)) continue;
            Object object = inner.get(i);
            if (object instanceof JSONArray) {
                elements.add(EwJson.toArray((JSONArray)object));
                continue;
            }
            elements.add(object);
        }
        return elements;
    }

    @Deprecated
    public static Object wrap(Object object) {
        return EwJson.wrap(object, false);
    }

    @Deprecated
    public static Object wrap(Object object, boolean convert) {
        try {
            if (EwJson.isNull(object)) {
                return null;
            }
            if (EwJson.isWrapped(object)) {
                return object;
            }
            if (object instanceof JSONArray) {
                return new EwJsonArray(object);
            }
            if (object instanceof JSONObject) {
                return new EwJsonObject(object);
            }
            if (object instanceof EwJsonSerializable) {
                return ((EwJsonSerializable)object).toString();
            }
            if (convert) {
                if (object.getClass().isArray()) {
                    return new EwJsonArray(object);
                }
                if (object instanceof Collection) {
                    return new EwJsonArray((Collection)object);
                }
                if (object instanceof Map) {
                    return new EwJsonObject((Map)object);
                }
                if (object instanceof String) {
                    return EwJson.tryParseJson(object, false);
                }
                Object json = EwJson.tryParseJson(object, true);
                return EwJson.isNull(json) ? EwJson.populateMap(new EwJsonObject(), object) : json;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    @Deprecated
    private static boolean isWrapped(Object object) {
        if (object == null) {
            return false;
        }
        return JSONObject.NULL.equals(object) || object instanceof EwJsonCollection || object instanceof JSONString || object instanceof Boolean || object instanceof Byte || object instanceof Character || object instanceof Double || object instanceof Float || object instanceof Integer || object instanceof Long || object instanceof Short;
    }

    @Deprecated
    public static EwJsonCollection populateMap(JSONObject object, Object bean) throws JSONException {
        if (object == null || EwJson.isNull(bean)) {
            return null;
        }
        EwJsonObject ewObject = EwJsonObject.convert(object);
        Class<?> beanClass = bean.getClass();
        boolean includeSuperClass = beanClass.getClassLoader() != null;
        Method[] methods = includeSuperClass ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                String name;
                String key;
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers()) || (key = (name = method.getName()).startsWith("get") ? (!name.equals("getClass") && !name.equals("getDeclaringClass") ? name.substring(3) : DEFAULT_STRING) : (name.startsWith("is") ? name.substring(2) : DEFAULT_STRING)).length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                if (result == null) continue;
                ewObject.put(key, EwJson.wrap(result));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ewObject;
    }

    @Deprecated
    public static void validateDecimal(Object decimal) throws JSONException {
        if (EwJson.isBadDecimal(decimal)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    @Deprecated
    public static String valueToString(Object value) throws JSONException {
        if (EwJson.isNull(value)) {
            return "null";
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Number) {
            EwJson.validateDecimal(value);
            String string = value.toString();
            if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
                int length = string.length();
                while (string.charAt(length - 1) == '0') {
                    --length;
                }
                if (string.charAt(length - 1) == '.') {
                    --length;
                }
                string = string.substring(0, length);
            }
            return string;
        }
        if (value instanceof Map) {
            return new EwJsonObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new EwJsonArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new EwJsonArray(value).toString();
        }
        return JSONObject.quote((String)value.toString());
    }

    public static JSONObject clone(JSONObject cl) throws JSONException {
        JSONObject jo = new JSONObject();
        Iterator it = cl.keys();
        while (it.hasNext()) {
            String next = (String)it.next();
            Object o = cl.get(next);
            if (o == null) continue;
            if (o instanceof JSONObject) {
                jo.put(next, (Object)EwJson.clone((JSONObject)o));
                continue;
            }
            if (o instanceof JSONArray) {
                jo.put(next, (Object)EwJson.clone((JSONArray)o));
                continue;
            }
            jo.put(next, o);
        }
        return jo;
    }

    private static JSONArray clone(JSONArray ar) throws JSONException {
        JSONArray result = new JSONArray();
        for (int i = 0; i < ar.length(); ++i) {
            Object o;
            if (ar.isNull(i) || (o = ar.get(i)) == null) continue;
            if (o instanceof JSONObject) {
                result.put((Object)EwJson.clone((JSONObject)o));
                continue;
            }
            if (o instanceof JSONArray) {
                result.put((Object)EwJson.clone((JSONArray)o));
                continue;
            }
            result.put(o);
        }
        return result;
    }
}

