/*
 * Decompiled with CFR 0.152.
 */
package com.eduworks.util.io;

import com.eduworks.lang.EwSet;
import com.google.common.base.Predicate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public class EwFileSystem {
    private static String OS = System.getProperty("os.name").toLowerCase();
    public static String webConfigurationPath = null;

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("sunos") >= 0;
    }

    public static String getWebConfigurationPath() {
        try {
            EwFileSystem.getDefaultLocationPath(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (webConfigurationPath == null && System.getProperty("eduworks.webapp.config") != null) {
            webConfigurationPath = new File(System.getProperty("eduworks.webapp.config")).getParent();
        }
        return webConfigurationPath;
    }

    public static File tryFindFile(String estimatedPath, Class<? extends Object> inThisClassJar, boolean permanantFile, boolean isWebResource) {
        try {
            return EwFileSystem.findFile(estimatedPath, inThisClassJar, permanantFile, isWebResource);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File copyPackage(String pkg, final Class<? extends Object> inThisClassJar) throws IOException {
        Collection urlsForCurrentClasspath = ClasspathHelper.forManifest();
        EwSet urls = new EwSet();
        for (URL url : urlsForCurrentClasspath) {
            urls.add(url);
        }
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).setScanners(new Scanner[]{new ResourcesScanner().filterResultsBy((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    EwFileSystem.findFile(input, inThisClassJar, true, false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        })}));
        Set resources = reflections.getResources(Pattern.compile(".*"));
        for (String s : resources) {
            if (!s.startsWith(pkg)) continue;
            EwFileSystem.findFile(s, inThisClassJar, true, false);
        }
        return new File(EwFileSystem.getDefaultLocationPath(false), pkg);
    }

    public static File copyPackageToRoot(String pkg, final Class<? extends Object> inThisClassJar) throws IOException {
        Collection urlsForCurrentClasspath = ClasspathHelper.forManifest();
        EwSet urls = new EwSet();
        for (URL url : urlsForCurrentClasspath) {
            urls.add(url);
        }
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).setScanners(new Scanner[]{new ResourcesScanner().filterResultsBy((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    EwFileSystem.findFileIn(input, input, inThisClassJar, true, false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        })}));
        Set resources = reflections.getResources(Pattern.compile(".*"));
        for (String s : resources) {
            if (!s.startsWith(pkg)) continue;
            EwFileSystem.findFileIn(s, s, inThisClassJar, true, false);
        }
        return new File(pkg);
    }

    public static File copyPackageChildrenToRoot(final String pkg, final Class<? extends Object> inThisClassJar) throws IOException {
        Collection urlsForCurrentClasspath = ClasspathHelper.forManifest();
        EwSet urls = new EwSet();
        for (URL url : urlsForCurrentClasspath) {
            urls.add(url);
        }
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(urls).setScanners(new Scanner[]{new ResourcesScanner().filterResultsBy((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                try {
                    EwFileSystem.findFileIn(input.replace(pkg + "/", ""), input, inThisClassJar, true, false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return true;
            }
        })}));
        Set resources = reflections.getResources(Pattern.compile(".*"));
        for (String s : resources) {
            if (!s.startsWith(pkg)) continue;
            EwFileSystem.findFileIn(s.replace(pkg + "/", ""), s, inThisClassJar, true, false);
        }
        return new File(".");
    }

    public static File findFileIn(String desiredPath, String estimatedPath, Class<? extends Object> inThisClassJar, boolean permanantFile, boolean isWebResource) throws IOException {
        File file;
        File targetPath = new File(desiredPath);
        if (targetPath.exists()) {
            return targetPath;
        }
        URL possibleFile = null;
        InputStream possibleInputStream = null;
        if (inThisClassJar != null) {
            possibleFile = inThisClassJar.getResource(estimatedPath);
            possibleInputStream = inThisClassJar.getResourceAsStream(estimatedPath);
            if (possibleFile == null) {
                possibleFile = inThisClassJar.getResource("/" + estimatedPath);
                possibleInputStream = inThisClassJar.getResourceAsStream("/" + estimatedPath);
            }
        }
        if (possibleFile == null) {
            possibleFile = EwFileSystem.class.getResource(estimatedPath);
            possibleInputStream = EwFileSystem.class.getResourceAsStream(estimatedPath);
        }
        if (possibleFile == null) {
            possibleFile = EwFileSystem.class.getResource("/" + estimatedPath);
            possibleInputStream = EwFileSystem.class.getResourceAsStream("/" + estimatedPath);
        }
        if (possibleFile == null && (file = new File(desiredPath)).exists()) {
            possibleFile = file.toURI().toURL();
            possibleInputStream = new FileInputStream(file);
        }
        if (possibleFile == null) {
            throw new IOException("Could not find file: " + estimatedPath);
        }
        if (possibleInputStream != null) {
            if (!targetPath.exists()) {
                if (targetPath.getParentFile() != null) {
                    targetPath.getParentFile().mkdirs();
                }
                targetPath.createNewFile();
            }
            FileOutputStream targetOutputStream = new FileOutputStream(targetPath);
            IOUtils.copy((InputStream)possibleInputStream, (OutputStream)targetOutputStream);
            IOUtils.closeQuietly((OutputStream)targetOutputStream);
            IOUtils.closeQuietly((InputStream)possibleInputStream);
        }
        targetPath.mkdirs();
        if (!permanantFile) {
            targetPath.deleteOnExit();
        }
        return targetPath;
    }

    public static File findFile(String estimatedPath, Class<? extends Object> inThisClassJar, boolean permanantFile, boolean isWebResource) throws IOException {
        File file;
        File targetPath;
        String rootPath = null;
        if (isWebResource) {
            rootPath = EwFileSystem.getWebConfigurationPath();
        }
        if (rootPath == null) {
            rootPath = EwFileSystem.getDefaultLocationPath(isWebResource);
        }
        if ((targetPath = new File(rootPath, estimatedPath)).exists()) {
            return targetPath;
        }
        URL possibleFile = null;
        InputStream possibleInputStream = null;
        if (inThisClassJar != null) {
            URL url;
            String jar = inThisClassJar.getProtectionDomain().getCodeSource().getLocation().toString().split("!")[0];
            Enumeration<URL> resources = inThisClassJar.getClassLoader().getResources(estimatedPath);
            while (resources.hasMoreElements()) {
                url = resources.nextElement();
                if (!url.toString().contains(jar)) continue;
                possibleFile = url;
                possibleInputStream = url.openStream();
            }
            if (possibleFile == null) {
                resources = inThisClassJar.getClassLoader().getResources("/" + estimatedPath);
                while (resources.hasMoreElements()) {
                    url = resources.nextElement();
                    if (!url.toString().contains(jar)) continue;
                    possibleFile = url;
                    possibleInputStream = url.openStream();
                }
            }
        }
        if (possibleFile == null) {
            possibleFile = EwFileSystem.class.getResource(estimatedPath);
            possibleInputStream = EwFileSystem.class.getResourceAsStream(estimatedPath);
        }
        if (possibleFile == null) {
            possibleFile = EwFileSystem.class.getResource("/" + estimatedPath);
            possibleInputStream = EwFileSystem.class.getResourceAsStream("/" + estimatedPath);
        }
        if (possibleFile == null && (file = new File(estimatedPath)).exists()) {
            possibleFile = file.toURI().toURL();
            possibleInputStream = new FileInputStream(file);
        }
        if (possibleFile == null && possibleInputStream == null) {
            throw new IOException("Could not find file: " + estimatedPath);
        }
        System.out.println(possibleFile);
        if (possibleInputStream != null) {
            if (!targetPath.exists()) {
                targetPath.getParentFile().mkdirs();
                targetPath.createNewFile();
            }
            FileOutputStream targetOutputStream = new FileOutputStream(targetPath);
            IOUtils.copy((InputStream)possibleInputStream, (OutputStream)targetOutputStream);
            IOUtils.closeQuietly((OutputStream)targetOutputStream);
            IOUtils.closeQuietly((InputStream)possibleInputStream);
        }
        targetPath.mkdirs();
        if (!permanantFile) {
            targetPath.deleteOnExit();
        }
        return targetPath;
    }

    public static void closeIt(Object stream) {
        try {
            if (stream instanceof InputStream) {
                ((InputStream)stream).close();
            } else if (stream instanceof OutputStream) {
                ((OutputStream)stream).close();
            } else if (stream instanceof Reader) {
                ((Reader)stream).close();
            } else if (stream instanceof Writer) {
                ((Writer)stream).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(String path, File localFile, int timeout) throws IOException {
        File file;
        FileOutputStream fileOutputStream = null;
        InputStream inputStream = null;
        try {
            URL uri;
            try {
                uri = new URL(path);
            }
            catch (MalformedURLException e) {
                uri = new URL(URLDecoder.decode(path));
            }
            URLConnection connection = uri.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setRequestProperty("Accept", "*/*");
            connection.connect();
            inputStream = connection.getInputStream();
            if (localFile == null) {
                String ext = null;
                try {
                    String filename;
                    String headerField = connection.getHeaderField("content-disposition");
                    if (headerField != null && headerField.split(";")[0].equals("attachment") && (filename = headerField.split(";")[1].split("=")[1]).contains(".")) {
                        ext = filename.split("\\.")[filename.split("\\.").length - 1];
                    }
                }
                catch (Exception ex) {
                    System.out.println("Download of File: Could not determine extension appropriately from header.");
                    System.out.println(uri);
                    ex.printStackTrace();
                }
                if (ext == null) {
                    ext = uri.getPath().substring(uri.getPath().lastIndexOf("/") + 1);
                }
                if ((ext == null || ext.isEmpty()) && connection.getContentType() != null && !connection.getContentType().endsWith("/")) {
                    ext = connection.getContentType().substring(connection.getContentType().lastIndexOf(47) + 1);
                }
                if (ext.contains(".")) {
                    ext = ext.substring(ext.indexOf("."));
                }
                localFile = File.createTempFile("foo", "." + EwFileSystem.removeNonazAZStatic(ext));
            }
            fileOutputStream = new FileOutputStream(localFile);
            if (connection.getContentEncoding() != null && connection.getContentEncoding().equals("gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            if (connection.getContentEncoding() != null && connection.getContentEncoding().equals("deflate")) {
                inputStream = new DeflaterInputStream(inputStream);
            }
            IOUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
            file = localFile;
        }
        catch (Throwable throwable) {
            EwFileSystem.closeIt(inputStream);
            EwFileSystem.closeIt(fileOutputStream);
            throw throwable;
        }
        EwFileSystem.closeIt(inputStream);
        EwFileSystem.closeIt(fileOutputStream);
        return file;
    }

    private static String removeNonazAZStatic(String _text) {
        for (int i = 0; i < _text.length(); ++i) {
            char k = _text.charAt(i);
            if (k >= 'a' && k <= 'z' || k >= 'A' && k <= 'Z') continue;
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < _text.length(); ++j) {
                char c = _text.charAt(j);
                if ((c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) continue;
                sb.append(_text.charAt(j));
            }
            return sb.toString();
        }
        return _text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolve(URL uri) throws IOException {
        String string;
        ByteArrayOutputStream baos = null;
        InputStream inputStream = null;
        try {
            URLConnection connection = uri.openConnection();
            inputStream = connection.getInputStream();
            connection.connect();
            baos = new ByteArrayOutputStream();
            if (connection.getContentEncoding() != null && connection.getContentEncoding().equals("gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            if (connection.getContentEncoding() != null && connection.getContentEncoding().equals("deflate")) {
                inputStream = new DeflaterInputStream(inputStream);
            }
            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
            string = new String(baos.toByteArray());
        }
        catch (Throwable throwable) {
            EwFileSystem.closeIt(inputStream);
            EwFileSystem.closeIt(baos);
            throw throwable;
        }
        EwFileSystem.closeIt(inputStream);
        EwFileSystem.closeIt(baos);
        return string;
    }

    public static File downloadFile(String path) throws IOException {
        return EwFileSystem.downloadFile(path, null, 300000);
    }

    public static File downloadFile(String path, int timeoutms) throws IOException {
        return EwFileSystem.downloadFile(path, null, timeoutms);
    }

    private static String getDefaultLocationPath(boolean isWebResource) throws IOException {
        if (webConfigurationPath != null) {
            return webConfigurationPath;
        }
        String rootPath = EwFileSystem.createTempDirectory().getName();
        if (isWebResource) {
            webConfigurationPath = rootPath;
        }
        return rootPath;
    }

    private static File createTempDirectory() throws IOException {
        File createTempFile = File.createTempFile("ewww", "tmp");
        createTempFile.delete();
        createTempFile = new File(createTempFile.getParentFile(), "etc");
        createTempFile.mkdirs();
        createTempFile.mkdir();
        createTempFile.deleteOnExit();
        return createTempFile;
    }

    public static void deleteEventually(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }

    public static void placeInWorkingDirectoryTemporarily(File findFile, String relativePath) {
        File dest = new File(relativePath);
        if (dest.exists()) {
            return;
        }
        dest.getParentFile().mkdirs();
        try {
            FileInputStream input = new FileInputStream(findFile);
            dest.createNewFile();
            FileOutputStream output = new FileOutputStream(dest);
            IOUtils.copy((InputStream)input, (OutputStream)output);
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dest.deleteOnExit();
    }

    public static void copyPackage(String path, String string, Class<? extends Object> class1) {
    }
}

