/*
 * Decompiled with CFR 0.152.
 */
package org.cassproject.schema.cass.profile;

import com.eduworks.ec.crypto.EcPk;
import org.cassproject.ebac.identity.EcContact;
import org.cassproject.ebac.identity.EcIdentity;
import org.cassproject.ebac.identity.EcIdentityManager;
import org.cassproject.ebac.repository.EcEncryptedValue;
import org.cassproject.schema.cass.Cass;
import org.cassproject.schema.cass.profile.AssertionCodebook;
import org.schema.CreativeWork;
import org.stjs.javascript.Array;
import org.stjs.javascript.JSObjectAdapter;
import org.stjs.javascript.Map;
import org.stjs.javascript.functions.Callback1;

public class Assertion
extends CreativeWork {
    private static final String TYPE_0_1 = "http://schema.eduworks.com/cass/0.1/assertion";
    private static final String TYPE_0_2 = "http://schema.eduworks.com/cass/0.2/assertion";
    private static final String TYPE_0_3 = "http://schema.cassproject.org/0.2/Assertion";
    private static final String TYPE_0_4 = "http://schema.cassproject.org/0.3/Assertion";
    private static final String TYPE_0_5 = "https://schema.cassproject.org/0.3/Assertion";
    public static final String myType = "https://schema.cassproject.org/0.3/Assertion";
    public static Object codebooks;
    public String competency;
    public String framework;
    public String level;
    public Double confidence;
    protected EcEncryptedValue subject;
    protected EcEncryptedValue agent;
    protected Array<EcEncryptedValue> evidence;
    protected EcEncryptedValue assertionDate;
    protected EcEncryptedValue expirationDate;
    protected EcEncryptedValue decayFunction;
    protected EcEncryptedValue negative;

    public Assertion() {
        this.setContextAndType(Cass.context, "https://schema.cassproject.org/0.3/Assertion");
    }

    public EcPk getSubject() {
        return EcPk.fromPem((String)((String)this.subject));
    }

    public void setSubject(EcPk pk) {
        Array owners = new Array();
        Array readers = this.reader;
        if (readers == null) {
            readers = new Array();
        }
        if (this.subject != null) {
            if (this.subject.owner != null) {
                owners.concat(new Array[]{this.subject.owner});
            }
            if (this.subject.reader != null) {
                readers.concat(new Array[]{this.subject.reader});
            }
        }
        if (this.owner != null) {
            owners = owners.concat(new Array[]{this.owner});
        }
        readers.push((Object[])new String[]{pk.toPem()});
        this.subject = (EcEncryptedValue)pk.toPem();
    }

    public void getSubjectAsync(Callback1<EcPk> success, Callback1<String> failure) {
        success.$invoke((Object)EcPk.fromPem((String)((String)this.subject)));
    }

    public EcPk getAgent() {
        return EcPk.fromPem((String)((String)this.agent));
    }

    public void setAgent(EcPk pk) {
        this.agent = (EcEncryptedValue)pk.toPem();
    }

    public void getAgentAsync(Callback1<EcPk> success, Callback1<String> failure) {
        success.$invoke((Object)EcPk.fromPem((String)((String)this.agent)));
    }

    public String getSubjectName() {
        if (this.subject == null) {
            return "Nobody";
        }
        EcPk subjectPk = this.getSubject();
        EcIdentity identity = EcIdentityManager.getIdentity((EcPk)subjectPk);
        if (identity != null && identity.displayName != null) {
            return identity.displayName + " (You)";
        }
        EcContact contact = EcIdentityManager.getContact((EcPk)subjectPk);
        if (contact == null || contact.displayName == null) {
            return "Unknown Subject";
        }
        return contact.displayName;
    }

    public void getSubjectNameAsync(final Callback1<String> success, Callback1<String> failure) {
        if (this.subject == null) {
            success.$invoke((Object)"Nobody");
            return;
        }
        this.getSubjectAsync(new Callback1<EcPk>(){

            public void $invoke(EcPk subjectPk) {
                EcIdentity identity = EcIdentityManager.getIdentity((EcPk)subjectPk);
                if (identity != null && identity.displayName != null) {
                    success.$invoke((Object)(identity.displayName + " (You)"));
                    return;
                }
                EcContact contact = EcIdentityManager.getContact((EcPk)subjectPk);
                if (contact == null || contact.displayName == null) {
                    success.$invoke((Object)"Unknown Subject");
                    return;
                }
                success.$invoke((Object)contact.displayName);
            }
        }, failure);
    }

    public String getAgentName() {
        if (this.agent == null) {
            return "Nobody";
        }
        EcPk agentPk = this.getAgent();
        EcIdentity identity = EcIdentityManager.getIdentity((EcPk)agentPk);
        if (identity != null && identity.displayName != null) {
            return identity.displayName + " (You)";
        }
        EcContact contact = EcIdentityManager.getContact((EcPk)agentPk);
        if (contact == null || contact.displayName == null) {
            return "Unknown Agent";
        }
        return contact.displayName;
    }

    public void getAgentNameAsync(final Callback1<String> success, Callback1<String> failure) {
        if (this.subject == null) {
            success.$invoke((Object)"Nobody");
            return;
        }
        this.getAgentAsync(new Callback1<EcPk>(){

            public void $invoke(EcPk subjectPk) {
                EcIdentity identity = EcIdentityManager.getIdentity((EcPk)subjectPk);
                if (identity != null && identity.displayName != null) {
                    success.$invoke((Object)(identity.displayName + " (You)"));
                    return;
                }
                EcContact contact = EcIdentityManager.getContact((EcPk)subjectPk);
                if (contact == null || contact.displayName == null) {
                    success.$invoke((Object)"Unknown Agent");
                    return;
                }
                success.$invoke((Object)contact.displayName);
            }
        }, failure);
    }

    public Long getAssertionDate() {
        return (Long)this.assertionDate;
    }

    public void setAssertionDate(Long assertionDateMs) {
        this.assertionDate = (EcEncryptedValue)assertionDateMs;
    }

    public void getAssertionDateAsync(Callback1<Long> success, Callback1<String> failure) {
        success.$invoke((Object)((Long)this.assertionDate));
    }

    public Long getExpirationDate() {
        return (Long)this.expirationDate;
    }

    public void setExpirationDate(Long expirationDateMs) {
        this.expirationDate = (EcEncryptedValue)expirationDateMs;
    }

    public void getExpirationDateAsync(Callback1<Long> success, Callback1<String> failure) {
        success.$invoke((Object)((Long)this.expirationDate));
    }

    public int getEvidenceCount() {
        if (this.evidence == null) {
            return 0;
        }
        return this.evidence.$length();
    }

    public String getEvidence(int index) {
        return (String)this.evidence.$get(index);
    }

    public void getEvidenceAsync(int index, Callback1<String> success, Callback1<String> failure) {
        success.$invoke((Object)((String)this.evidence.$get(index)));
    }

    public String getDecayFunction() {
        return (String)this.decayFunction;
    }

    public void setDecayFunction(String decayFunctionText) {
        this.decayFunction = (EcEncryptedValue)decayFunctionText;
    }

    public void getDecayFunctionAsync(Callback1<String> success, Callback1<String> failure) {
        success.$invoke((Object)((String)this.decayFunction));
    }

    public Boolean getNegative() {
        return "true".equals(this.negative);
    }

    public void setNegative(Boolean negativeB) {
        this.negative = (EcEncryptedValue)negativeB;
    }

    public void getNegativeAsync(Callback1<Boolean> success, Callback1<String> failure) {
        success.$invoke((Object)"true".equals(this.negative));
    }

    public void setCompetency(String competencyUrl) {
        this.competency = competencyUrl;
    }

    public void setLevel(String levelUrl) {
        this.level = levelUrl;
    }

    public void setConfidence(Double confidenceZeroToOne) {
        this.confidence = confidenceZeroToOne;
    }

    public void setEvidence(Array<String> evidences) {
        this.evidence = evidences;
    }

    protected void upgrade() {
        super.upgrade();
        if (TYPE_0_1.equals(this.type)) {
            Map me = JSObjectAdapter.$properties((Object)((Object)this));
            if (me.$get("@context") == null && me.$get("@schema") != null) {
                me.$put("@context", me.$get("@schema"));
            }
            this.setContextAndType(Cass.context_0_2, TYPE_0_2);
        }
        if (TYPE_0_2.equals(this.getFullType())) {
            this.setContextAndType(Cass.context_0_3, TYPE_0_3);
        }
        if (TYPE_0_3.equals(this.getFullType())) {
            this.setContextAndType(Cass.context_0_4, TYPE_0_4);
        }
        if (TYPE_0_4.equals(this.getFullType())) {
            this.setContextAndType(Cass.context_0_5, "https://schema.cassproject.org/0.3/Assertion");
        }
        this.agent = EcEncryptedValue.revive((EcEncryptedValue)this.agent);
        this.subject = EcEncryptedValue.revive((EcEncryptedValue)this.subject);
        this.assertionDate = EcEncryptedValue.revive((EcEncryptedValue)this.assertionDate);
        this.expirationDate = EcEncryptedValue.revive((EcEncryptedValue)this.expirationDate);
        this.decayFunction = EcEncryptedValue.revive((EcEncryptedValue)this.decayFunction);
        this.negative = EcEncryptedValue.revive((EcEncryptedValue)this.negative);
        if (this.evidence != null) {
            for (int i = 0; i < this.evidence.$length(); ++i) {
                this.evidence.$set(i, (Object)EcEncryptedValue.revive((EcEncryptedValue)((EcEncryptedValue)this.evidence.$get(i))));
            }
        }
    }

    public Array<String> getTypes() {
        Array a = new Array();
        a.push((Object[])new String[]{"https://schema.cassproject.org/0.3/Assertion"});
        a.push((Object[])new String[]{TYPE_0_4});
        a.push((Object[])new String[]{TYPE_0_3});
        a.push((Object[])new String[]{TYPE_0_2});
        a.push((Object[])new String[]{TYPE_0_1});
        return a;
    }

    public static AssertionCodebook getCodebook(Assertion assertion) {
        if (codebooks == null) {
            codebooks = new Object();
        }
        return (AssertionCodebook)JSObjectAdapter.$get((Object)codebooks, (String)assertion.id);
    }
}

