/**
 *  credentialengine.org/EarningsProfile
 *  Entity that describes earning and related statistical information for a given credential.
 *  @author credentialengine.org
 *  @class EarningsProfile
 *  @module org.credentialengine
 *  @extends CreativeWork
 */
var EarningsProfile = /**
 *  Constructor, automatically sets @context and @type.
 *  @constructor
 */
function() {
    CreativeWork.call(this);
    this.context = "http://schema.eduworks.com/simpleCtdl";
    this.type = "EarningsProfile";
};
EarningsProfile = stjs.extend(EarningsProfile, CreativeWork, [], function(constructor, prototype) {
    /**
     *  http://purl.org/ctdl/terms/dateEffective
     *  Effective date of the content of a credential, assessment or learning opportunity.
     *  @property dateEffective
     *  @type date
     */
    prototype.dateEffective = null;
    /**
     *  http://purl.org/ctdl/terms/highEarnings
     *  Upper interquartile earnings.
     *  @property highEarnings
     *  @type integer
     */
    prototype.highEarnings = null;
    /**
     *  http://purl.org/ctdl/terms/jurisdiction
     *  Geographic or political region in which the credential is formally applicable or an organization has authority to act.
     *  @property jurisdiction
     *  @type JurisdictionProfile
     */
    prototype.jurisdiction = null;
    /**
     *  http://purl.org/ctdl/terms/lowEarnings
     *  Lower interquartile earnings.
     *  @property lowEarnings
     *  @type integer
     */
    prototype.lowEarnings = null;
    /**
     *  http://purl.org/ctdl/terms/medianEarnings
     *  Median earnings.
     *  @property medianEarnings
     *  @type integer
     */
    prototype.medianEarnings = null;
    /**
     *  http://purl.org/ctdl/terms/postReceiptMonths
     *  Number of months after earning a credential when employment and earnings data is collected.
     *  Number of months usually range between 3 months (one quarter) to ten years.
     *  @property postReceiptMonths
     *  @type integer
     */
    prototype.postReceiptMonths = null;
    /**
     *  http://purl.org/ctdl/terms/region
     *  Entity that describes the longitude, latitude and other location details of an area.
     *  @property region
     *  @type Place
     */
    prototype.region = null;
    /**
     *  http://purl.org/ctdl/terms/source
     *  Authoritative source of an entity's information.
     *  Citation or description of an authoritative souce from which information or description has been derived.
     *  @property source
     *  @type anyURI
     */
    prototype.source = null;
}, {jurisdiction: "JurisdictionProfile", region: "Place", contributor: "Object", reviews: "Review", audience: "Audience", timeRequired: "Duration", publication: "PublicationEvent", contentLocation: "Place", temporalCoverage: "Object", isBasedOn: "Object", fileFormat: "Object", interactionStatistic: "InteractionCounter", recordedAt: "Event", isPartOf: "CreativeWork", exampleOfWork: "CreativeWork", dateCreated: "Object", releasedEvent: "PublicationEvent", publisher: "Object", encoding: "MediaObject", creator: "Object", hasPart: "CreativeWork", license: "Object", translator: "Object", offers: "Offer", schemaVersion: "Object", review: "Review", position: "Object", genre: "Object", character: "Person", producer: "Object", editor: "Person", locationCreated: "Place", about: "Thing", audio: "AudioObject", encodings: "MediaObject", funder: "Object", accountablePerson: "Person", material: "Object", author: "Object", sourceOrganization: "Organization", sponsor: "Object", provider: "Object", copyrightHolder: "Object", comment: "Comment", spatialCoverage: "Place", aggregateRating: "AggregateRating", educationalAlignment: "AlignmentObject", video: "VideoObject", version: "Object", mainEntity: "Thing", associatedMedia: "MediaObject", workExample: "CreativeWork", mentions: "Thing", citation: "Object", dateModified: "Object", inLanguage: "Object", isBasedOnUrl: "Object", identifier: "Object", image: "Object", potentialAction: "Action", mainEntityOfPage: "Object", owner: {name: "Array", arguments: [null]}, signature: {name: "Array", arguments: [null]}, reader: {name: "Array", arguments: [null]}, atProperties: {name: "Array", arguments: [null]}}, {});
