/**
 *  credentialengine.org/JurisdictionProfile
 *  Geo-political information about applicable geographic areas and their exceptions.
 *  @author credentialengine.org
 *  @class JurisdictionProfile
 *  @module org.credentialengine
 *  @extends CreativeWork
 */
var JurisdictionProfile = /**
 *  Constructor, automatically sets @context and @type.
 *  @constructor
 */
function() {
    CreativeWork.call(this);
    this.context = "http://schema.eduworks.com/simpleCtdl";
    this.type = "JurisdictionProfile";
};
JurisdictionProfile = stjs.extend(JurisdictionProfile, CreativeWork, [], function(constructor, prototype) {
    /**
     *  http://purl.org/ctdl/terms/assertedBy
     *  Agent making a statement based on fact or belief.
     *  @property assertedBy
     *  @type CredentialOrganization | CredentialPerson | QACredentialOrganization
     */
    prototype.assertedBy = null;
    /**
     *  http://purl.org/ctdl/terms/description
     *  Statememnt, characterization or account of the entity.
     *  @property description
     *  @type langString
     */
    prototype.description = null;
    /**
     *  http://purl.org/ctdl/terms/globalJurisdiction
     *  Whether or not the credential is useful, applicable or recognized everywhere.
     *  Exceptions indicated by the ceterms:jurisdictionException property apply.
     *  @property globalJurisdiction
     *  @type boolean
     */
    prototype.globalJurisdiction = false;
    /**
     *  http://purl.org/ctdl/terms/jurisdictionException
     *  Geographic or political region in which the credential is not formally recognized or an organization has no authority to act .
     *  The ceterms:jurisdictionalException property is used in conjunction with the ceterms:jurisdiction property and expresses any exceptions to a more general statement; e.g., the United states except for Colorado.
     *  @property jurisdictionException
     *  @type Place
     */
    prototype.jurisdictionException = null;
    /**
     *  http://purl.org/ctdl/terms/mainJurisdiction
     *  Primary geographic or political region in which the credential is recognized as applicable or in which an organization has recognized authority to act.
     *  @property mainJurisdiction
     *  @type Place
     */
    prototype.mainJurisdiction = null;
}, {assertedBy: "Object", jurisdictionException: "Place", mainJurisdiction: "Place", contributor: "Object", reviews: "Review", audience: "Audience", timeRequired: "Duration", publication: "PublicationEvent", contentLocation: "Place", temporalCoverage: "Object", isBasedOn: "Object", fileFormat: "Object", interactionStatistic: "InteractionCounter", recordedAt: "Event", isPartOf: "CreativeWork", exampleOfWork: "CreativeWork", dateCreated: "Object", releasedEvent: "PublicationEvent", publisher: "Object", encoding: "MediaObject", creator: "Object", hasPart: "CreativeWork", license: "Object", translator: "Object", offers: "Offer", schemaVersion: "Object", review: "Review", position: "Object", genre: "Object", character: "Person", producer: "Object", editor: "Person", locationCreated: "Place", about: "Thing", audio: "AudioObject", encodings: "MediaObject", funder: "Object", accountablePerson: "Person", material: "Object", author: "Object", sourceOrganization: "Organization", sponsor: "Object", provider: "Object", copyrightHolder: "Object", comment: "Comment", spatialCoverage: "Place", aggregateRating: "AggregateRating", educationalAlignment: "AlignmentObject", video: "VideoObject", version: "Object", mainEntity: "Thing", associatedMedia: "MediaObject", workExample: "CreativeWork", mentions: "Thing", citation: "Object", dateModified: "Object", inLanguage: "Object", isBasedOnUrl: "Object", identifier: "Object", image: "Object", potentialAction: "Action", mainEntityOfPage: "Object", owner: {name: "Array", arguments: [null]}, signature: {name: "Array", arguments: [null]}, reader: {name: "Array", arguments: [null]}, atProperties: {name: "Array", arguments: [null]}}, {});
