/*
 * Decompiled with CFR 0.152.
 */
package sbtbuildinfo;

import com.eed3si9n.manifesto.Manifesto;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import sbt.internal.util.Attributed;
import sbtbuildinfo.BuildInfoOption$ToJson$;
import sbtbuildinfo.BuildInfoOption$ToMap$;
import sbtbuildinfo.BuildInfoRenderer;
import sbtbuildinfo.BuildInfoResult;
import sbtbuildinfo.BuildInfoType;
import sbtbuildinfo.BuildInfoType$Source$;
import sbtbuildinfo.PluginCompat$TypeExpression$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;

public abstract class JavaRenderer
implements BuildInfoRenderer {
    private final String pkg;
    private final String cl;
    private final boolean makeStatic;
    private final String buildUrlLines;
    private final String buildMapLines;

    public JavaRenderer(String pkg, String cl, boolean makeStatic) {
        this.pkg = pkg;
        this.cl = cl;
        this.makeStatic = makeStatic;
        this.buildUrlLines = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("  private static java.net.URL internalAsUrl(String urlString) {\n      |    try {\n      |      return new java.net.URI(urlString).toURL();\n      |    } catch (Exception e) {\n      |      return null;\n      |    }\n      |  }\n      |"));
        this.buildMapLines = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("  @SuppressWarnings({\"unchecked\", \"rawtypes\"})\n      |  private static <K, V> java.util.Map<K, V> internalAsMap(java.util.Map.Entry... entries) {\n      |    java.util.Map<K, V> m = new java.util.HashMap<>();\n      |    for (java.util.Map.Entry e : entries) {\n      |      m.put((K) e.getKey(), (V) e.getValue());\n      |    }\n      |    return java.util.Collections.unmodifiableMap(m);\n      |  }\n      |"));
    }

    @Override
    public BuildInfoType fileType() {
        return BuildInfoType$Source$.MODULE$;
    }

    @Override
    public String extension() {
        return "java";
    }

    public List<String> header() {
        return (List)new .colon.colon((Object)"// $COVERAGE-OFF$", (List)new .colon.colon((Object)new StringBuilder(9).append("package ").append(this.pkg).append(";").toString(), (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"/** This file was generated by sbt-buildinfo. */", (List)new .colon.colon((Object)new StringBuilder(21).append("public final class ").append(this.cl).append(" {").toString(), (List)new .colon.colon((Object)new StringBuilder(15).append("  private ").append(this.cl).append("() {}").toString(), (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)))))));
    }

    public List<String> footer() {
        return (List)new .colon.colon((Object)"}", (List)new .colon.colon((Object)"// $COVERAGE-ON$", (List)Nil$.MODULE$));
    }

    public scala.collection.immutable.Seq<String> line(BuildInfoResult result) {
        String mod = this.makeStatic ? " static" : "";
        return (scala.collection.immutable.Seq)this.getJavaType(result.manifest()).map((Function1 & Serializable)typeDecl -> (List)new .colon.colon((Object)new StringBuilder(23).append("  /** The value is ").append(this.quote(result.value())).append(". */").toString(), (List)new .colon.colon((Object)new StringBuilder(20).append("  public").append(mod).append(" final ").append((String)typeDecl).append(" ").append(result.identifier()).append(" = ").append(this.quote(result.value())).append(";").toString(), (List)Nil$.MODULE$))).getOrElse(JavaRenderer::line$$anonfun$2);
    }

    public String buildUrlLines() {
        return this.buildUrlLines;
    }

    public String buildMapLines() {
        return this.buildMapLines;
    }

    public String toStringLines(scala.collection.immutable.Seq<BuildInfoResult> results) {
        String mod = this.makeStatic ? " static" : "";
        String methodPrefix = this.makeStatic ? "make" : "to";
        scala.collection.immutable.Seq idents = (scala.collection.immutable.Seq)((IterableOps)results.filter((Function1 & Serializable)v -> this.getJavaType(v.manifest()).isDefined())).map((Function1 & Serializable)_$1 -> _$1.identifier());
        String fmt = ((IterableOnceOps)idents.map((Function1 & Serializable)_$2 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s: %%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{_$2})))).mkString(", ");
        String vars = idents.mkString(", ");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(123).append("\n       |  public").append(mod).append(" String ").append(methodPrefix).append("String() {\n       |    return String.format(\"").append(fmt).append("\",\n       |      ").append(vars).append("\n       |    );\n       |  }\n       |").toString()));
    }

    public scala.collection.immutable.Seq<String> toMapLines(scala.collection.immutable.Seq<BuildInfoResult> results) {
        if (this.options().contains((Object)BuildInfoOption$ToMap$.MODULE$) || this.options().contains((Object)BuildInfoOption$ToJson$.MODULE$)) {
            String mod = this.makeStatic ? " static" : "";
            String methodPrefix = this.makeStatic ? "make" : "to";
            return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)new .colon.colon((Object)new StringBuilder(46).append("  public").append(mod).append(" java.util.Map<String, Object> ").append(methodPrefix).append("Map() {").toString(), (List)new .colon.colon((Object)"    java.util.Map<String, Object> m = new java.util.HashMap<>();", (List)Nil$.MODULE$))).$plus$plus((IterableOnce)((IterableOps)results.filter((Function1 & Serializable)v -> this.getJavaType(v.manifest()).isDefined())).map((Function1 & Serializable)result -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("    m.put(\"%s\", %s);"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{result.identifier(), result.identifier()}))))).$plus$plus((IterableOnce)new .colon.colon((Object)"    return java.util.Collections.unmodifiableMap(m);", (List)new .colon.colon((Object)"  }", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))));
        }
        return package$.MODULE$.Nil();
    }

    public scala.collection.immutable.Seq<String> buildJsonLines() {
        if (this.options().contains((Object)BuildInfoOption$ToJson$.MODULE$)) {
            return (scala.collection.immutable.Seq)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1780).append("  private static String quote(Object x) {\n           |    return \"\\\"\" + x + \"\\\"\";\n           |  }\n           |\n           |  @SuppressWarnings({\"unchecked\"})\n           |  private static String toJsonValue(Object value) {\n           |    if (value instanceof java.util.Collection) {\n           |      return ((java.util.Collection<Object>) value)\n           |          .stream().map(").append(this.cl).append("::toJsonValue).collect(java.util.stream.Collectors.joining(\",\", \"[\", \"]\"));\n           |    } else if (value instanceof java.util.Optional) {\n           |      return ((java.util.Optional<Object>) value).map(").append(this.cl).append("::toJsonValue).orElse(\"null\");\n           |    } else if (value instanceof java.util.Map) {\n           |      return ((java.util.Map<Object, Object>) value)\n           |          .entrySet().stream()\n           |              .map(e -> toJsonValue(e.getKey().toString()) + \":\" + toJsonValue(e.getValue()))\n           |              .collect(java.util.stream.Collectors.joining(\", \", \"{\", \"}\"));\n           |    } else if (value instanceof Double) {\n           |      return value.toString();\n           |    } else if (value instanceof Float) {\n           |      return value.toString();\n           |    } else if (value instanceof Long) {\n           |      return value.toString();\n           |    } else if (value instanceof Integer) {\n           |      return value.toString();\n           |    } else if (value instanceof Short) {\n           |      return value.toString();\n           |    } else if (value instanceof Boolean) {\n           |      return value.toString();\n           |    } else if (value instanceof String) {\n           |      return quote(value);\n           |    } else {\n           |      return quote(value.toString());\n           |    }\n           |  }\n           |").toString())), (List)Nil$.MODULE$);
        }
        return package$.MODULE$.Nil();
    }

    public scala.collection.immutable.Seq<String> toJsonLines() {
        if (this.options().contains((Object)BuildInfoOption$ToJson$.MODULE$)) {
            String mod = this.makeStatic ? " static" : "";
            String methodPrefix = this.makeStatic ? "make" : "to";
            return (scala.collection.immutable.Seq)new .colon.colon((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(48).append("  public").append(mod).append(" final String ").append(methodPrefix).append("Json = toJsonValue(").append(methodPrefix).append("Map());").toString())), (List)Nil$.MODULE$);
        }
        return package$.MODULE$.Nil();
    }

    public Option<String> getJavaType(Manifesto<?> m) {
        return JavaRenderer.tpeToReturnType$1(m);
    }

    public String quote(Object v2) {
        Object object = v2;
        if (object instanceof Integer || object instanceof Short || object instanceof Double || object instanceof Boolean) {
            Object x2 = object;
            return x2.toString();
        }
        if (object instanceof Float) {
            float x3 = BoxesRunTime.unboxToFloat((Object)object);
            return new StringBuilder(1).append(BoxesRunTime.boxToFloat((float)x3).toString()).append("f").toString();
        }
        if (object instanceof Symbol) {
            Symbol x4 = (Symbol)object;
            return new StringBuilder(13).append("(\"").append(x4.name()).append("\").intern()").toString();
        }
        if (object instanceof Long) {
            long x5 = BoxesRunTime.unboxToLong((Object)object);
            return new StringBuilder(1).append(BoxesRunTime.boxToLong((long)x5).toString()).append("L").toString();
        }
        if (object instanceof NodeSeq) {
            NodeSeq nodeSeq = (NodeSeq)object;
            NodeSeq node = nodeSeq;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(node.toString().trim()))) {
                return node.toString();
            }
            NodeSeq node2 = nodeSeq;
            return NodeSeq$.MODULE$.Empty().toString();
        }
        if (object instanceof Tuple2) {
            Tuple2 tuple2 = (Tuple2)object;
            Object k = tuple2._1();
            Object _v = tuple2._2();
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("new java.util.AbstractMap.SimpleImmutableEntry<>(%s, %s)"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(k), this.quote(_v)}));
        }
        if (object instanceof Map) {
            Map mp = (Map)object;
            return mp.toList().map((Function1 & Serializable)_$3 -> this.quote(_$3)).mkString("internalAsMap(", ", ", ")");
        }
        if (object instanceof Seq) {
            Seq seq = (Seq)object;
            return ((IterableOnceOps)seq.map((Function1 & Serializable)v -> this.quote(v))).mkString("java.util.Collections.unmodifiableList(java.util.Arrays.asList(", ", ", "))");
        }
        if (object instanceof Option) {
            Option op = (Option)object;
            return (String)op.map((Function1 & Serializable)x -> new StringBuilder(23).append("java.util.Optional.of(").append(this.quote(x)).append(")").toString()).getOrElse(JavaRenderer::quote$$anonfun$4);
        }
        if (object instanceof URL) {
            URL url = (URL)object;
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("internalAsUrl(%s)"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(url.toString())}));
        }
        if (object instanceof File) {
            File file = (File)object;
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("new java.io.File(%s)"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(file.toString())}));
        }
        if (object instanceof Attributed) {
            Attributed attr = (Attributed)object;
            return this.quote(attr.data());
        }
        if (object instanceof LocalDate) {
            LocalDate date = (LocalDate)object;
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("java.time.LocalDate.parse(%s)"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(date.toString())}));
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("java.time.Instant.parse(%s)"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.quote(instant.toString())}));
        }
        Object s = object;
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\"%s\""), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.encodeStringLiteral(s.toString())}));
    }

    public String encodeStringLiteral(String str) {
        return str.replace("\\", "\\\\").replace("\n", "\\n").replace("\b", "\\b").replace("\r", "\\r").replace("\t", "\\t").replace("'", "\\'").replace("\f", "\\f").replace("\"", "\\\"");
    }

    private static final List line$$anonfun$2() {
        return package$.MODULE$.List().empty();
    }

    private static final Option tpeToReturnType$1(Manifesto tpe) {
        Manifesto manifesto = tpe;
        if (manifesto != null) {
            SeqOps seqOps;
            SeqOps seqOps2;
            SeqOps seqOps3;
            Manifesto manifesto2;
            SeqOps seqOps4;
            Tuple2<String, List<Manifesto<?>>> tuple2 = PluginCompat$TypeExpression$.MODULE$.unapply(manifesto);
            String string = (String)tuple2._1();
            List list = (List)tuple2._2();
            if ("Any".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    return None$.MODULE$;
                }
            }
            if ("Short".equals(string) || "scala.Short".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list3 = list;
                if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                    return Some$.MODULE$.apply((Object)"Short");
                }
            }
            if ("Int".equals(string) || "scala.Int".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list4 = list;
                if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                    return Some$.MODULE$.apply((Object)"Integer");
                }
            }
            if ("Long".equals(string) || "scala.Long".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list5 = list;
                if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                    return Some$.MODULE$.apply((Object)"Long");
                }
            }
            if ("Double".equals(string) || "scala.Double".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list6 = list;
                if (!(nil$ != null ? !nil$.equals(list6) : list6 != null)) {
                    return Some$.MODULE$.apply((Object)"Double");
                }
            }
            if ("Float".equals(string) || "scala.Float".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list7 = list;
                if (!(nil$ != null ? !nil$.equals(list7) : list7 != null)) {
                    return Some$.MODULE$.apply((Object)"Float");
                }
            }
            if ("Boolean".equals(string) || "scala.Boolean".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list8 = list;
                if (!(nil$ != null ? !nil$.equals(list8) : list8 != null)) {
                    return Some$.MODULE$.apply((Object)"Boolean");
                }
            }
            if ("scala.Symbol".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list9 = list;
                if (!(nil$ != null ? !nil$.equals(list9) : list9 != null)) {
                    return Some$.MODULE$.apply((Object)"String");
                }
            }
            if ("java.lang.String".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list10 = list;
                if (!(nil$ != null ? !nil$.equals(list10) : list10 != null)) {
                    return Some$.MODULE$.apply((Object)"String");
                }
            }
            if ("java.net.URL".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list11 = list;
                if (!(nil$ != null ? !nil$.equals(list11) : list11 != null)) {
                    return Some$.MODULE$.apply((Object)"java.net.URL");
                }
            }
            if ("sbt.URL".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list12 = list;
                if (!(nil$ != null ? !nil$.equals(list12) : list12 != null)) {
                    return Some$.MODULE$.apply((Object)"java.net.URL");
                }
            }
            if ("java.io.File".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list13 = list;
                if (!(nil$ != null ? !nil$.equals(list13) : list13 != null)) {
                    return Some$.MODULE$.apply((Object)"java.io.File");
                }
            }
            if ("sbt.File".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list14 = list;
                if (!(nil$ != null ? !nil$.equals(list14) : list14 != null)) {
                    return Some$.MODULE$.apply((Object)"java.io.File");
                }
            }
            if ("scala.xml.NodeSeq".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list15 = list;
                if (!(nil$ != null ? !nil$.equals(list15) : list15 != null)) {
                    return None$.MODULE$;
                }
            }
            if ("sbt.ModuleID".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list16 = list;
                if (!(nil$ != null ? !nil$.equals(list16) : list16 != null)) {
                    return Some$.MODULE$.apply((Object)"String");
                }
            }
            if ("sbt.Resolver".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list17 = list;
                if (!(nil$ != null ? !nil$.equals(list17) : list17 != null)) {
                    return Some$.MODULE$.apply((Object)"String");
                }
            }
            if ("xsbti.HashedVirtualFileRef".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list18 = list;
                if (!(nil$ != null ? !nil$.equals(list18) : list18 != null)) {
                    return Some$.MODULE$.apply((Object)"String");
                }
            }
            if ("xsbti.VirtualFileRef".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list19 = list;
                if (!(nil$ != null ? !nil$.equals(list19) : list19 != null)) {
                    return Some$.MODULE$.apply((Object)"String");
                }
            }
            if ("xsbti.VirtualFile".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list20 = list;
                if (!(nil$ != null ? !nil$.equals(list20) : list20 != null)) {
                    return Some$.MODULE$.apply((Object)"String");
                }
            }
            if ("sbt.librarymanagement.ModuleID".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list21 = list;
                if (!(nil$ != null ? !nil$.equals(list21) : list21 != null)) {
                    return Some$.MODULE$.apply((Object)"String");
                }
            }
            if ("sbt.librarymanagement.Resolver".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list22 = list;
                if (!(nil$ != null ? !nil$.equals(list22) : list22 != null)) {
                    return Some$.MODULE$.apply((Object)"String");
                }
            }
            if ("sbt.internal.util.Attributed".equals(string) && list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps4 = package$.MODULE$.Seq().unapplySeq((SeqOps)list), 1) == 0 && (manifesto2 = (Manifesto)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps4, 0)) != null) {
                Tuple2<String, List<Manifesto<?>>> tuple22 = PluginCompat$TypeExpression$.MODULE$.unapply(manifesto2);
                String string2 = (String)tuple22._1();
                List list23 = (List)tuple22._2();
                if ("java.io.File".equals(string2)) {
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list24 = list23;
                    if (!(nil$ != null ? !nil$.equals(list24) : list24 != null)) {
                        return Some$.MODULE$.apply((Object)"java.io.File");
                    }
                }
                if ("xsbti.HashedVirtualFileRef".equals(string2)) {
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list25 = list23;
                    if (!(nil$ != null ? !nil$.equals(list25) : list25 != null)) {
                        return Some$.MODULE$.apply((Object)"String");
                    }
                }
            }
            if ("scala.Option".equals(string) && list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps3 = package$.MODULE$.Seq().unapplySeq((SeqOps)list), 1) == 0) {
                Manifesto manifesto3;
                Manifesto arg = manifesto3 = (Manifesto)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps3, 0);
                return JavaRenderer.tpeToReturnType$1(arg).map((Function1 & Serializable)x -> new StringBuilder(20).append("java.util.Optional<").append((String)x).append(">").toString());
            }
            if ("scala.collection.Seq".equals(string) || "scala.collection.immutable.Seq".equals(string)) {
                SeqOps seqOps5;
                if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps5 = package$.MODULE$.Seq().unapplySeq((SeqOps)list), 1) == 0) {
                    Manifesto manifesto4;
                    Manifesto arg = manifesto4 = (Manifesto)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps5, 0);
                    return JavaRenderer.tpeToReturnType$1(arg).map((Function1 & Serializable)x -> new StringBuilder(22).append("java.util.Collection<").append((String)x).append(">").toString());
                }
            }
            if ("scala.collection.immutable.Map".equals(string) && list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)list), 2) == 0) {
                Manifesto manifesto5 = (Manifesto)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps2, 0);
                Manifesto manifesto6 = (Manifesto)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps2, 1);
                Manifesto arg0 = manifesto5;
                Manifesto arg1 = manifesto6;
                return JavaRenderer.tpeToReturnType$1(arg0).flatMap((Function1 & Serializable)x0 -> JavaRenderer.tpeToReturnType$1(arg1).map((Function1 & Serializable)x1 -> new StringBuilder(17).append("java.util.Map<").append((String)x0).append(", ").append((String)x1).append(">").toString()));
            }
            if ("scala.Tuple2".equals(string) && list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)list), 2) == 0) {
                Manifesto manifesto7 = (Manifesto)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                Manifesto manifesto8 = (Manifesto)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                Manifesto arg0 = manifesto7;
                Manifesto arg1 = manifesto8;
                return JavaRenderer.tpeToReturnType$1(arg0).flatMap((Function1 & Serializable)x0 -> JavaRenderer.tpeToReturnType$1(arg1).map((Function1 & Serializable)x1 -> new StringBuilder(23).append("java.util.Map.Entry<").append((String)x0).append(", ").append((String)x1).append(">").toString()));
            }
            if ("java.time.LocalDate".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list26 = list;
                if (!(nil$ != null ? !nil$.equals(list26) : list26 != null)) {
                    return Some$.MODULE$.apply((Object)"java.time.LocalDate");
                }
            }
            if ("java.time.Instant".equals(string)) {
                Nil$ nil$ = package$.MODULE$.Nil();
                List list27 = list;
                if (!(nil$ != null ? !nil$.equals(list27) : list27 != null)) {
                    return Some$.MODULE$.apply((Object)"java.time.Instant");
                }
            }
        }
        return None$.MODULE$;
    }

    private static final String quote$$anonfun$4() {
        return "java.util.Optional.empty()";
    }
}

