/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.client;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.ResponseEntity;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.BufferOverflowException;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import akka.stream.StreamTcpException;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.scaladsl.TcpIdleTimeoutException;
import akka.util.ByteString;
import com.emarsys.client.Config;
import com.emarsys.client.Config$;
import com.emarsys.client.RestClientErrors;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import spray.json.DeserializationException;

@ScalaSignature(bytes="\u0006\u0005\u0011UcaB8q!\u0003\r\ta\u001e\u0005\u0006}\u0002!\ta \u0005\n\u0003\u000f\u0001!\u0019!D\u0002\u0003\u0013A!\"a\u0007\u0001\u0011\u000b\u0007I\u0011AA\u000f\u0011%\tY\u0003\u0001b\u0001\u000e\u0007\ti\u0003C\u0005\u0002<\u0001\u0011\r\u0011\"\u0001\u0002>!I\u00111\u000b\u0001C\u0002\u0013\u0005\u0011Q\u000b\u0005\b\u0003s\u0002A\u0011CA>\u0011\u001d\t\t\u000b\u0001C\t\u0003GC\u0011\"!3\u0001#\u0003%\t\"a3\t\u000f\u0005\u0005\b\u0001\"\u0005\u0002d\"I!1\u0004\u0001\u0012\u0002\u0013E!Q\u0004\u0005\b\u0005C\u0001A\u0011\u0003B\u0012\u0011%\u0011I\u0003AI\u0001\n#\tY\rC\u0004\u0003,\u0001!IA!\f\t\u000f\r\u0005\b\u0001\"\u0003\u0004d\"9A1\u0001\u0001\u0005\n\u0011\u0015\u0001b\u0002C\u000f\u0001\u0011%Aq\u0004\u0005\b\t[\u0001A\u0011\u0002C\u0018\u0011\u001d!\t\u0005\u0001C\u0005\t\u0007:qA!\u0013q\u0011\u0003\u0011YE\u0002\u0004pa\"\u0005!Q\n\u0005\b\u0005\u001f*B\u0011\u0001B)\r)\u0011\u0019&\u0006I\u0001$C)\"Q\u000b\u0004\b\u0005s,\")\u0006B~\u0011)\u0011i\u0007\u0007BK\u0002\u0013\u0005!q\u000e\u0005\u000b\u0005cB\"\u0011#Q\u0001\n\u0005\r\u0005b\u0002B(1\u0011\u0005!Q \u0005\n\u0005sB\u0012\u0011!C\u0001\u0007\u0007A\u0011Ba \u0019#\u0003%\tA!!\t\u0013\t\u0015\u0005$!A\u0005B\t\u001d\u0005\"\u0003BM1\u0005\u0005I\u0011\u0001BN\u0011%\u0011\u0019\u000bGA\u0001\n\u0003\u00199\u0001C\u0005\u0003,b\t\t\u0011\"\u0001\u0004\f!I!q\u0017\r\u0002\u0002\u0013\u00053q\u0002\u0005\n\u0005{C\u0012\u0011!C!\u0005\u007fC\u0011B!1\u0019\u0003\u0003%\tEa1\t\u0013\t\u0015\u0007$!A\u0005B\rMqACB\f+\u0005\u0005\t\u0012A\u000b\u0004\u001a\u0019Q!\u0011`\u000b\u0002\u0002#\u0005Qca\u0007\t\u000f\t=s\u0005\"\u0001\u00044!I!\u0011Y\u0014\u0002\u0002\u0013\u0015#1\u0019\u0005\n\u0007k9\u0013\u0011!CA\u0007oA\u0011ba\u000f(\u0003\u0003%\ti!\u0010\t\u0013\r%s%!A\u0005\n\r-ca\u0002B-+\t+\"1\f\u0005\u000b\u0005[j#Q3A\u0005\u0002\t=\u0004B\u0003B9[\tE\t\u0015!\u0003\u0002\u0004\"9!qJ\u0017\u0005\u0002\tM\u0004\"\u0003B=[\u0005\u0005I\u0011\u0001B>\u0011%\u0011y(LI\u0001\n\u0003\u0011\t\tC\u0005\u0003\u00066\n\t\u0011\"\u0011\u0003\b\"I!\u0011T\u0017\u0002\u0002\u0013\u0005!1\u0014\u0005\n\u0005Gk\u0013\u0011!C\u0001\u0005KC\u0011Ba+.\u0003\u0003%\tA!,\t\u0013\t]V&!A\u0005B\te\u0006\"\u0003B_[\u0005\u0005I\u0011\tB`\u0011%\u0011\t-LA\u0001\n\u0003\u0012\u0019\rC\u0005\u0003F6\n\t\u0011\"\u0011\u0003H\u001eQ11K\u000b\u0002\u0002#\u0005Qc!\u0016\u0007\u0015\teS#!A\t\u0002U\u00199\u0006C\u0004\u0003Pq\"\taa\u0017\t\u0013\t\u0005G(!A\u0005F\t\r\u0007\"CB\u001by\u0005\u0005I\u0011QB/\u0011%\u0019Y\u0004PA\u0001\n\u0003\u001b\t\u0007C\u0005\u0004Jq\n\t\u0011\"\u0003\u0004L\u00199!1Z\u000bC+\t5\u0007B\u0003Bh\u0005\nU\r\u0011\"\u0001\u0003R\"Q!\u0011\u001c\"\u0003\u0012\u0003\u0006IAa5\t\u000f\t=#\t\"\u0001\u0003\\\"I!\u0011\u0010\"\u0002\u0002\u0013\u0005!\u0011\u001d\u0005\n\u0005\u007f\u0012\u0015\u0013!C\u0001\u0005KD\u0011B!\"C\u0003\u0003%\tEa\"\t\u0013\te%)!A\u0005\u0002\tm\u0005\"\u0003BR\u0005\u0006\u0005I\u0011\u0001Bu\u0011%\u0011YKQA\u0001\n\u0003\u0011i\u000fC\u0005\u00038\n\u000b\t\u0011\"\u0011\u0003r\"I!Q\u0018\"\u0002\u0002\u0013\u0005#q\u0018\u0005\n\u0005\u0003\u0014\u0015\u0011!C!\u0005\u0007D\u0011B!2C\u0003\u0003%\tE!>\b\u0015\r\u0015T#!A\t\u0002U\u00199G\u0002\u0006\u0003LV\t\t\u0011#\u0001\u0016\u0007SBqAa\u0014R\t\u0003\u0019i\u0007C\u0005\u0003BF\u000b\t\u0011\"\u0012\u0003D\"I1QG)\u0002\u0002\u0013\u00055q\u000e\u0005\n\u0007w\t\u0016\u0011!CA\u0007gB\u0011b!\u0013R\u0003\u0003%Iaa\u0013\u0007\u000f\reTCQ\u000b\u0004|!Q1QP,\u0003\u0016\u0004%\tAa'\t\u0015\r}tK!E!\u0002\u0013\u0011i\n\u0003\u0006\u0004\u0002^\u0013)\u001a!C\u0001\u0007\u0007C!ba%X\u0005#\u0005\u000b\u0011BBC\u0011\u001d\u0011ye\u0016C\u0001\u0007+C\u0011B!\u001fX\u0003\u0003%\ta!(\t\u0013\t}t+%A\u0005\u0002\r\r\u0006\"CBT/F\u0005I\u0011ABU\u0011%\u0011)iVA\u0001\n\u0003\u00129\tC\u0005\u0003\u001a^\u000b\t\u0011\"\u0001\u0003\u001c\"I!1U,\u0002\u0002\u0013\u00051Q\u0016\u0005\n\u0005W;\u0016\u0011!C\u0001\u0007cC\u0011Ba.X\u0003\u0003%\te!.\t\u0013\tuv+!A\u0005B\t}\u0006\"\u0003Ba/\u0006\u0005I\u0011\tBb\u0011%\u0011)mVA\u0001\n\u0003\u001aIl\u0002\u0006\u0004>V\t\t\u0011#\u0001\u0016\u0007\u007f3!b!\u001f\u0016\u0003\u0003E\t!FBa\u0011\u001d\u0011y%\u001bC\u0001\u0007\u0013D\u0011B!1j\u0003\u0003%)Ea1\t\u0013\rU\u0012.!A\u0005\u0002\u000e-\u0007\"CB\u001eS\u0006\u0005I\u0011QBi\u0011%\u0019I%[A\u0001\n\u0013\u0019YE\u0001\u0006SKN$8\t\\5f]RT!!\u001d:\u0002\r\rd\u0017.\u001a8u\u0015\t\u0019H/A\u0004f[\u0006\u00148/_:\u000b\u0003U\f1aY8n\u0007\u0001\u0019\"\u0001\u0001=\u0011\u0005edX\"\u0001>\u000b\u0003m\fQa]2bY\u0006L!! >\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\u0011\u0011\u0011\u0001\t\u0004s\u0006\r\u0011bAA\u0003u\n!QK\\5u\u0003\u0019\u0019\u0018p\u001d;f[V\u0011\u00111\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u0015\t7\r^8s\u0015\t\t)\"\u0001\u0003bW.\f\u0017\u0002BA\r\u0003\u001f\u00111\"Q2u_J\u001c\u0016p\u001d;f[\u0006aQ.\u0019;fe&\fG.\u001b>feV\u0011\u0011q\u0004\t\u0005\u0003C\t9#\u0004\u0002\u0002$)!\u0011QEA\n\u0003\u0019\u0019HO]3b[&!\u0011\u0011FA\u0012\u00051i\u0015\r^3sS\u0006d\u0017N_3s\u0003!)\u00070Z2vi>\u0014XCAA\u0018!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001bu\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u00121\u0007\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\u0018!\u00034bS2dUM^3m+\t\ty\u0004\u0005\u0003\u0002B\u00055c\u0002BA\"\u0003\u0013j!!!\u0012\u000b\t\u0005\u001d\u00131C\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003\u0017\n)%A\u0004M_\u001e<\u0017N\\4\n\t\u0005=\u0013\u0011\u000b\u0002\t\u0019><G*\u001a<fY*!\u00111JA#\u0003I!WMZ1vYR\u0014V\r\u001e:z\u0007>tg-[4\u0016\u0005\u0005]\u0003\u0003BA-\u0003crA!a\u0017\u0002n9!\u0011QLA6\u001d\u0011\ty&!\u001b\u000f\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001aw\u0003\u0019a$o\\8u}%\tQ/\u0003\u0002ti&\u0011\u0011O]\u0005\u0004\u0003_\u0002\u0018AB\"p]\u001aLw-\u0003\u0003\u0002t\u0005U$a\u0003*fiJL8i\u001c8gS\u001eL1!a\u001eq\u0005\u0019\u0019uN\u001c4jO\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u0011\ti(a&\u0011\r\u0005E\u0012qPAB\u0013\u0011\t\t)a\r\u0003\r\u0019+H/\u001e:f!\u0011\t))a%\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000bQ!\\8eK2TA!!$\u0002\u0010\u0006A1oY1mC\u0012\u001cHN\u0003\u0003\u0002\u0012\u0006M\u0011\u0001\u00025uiBLA!!&\u0002\b\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\"9\u0011\u0011T\u0004A\u0002\u0005m\u0015a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u000b\u000bi*\u0003\u0003\u0002 \u0006\u001d%a\u0003%uiB\u0014V-];fgR\f1B];o'R\u0014X-Y7fIR1\u0011QUAb\u0003\u000b\u0004\u0002\"a*\u0002,\u0006=\u00161X\u0007\u0003\u0003SSA!!$\u0002$%!\u0011QVAU\u0005\u0019\u0019v.\u001e:dKB!\u0011\u0011WA\\\u001b\t\t\u0019L\u0003\u0003\u00026\u0006M\u0011\u0001B;uS2LA!!/\u00024\nQ!)\u001f;f'R\u0014\u0018N\\4\u0011\t\u0005u\u0016qX\u0007\u0003\u0003'IA!!1\u0002\u0014\t9aj\u001c;Vg\u0016$\u0007bBAM\u0011\u0001\u0007\u00111\u0014\u0005\n\u0003\u000fD\u0001\u0013!a\u0001\u0003/\n1B]3uef\u001cuN\u001c4jO\u0006)\"/\u001e8TiJ,\u0017-\\3eI\u0011,g-Y;mi\u0012\u0012TCAAgU\u0011\t9&a4,\u0005\u0005E\u0007\u0003BAj\u0003;l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a7{\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\f)NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1A];o+\u0011\t)/a<\u0015\r\u0005\u001d(q\u0003B\r)\u0011\tIO!\u0001\u0011\r\u0005E\u0012qPAv!\u0011\ti/a<\r\u0001\u00119\u0011\u0011\u001f\u0006C\u0002\u0005M(!A*\u0012\t\u0005U\u00181 \t\u0004s\u0006]\u0018bAA}u\n9aj\u001c;iS:<\u0007cA=\u0002~&\u0019\u0011q >\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\u0004)\u0001\u001dA!\u0002\u0002\u0005Ul\u0007\u0003\u0003B\u0004\u0005\u001b\u0011\t\"a;\u000e\u0005\t%!\u0002\u0002B\u0006\u0003\u0017\u000bQ\"\u001e8nCJ\u001c\b.\u00197mS:<\u0017\u0002\u0002B\b\u0005\u0013\u0011A\"\u00168nCJ\u001c\b.\u00197mKJ\u0004B!!\"\u0003\u0014%!!QCAD\u00059\u0011Vm\u001d9p]N,WI\u001c;jifDq!!'\u000b\u0001\u0004\tY\nC\u0005\u0002H*\u0001\n\u00111\u0001\u0002X\u0005i!/\u001e8%I\u00164\u0017-\u001e7uII*B!a3\u0003 \u00119\u0011\u0011_\u0006C\u0002\u0005M\u0018A\u0002:v]J\u000bw\u000f\u0006\u0004\u0002~\t\u0015\"q\u0005\u0005\b\u00033c\u0001\u0019AAN\u0011%\t9\r\u0004I\u0001\u0002\u0004\t9&\u0001\tsk:\u0014\u0016m\u001e\u0013eK\u001a\fW\u000f\u001c;%e\u0005Y\u0011N\u001c;fe:\fGNU;o)\u0019\u0011yc!8\u0004`B1\u0011\u0011GA@\u0005c\u0001\u0002Ba\r\u0003>\t\r\u00131\u0011\b\u0005\u0005k\u0011ID\u0004\u0003\u0002b\t]\u0012\"A>\n\u0007\tm\"0A\u0004qC\u000e\\\u0017mZ3\n\t\t}\"\u0011\t\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\tm\"\u0010E\u0002\u0003F]s1Aa\u0012\u0015\u001b\u0005\u0001\u0018A\u0003*fgR\u001cE.[3oiB\u0019!qI\u000b\u0014\u0005UA\u0018A\u0002\u001fj]&$h\b\u0006\u0002\u0003L\ti!+Z9vKN$(+Z:vYR\u001c\"a\u0006=*\t]i#\t\u0007\u0002\u0010\r\u0006LG.\u001e:f%\u0016\u001c\bo\u001c8tKNAQ\u0006\u001fB/\u0005C\u00129\u0007E\u0002\u0003`]i\u0011!\u0006\t\u0004s\n\r\u0014b\u0001B3u\n9\u0001K]8ek\u000e$\b\u0003\u0002B\u001a\u0005SJAAa\u001b\u0003B\ta1+\u001a:jC2L'0\u00192mK\u0006A!/Z:q_:\u001cX-\u0006\u0002\u0002\u0004\u0006I!/Z:q_:\u001cX\r\t\u000b\u0005\u0005k\u00129\bE\u0002\u0003`5BqA!\u001c1\u0001\u0004\t\u0019)\u0001\u0003d_BLH\u0003\u0002B;\u0005{B\u0011B!\u001c2!\u0003\u0005\r!a!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0011\u0016\u0005\u0003\u0007\u000by-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0013\u0003BAa#\u0003\u00166\u0011!Q\u0012\u0006\u0005\u0005\u001f\u0013\t*\u0001\u0003mC:<'B\u0001BJ\u0003\u0011Q\u0017M^1\n\t\t]%Q\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tu\u0005cA=\u0003 &\u0019!\u0011\u0015>\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m(q\u0015\u0005\n\u0005S+\u0014\u0011!a\u0001\u0005;\u000b1\u0001\u001f\u00132\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BX\u0005k\u00032!\u001fBY\u0013\r\u0011\u0019L\u001f\u0002\b\u0005>|G.Z1o\u0011%\u0011IKNA\u0001\u0002\u0004\tY0\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002BE\u0005wC\u0011B!+8\u0003\u0003\u0005\rA!(\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!#\u0002\r\u0015\fX/\u00197t)\u0011\u0011yK!3\t\u0013\t%&(!AA\u0002\u0005m(\u0001\u0005*fcV,7\u000f^#yG\u0016\u0004H/[8o'!\u0011\u0005P!\u0018\u0003b\t\u001d\u0014!C3yG\u0016\u0004H/[8o+\t\u0011\u0019\u000e\u0005\u0003\u00034\tU\u0017\u0002\u0002Bl\u0005\u0003\u0012\u0011\u0002\u00165s_^\f'\r\\3\u0002\u0015\u0015D8-\u001a9uS>t\u0007\u0005\u0006\u0003\u0003^\n}\u0007c\u0001B0\u0005\"9!qZ#A\u0002\tMG\u0003\u0002Bo\u0005GD\u0011Ba4G!\u0003\u0005\rAa5\u0016\u0005\t\u001d(\u0006\u0002Bj\u0003\u001f$B!a?\u0003l\"I!\u0011\u0016&\u0002\u0002\u0003\u0007!Q\u0014\u000b\u0005\u0005_\u0013y\u000fC\u0005\u0003*.\u000b\t\u00111\u0001\u0002|R!!\u0011\u0012Bz\u0011%\u0011I\u000bTA\u0001\u0002\u0004\u0011i\n\u0006\u0003\u00030\n]\b\"\u0003BU\u001f\u0006\u0005\t\u0019AA~\u0005E\u0019VoY2fgN4W\u000f\u001c*fcV,7\u000f^\n\t1a\u0014iF!\u0019\u0003hQ!!q`B\u0001!\r\u0011y\u0006\u0007\u0005\b\u0005[Z\u0002\u0019AAB)\u0011\u0011yp!\u0002\t\u0013\t5D\u0004%AA\u0002\u0005\rE\u0003BA~\u0007\u0013A\u0011B!+!\u0003\u0003\u0005\rA!(\u0015\t\t=6Q\u0002\u0005\n\u0005S\u000b\u0013\u0011!a\u0001\u0003w$BA!#\u0004\u0012!I!\u0011\u0016\u0012\u0002\u0002\u0003\u0007!Q\u0014\u000b\u0005\u0005_\u001b)\u0002C\u0005\u0003*\u0016\n\t\u00111\u0001\u0002|\u0006\t2+^2dKN\u001ch-\u001e7SKF,Xm\u001d;\u0011\u0007\t}seE\u0003(\u0007;\u0019I\u0003\u0005\u0005\u0004 \r\u0015\u00121\u0011B\u0000\u001b\t\u0019\tCC\u0002\u0004$i\fqA];oi&lW-\u0003\u0003\u0004(\r\u0005\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!11FB\u0019\u001b\t\u0019iC\u0003\u0003\u00040\tE\u0015AA5p\u0013\u0011\u0011Yg!\f\u0015\u0005\re\u0011!B1qa2LH\u0003\u0002B\u0000\u0007sAqA!\u001c+\u0001\u0004\t\u0019)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r}2Q\t\t\u0006s\u000e\u0005\u00131Q\u0005\u0004\u0007\u0007R(AB(qi&|g\u000eC\u0005\u0004H-\n\t\u00111\u0001\u0003\u0000\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r5\u0003\u0003\u0002BF\u0007\u001fJAa!\u0015\u0003\u000e\n1qJ\u00196fGR\fqBR1jYV\u0014XMU3ta>t7/\u001a\t\u0004\u0005?b4#\u0002\u001f\u0004Z\r%\u0002\u0003CB\u0010\u0007K\t\u0019I!\u001e\u0015\u0005\rUC\u0003\u0002B;\u0007?BqA!\u001c@\u0001\u0004\t\u0019\t\u0006\u0003\u0004@\r\r\u0004\"CB$\u0001\u0006\u0005\t\u0019\u0001B;\u0003A\u0011V-];fgR,\u0005pY3qi&|g\u000eE\u0002\u0003`E\u001bR!UB6\u0007S\u0001\u0002ba\b\u0004&\tM'Q\u001c\u000b\u0003\u0007O\"BA!8\u0004r!9!q\u001a+A\u0002\tMG\u0003BB;\u0007o\u0002R!_B!\u0005'D\u0011ba\u0012V\u0003\u0003\u0005\rA!8\u0003'%sG/\u001a:oC2\u001cE.[3oi\u0016\u0013(o\u001c:\u0014\r]C(\u0011\rB4\u0003\u0019\u0019H/\u0019;vg\u000691\u000f^1ukN\u0004\u0013!B2bkN,WCABC!\u0011\u00199ia$\u000f\t\r%51\u0012\t\u0004\u0003CR\u0018bABGu\u00061\u0001K]3eK\u001aLAAa&\u0004\u0012*\u00191Q\u0012>\u0002\r\r\fWo]3!)\u0019\u00199j!'\u0004\u001cB\u0019!qL,\t\u000f\ruD\f1\u0001\u0003\u001e\"91\u0011\u0011/A\u0002\r\u0015ECBBL\u0007?\u001b\t\u000bC\u0005\u0004~u\u0003\n\u00111\u0001\u0003\u001e\"I1\u0011Q/\u0011\u0002\u0003\u00071QQ\u000b\u0003\u0007KSCA!(\u0002P\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCABVU\u0011\u0019))a4\u0015\t\u0005m8q\u0016\u0005\n\u0005S\u0013\u0017\u0011!a\u0001\u0005;#BAa,\u00044\"I!\u0011V2\u0002\u0002\u0003\u0007\u00111 \u000b\u0005\u0005\u0013\u001b9\fC\u0005\u0003*\u0012\f\t\u00111\u0001\u0003\u001eR!!qVB^\u0011%\u0011IkZA\u0001\u0002\u0004\tY0A\nJ]R,'O\\1m\u00072LWM\u001c;FeJ|'\u000fE\u0002\u0003`%\u001cR![Bb\u0007S\u0001\"ba\b\u0004F\nu5QQBL\u0013\u0011\u00199m!\t\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0004@R11qSBg\u0007\u001fDqa! m\u0001\u0004\u0011i\nC\u0004\u0004\u00022\u0004\ra!\"\u0015\t\rM71\u001c\t\u0006s\u000e\u00053Q\u001b\t\bs\u000e]'QTBC\u0013\r\u0019IN\u001f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\r\u001dS.!AA\u0002\r]\u0005bBAM\u001d\u0001\u0007\u00111\u0014\u0005\b\u0003\u000ft\u0001\u0019AA,\u0003Q\u0019XM\u001c3SKF,Xm\u001d;XSRD'+\u001a;ssV!1Q\u001dC\u0001)\u0019\u00199o!@\u0004\u0000R!1\u0011^B{)\u0011\u0011yca;\t\u000f\r5x\u00021\u0001\u0004p\u0006qQM\u001d:peN#\u0018\r^;t\u001b\u0006\u0004\bcB=\u0004r\nM7Q[\u0005\u0004\u0007gT(!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\u00199p\u0004a\u0001\u0007s\f1b\u001d5pk2$'+\u001a;ssB9\u0011p!=\u0004|\n=\u0006c\u0001B#/!9\u0011\u0011T\bA\u0002\u0005m\u0005bBAd\u001f\u0001\u0007\u0011q\u000b\u0003\b\u0003c|!\u0019AAz\u0003-1\u0017-\u001b7SKF,Xm\u001d;\u0016\t\u0011\u001dA1\u0004\u000b\t\t\u0013!)\u0002b\u0006\u0005\u001aA1\u0011\u0011GA@\t\u0017\u0001\u0002\u0002\"\u0004\u0005\u0012\t\r\u0013Q_\u0007\u0003\t\u001fQ1!!.{\u0013\u0011!\u0019\u0002b\u0004\u0003\t1+g\r\u001e\u0005\b\u0007{\u0002\u0002\u0019\u0001BO\u0011\u001d\tI\n\u0005a\u0001\u00037Cqa!!\u0011\u0001\u0004\u0019)\tB\u0004\u0002rB\u0011\r!a=\u0002\u00151|wMR1jYV\u0014X-\u0006\u0003\u0005\"\u0011-B\u0003CA\u0001\tG!)\u0003b\n\t\u000f\ru\u0014\u00031\u0001\u0003\u001e\"9\u0011\u0011T\tA\u0002\u0005m\u0005b\u0002C\u0015#\u0001\u00071QQ\u0001\u0004[N<GaBAy#\t\u0007\u00111_\u0001\tY><'+\u001a;ssV1A\u0011\u0007C\u001e\t\u007f!\u0002\"!\u0001\u00054\u0011UB\u0011\b\u0005\b\u00033\u0013\u0002\u0019AAN\u0011\u001d!9D\u0005a\u0001\u0005;\u000b1B]3ue&,7\u000fT3gi\"91\u0011\u0011\nA\u0002\r\u0015Ea\u0002C\u001f%\t\u0007\u00111\u001f\u0002\u0002\u0003\u00129\u0011\u0011\u001f\nC\u0002\u0005M\u0018aF<ji\"DU-\u00193fe\u0016\u0013(o\u001c:IC:$G.\u001b8h+\u0011!)\u0005\"\u0015\u0015\t\u0011\u001dC1\u000b\t\bs\u0012%CQ\nC(\u0013\r!YE\u001f\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]BA!1\u0007B\u001f\u0005\u0007\"y\u0005\u0005\u0003\u0002n\u0012ECaBAy'\t\u0007\u00111\u001f\u0005\b\u00033\u001b\u0002\u0019AAN\u0001")
public interface RestClient {
    public void com$emarsys$client$RestClient$_setter_$failLevel_$eq(int var1);

    public void com$emarsys$client$RestClient$_setter_$defaultRetryConfig_$eq(Config.RetryConfig var1);

    public ActorSystem system();

    public static /* synthetic */ Materializer materializer$(RestClient $this) {
        return $this.materializer();
    }

    default public Materializer materializer() {
        return (Materializer)Predef$.MODULE$.implicitly((Object)Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system()));
    }

    public ExecutionContextExecutor executor();

    public int failLevel();

    public Config.RetryConfig defaultRetryConfig();

    public static /* synthetic */ Future sendRequest$(RestClient $this, HttpRequest request) {
        return $this.sendRequest(request);
    }

    default public Future<HttpResponse> sendRequest(HttpRequest request) {
        HttpExt qual$1 = Http$.MODULE$.apply((ClassicActorSystemProvider)this.system());
        HttpRequest x$1 = request;
        HttpsConnectionContext x$2 = qual$1.singleRequest$default$2();
        ConnectionPoolSettings x$3 = qual$1.singleRequest$default$3();
        LoggingAdapter x$4 = qual$1.singleRequest$default$4();
        return qual$1.singleRequest(x$1, x$2, x$3, x$4);
    }

    public static /* synthetic */ Source runStreamed$(RestClient $this, HttpRequest request, Config.RetryConfig retryConfig) {
        return $this.runStreamed(request, retryConfig);
    }

    default public Source<ByteString, NotUsed> runStreamed(HttpRequest request, Config.RetryConfig retryConfig) {
        return (Source)Source$.MODULE$.future(this.runRaw(request, retryConfig).map((Function1 & Serializable)x$1 -> x$1.entity().dataBytes(), (ExecutionContext)this.executor())).flatMapConcat((Function1 & Serializable)x -> (Source)Predef$.MODULE$.identity(x));
    }

    public static /* synthetic */ Future run$(RestClient $this, HttpRequest request, Config.RetryConfig retryConfig, Unmarshaller um) {
        return $this.run(request, retryConfig, um);
    }

    default public <S> Future<S> run(HttpRequest request, Config.RetryConfig retryConfig, Unmarshaller<ResponseEntity, S> um) {
        return this.runRaw(request, retryConfig).flatMap((Function1 & Serializable)response -> Unmarshal$.MODULE$.apply((Object)response.entity()).to(um, (ExecutionContext)this.executor(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system())).recoverWith((PartialFunction)new Serializable(this, (HttpResponse)response){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ RestClient $outer;
            private final HttpResponse response$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DeserializationException) {
                    DeserializationException deserializationException = (DeserializationException)A1;
                    return (B1)Unmarshal$.MODULE$.apply((Object)this.response$1.entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)this.$outer.executor(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.$outer.system())).flatMap((Function1 & Serializable)body -> Future$.MODULE$.failed((Throwable)new RestClientErrors.InvalidResponseFormatException(deserializationException.getMessage(), (String)body, (Throwable)deserializationException)), (ExecutionContext)this.$outer.executor());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof DeserializationException;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.response$1 = response$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(spray.json.DeserializationException java.lang.String )}, serializedLambda);
            }
        }, (ExecutionContext)this.executor()), (ExecutionContext)this.executor());
    }

    public static /* synthetic */ Config.RetryConfig runStreamed$default$2$(RestClient $this) {
        return $this.runStreamed$default$2();
    }

    default public Config.RetryConfig runStreamed$default$2() {
        return this.defaultRetryConfig();
    }

    public static /* synthetic */ Config.RetryConfig run$default$2$(RestClient $this) {
        return $this.run$default$2();
    }

    default public <S> Config.RetryConfig run$default$2() {
        return this.defaultRetryConfig();
    }

    public static /* synthetic */ Future runRaw$(RestClient $this, HttpRequest request, Config.RetryConfig retryConfig) {
        return $this.runRaw(request, retryConfig);
    }

    default public Future<HttpResponse> runRaw(HttpRequest request, Config.RetryConfig retryConfig) {
        return this.internalRun(request, retryConfig).map(this.withHeaderErrorHandling(request), (ExecutionContext)this.executor());
    }

    public static /* synthetic */ Config.RetryConfig runRaw$default$2$(RestClient $this) {
        return $this.runRaw$default$2();
    }

    default public Config.RetryConfig runRaw$default$2() {
        return this.defaultRetryConfig();
    }

    private Future<Either<InternalClientError, HttpResponse>> internalRun(HttpRequest request, Config.RetryConfig retryConfig) {
        return this.sendRequestWithRetry(request, retryConfig, (Function1<RequestResult, Object>)(Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)RestClient.shouldRetry$1(result)), (Function1<Throwable, Tuple2<Object, String>>)(Function1 & Serializable)error -> RestClient.errorStatusMap$1(error)).map((Function1 & Serializable)response -> response, (ExecutionContext)this.executor());
    }

    private <S> Future<Either<InternalClientError, HttpResponse>> sendRequestWithRetry(HttpRequest request, Config.RetryConfig retryConfig, Function1<RequestResult, Object> shouldRetry, Function1<Throwable, Tuple2<Object, String>> errorStatusMap) {
        long start = System.nanoTime();
        return this.loop$1(retryConfig.maxRetries(), request, start, retryConfig, shouldRetry, errorStatusMap);
    }

    private <S> Future<Left<InternalClientError, Nothing$>> failRequest(int status, HttpRequest request, String cause) {
        this.logFailure(status, request, cause);
        return Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new InternalClientError(status, cause)));
    }

    private <S> void logFailure(int status, HttpRequest request, String msg) {
        this.system().log().log(this.failLevel(), "Request to {} failed with status: {} / body: {}", (Object)request.uri(), (Object)BoxesRunTime.boxToInteger((int)status), (Object)msg);
    }

    private <A, S> void logRetry(HttpRequest request, int retriesLeft, String cause) {
        this.system().log().info("Retrying request: {} / {} attempt(s) left, cause: {}", (Object)request.uri(), (Object)BoxesRunTime.boxToInteger((int)retriesLeft), (Object)cause);
    }

    private <S> PartialFunction<Either<InternalClientError, S>, S> withHeaderErrorHandling(HttpRequest request) {
        return new Serializable(null, request){
            private static final long serialVersionUID = 0L;
            private final HttpRequest request$2;

            public final <A1 extends Either<InternalClientError, S>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Left left;
                InternalClientError internalClientError;
                A1 A1 = x1;
                if (A1 instanceof Left && (internalClientError = (InternalClientError)(left = (Left)A1).value()) != null) {
                    int status = internalClientError.status();
                    String responseBody = internalClientError.cause();
                    throw new RestClientErrors.RestClientException(new StringBuilder(31).append("Rest client request failed for ").append(this.request$2.uri()).toString(), status, responseBody);
                }
                if (A1 instanceof Right) {
                    Right right = (Right)A1;
                    Object response = right.value();
                    return (B1)response;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Either<InternalClientError, S> x1) {
                Left left;
                InternalClientError internalClientError;
                Either<InternalClientError, S> either = x1;
                if (either instanceof Left && (internalClientError = (InternalClientError)(left = (Left)either).value()) != null) {
                    return true;
                }
                return either instanceof Right;
            }
            {
                this.request$2 = request$2;
            }
        };
    }

    private static boolean shouldRetry$1(RequestResult result) {
        boolean bl = false;
        RequestException requestException = null;
        RequestResult requestResult = result;
        if (requestResult instanceof SuccessfulRequest) {
            return false;
        }
        if (requestResult instanceof FailureResponse) {
            FailureResponse failureResponse = (FailureResponse)requestResult;
            HttpResponse response = failureResponse.response();
            StatusCode statusCode = response.status();
            return statusCode instanceof StatusCodes.ServerError;
        }
        if (requestResult instanceof RequestException) {
            bl = true;
            requestException = (RequestException)requestResult;
            if (requestException.exception() instanceof BufferOverflowException) {
                return false;
            }
        }
        if (bl) {
            return true;
        }
        throw new MatchError((Object)requestResult);
    }

    private static Tuple2 errorStatusMap$1(Throwable error) {
        Throwable throwable = error;
        if (throwable instanceof BufferOverflowException) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)429), (Object)error.getMessage());
        }
        if (throwable instanceof StreamTcpException ? true : throwable instanceof TcpIdleTimeoutException) {
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)504), (Object)error.getMessage());
        }
        throw throwable;
    }

    private static boolean isRetriable$1(int retriesLeft, RequestResult requestResult, long start$1, Config.RetryConfig retryConfig$1, Function1 shouldRetry$2) {
        FiniteDuration elapsed = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(System.nanoTime() - start$1)).nanos();
        return retriesLeft > 0 && elapsed.$less((Object)retryConfig$1.dontRetryAfter()) && BoxesRunTime.unboxToBoolean((Object)shouldRetry$2.apply((Object)requestResult));
    }

    private static RequestResult wrapResponse$1(HttpResponse response) {
        if (response.status().isSuccess()) {
            return new SuccessfulRequest(response);
        }
        return new FailureResponse(response);
    }

    private static PartialFunction wrapException$1() {
        return new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 != null && !(option = NonFatal$.MODULE$.unapply(A1)).isEmpty()) {
                    Throwable exception = (Throwable)option.get();
                    return (B1)new RequestException(exception);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option option;
                Throwable throwable = x1;
                return throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
            }
        };
    }

    private Future handleFailedResponse$1(int retriesLeft, FailureResponse failureResponse, HttpRequest request$1, long start$1, Config.RetryConfig retryConfig$1, Function1 shouldRetry$2, Function1 errorStatusMap$2) {
        HttpResponse response = failureResponse.response();
        return Unmarshal$.MODULE$.apply((Object)response.entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)this.executor(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system())).flatMap((Function1 & Serializable)responseBody -> {
            if (RestClient.isRetriable$1(retriesLeft, failureResponse, start$1, retryConfig$1, shouldRetry$2)) {
                return this.doRetry$1((String)responseBody, retriesLeft - 1, request$1, retryConfig$1, start$1, shouldRetry$2, errorStatusMap$2);
            }
            return this.failRequest(response.status().intValue(), request$1, (String)responseBody);
        }, (ExecutionContext)this.executor());
    }

    private Future handleException$1(int retriesLeft, RequestException requestError, Function1 errorStatusMap$2, HttpRequest request$1, long start$1, Config.RetryConfig retryConfig$1, Function1 shouldRetry$2) {
        Throwable error = requestError.exception();
        if (RestClient.isRetriable$1(retriesLeft, requestError, start$1, retryConfig$1, shouldRetry$2)) {
            return this.doRetry$1(error.getMessage(), retriesLeft - 1, request$1, retryConfig$1, start$1, shouldRetry$2, errorStatusMap$2);
        }
        Tuple2 tuple2 = (Tuple2)errorStatusMap$2.apply((Object)error);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int status = tuple2._1$mcI$sp();
        String cause = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)status), (Object)cause);
        int status2 = tuple22._1$mcI$sp();
        String cause2 = (String)tuple22._2();
        return this.failRequest(status2, request$1, cause2);
    }

    private static FiniteDuration getDelay$1(int retriesLeft, Config.RetryConfig retryConfig$1) {
        int n = retryConfig$1.maxRetries() - retriesLeft;
        return retryConfig$1.initialRetryDelay().$times((long)(1 << n - 1));
    }

    private Future doRetry$1(String cause, int retriesLeft, HttpRequest request$1, Config.RetryConfig retryConfig$1, long start$1, Function1 shouldRetry$2, Function1 errorStatusMap$2) {
        this.logRetry(request$1, retriesLeft, cause);
        FiniteDuration delay = RestClient.getDelay$1(retriesLeft, retryConfig$1);
        return akka.pattern.package$.MODULE$.after(delay, this.system().scheduler(), (Function0 & Serializable)() -> this.loop$1(retriesLeft, request$1, start$1, retryConfig$1, shouldRetry$2, errorStatusMap$2), (ExecutionContext)this.executor());
    }

    private Future loop$1(int retriesLeft, HttpRequest request$1, long start$1, Config.RetryConfig retryConfig$1, Function1 shouldRetry$2, Function1 errorStatusMap$2) {
        Future result = this.sendRequest(request$1).map((Function1 & Serializable)response -> RestClient.wrapResponse$1(response), (ExecutionContext)this.executor()).recover(RestClient.wrapException$1(), (ExecutionContext)this.executor());
        return result.flatMap((Function1 & Serializable)x0$1 -> {
            RequestResult requestResult = x0$1;
            if (requestResult instanceof SuccessfulRequest) {
                SuccessfulRequest successfulRequest = (SuccessfulRequest)requestResult;
                HttpResponse response = successfulRequest.response();
                return Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)response));
            }
            if (requestResult instanceof FailureResponse) {
                FailureResponse failureResponse = (FailureResponse)requestResult;
                return this.handleFailedResponse$1(retriesLeft, failureResponse, request$1, start$1, retryConfig$1, shouldRetry$2, errorStatusMap$2);
            }
            if (requestResult instanceof RequestException) {
                RequestException requestException = (RequestException)requestResult;
                return this.handleException$1(retriesLeft, requestException, errorStatusMap$2, request$1, start$1, retryConfig$1, shouldRetry$2);
            }
            throw new MatchError((Object)requestResult);
        }, (ExecutionContext)this.executor());
    }

    public static void $init$(RestClient $this) {
        $this.com$emarsys$client$RestClient$_setter_$failLevel_$eq(Config$.MODULE$.emsApi().restClient().errorOnFail() ? Logging$.MODULE$.ErrorLevel() : Logging$.MODULE$.WarningLevel());
        $this.com$emarsys$client$RestClient$_setter_$defaultRetryConfig_$eq(Config$.MODULE$.emsApi().retry());
    }

    public static final class FailureResponse
    implements RequestResult,
    Product,
    Serializable {
        private final HttpResponse response;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public HttpResponse response() {
            return this.response;
        }

        public FailureResponse copy(HttpResponse response) {
            return new FailureResponse(response);
        }

        public HttpResponse copy$default$1() {
            return this.response();
        }

        public String productPrefix() {
            return "FailureResponse";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.response();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FailureResponse;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "response";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FailureResponse)) return false;
            boolean bl = true;
            if (!bl) return false;
            FailureResponse failureResponse = (FailureResponse)x$1;
            HttpResponse httpResponse = this.response();
            HttpResponse httpResponse2 = failureResponse.response();
            if (httpResponse != null) {
                if (!httpResponse.equals(httpResponse2)) return false;
                return true;
            }
            if (httpResponse2 == null) return true;
            return false;
        }

        public FailureResponse(HttpResponse response) {
            this.response = response;
            Product.$init$((Product)this);
        }
    }

    public static final class InternalClientError
    implements Product,
    Serializable {
        private final int status;
        private final String cause;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int status() {
            return this.status;
        }

        public String cause() {
            return this.cause;
        }

        public InternalClientError copy(int status, String cause) {
            return new InternalClientError(status, cause);
        }

        public int copy$default$1() {
            return this.status();
        }

        public String copy$default$2() {
            return this.cause();
        }

        public String productPrefix() {
            return "InternalClientError";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this.status());
                }
                case 1: {
                    return this.cause();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof InternalClientError;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "status";
                }
                case 1: {
                    return "cause";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.status());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cause()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof InternalClientError)) return false;
            boolean bl = true;
            if (!bl) return false;
            InternalClientError internalClientError = (InternalClientError)x$1;
            if (this.status() != internalClientError.status()) return false;
            String string = this.cause();
            String string2 = internalClientError.cause();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public InternalClientError(int status, String cause) {
            this.status = status;
            this.cause = cause;
            Product.$init$((Product)this);
        }
    }

    public static final class RequestException
    implements RequestResult,
    Product,
    Serializable {
        private final Throwable exception;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Throwable exception() {
            return this.exception;
        }

        public RequestException copy(Throwable exception) {
            return new RequestException(exception);
        }

        public Throwable copy$default$1() {
            return this.exception();
        }

        public String productPrefix() {
            return "RequestException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.exception();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RequestException;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "exception";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RequestException)) return false;
            boolean bl = true;
            if (!bl) return false;
            RequestException requestException = (RequestException)x$1;
            Throwable throwable = this.exception();
            Throwable throwable2 = requestException.exception();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public RequestException(Throwable exception) {
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface RequestResult {
    }

    public static final class SuccessfulRequest
    implements RequestResult,
    Product,
    Serializable {
        private final HttpResponse response;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public HttpResponse response() {
            return this.response;
        }

        public SuccessfulRequest copy(HttpResponse response) {
            return new SuccessfulRequest(response);
        }

        public HttpResponse copy$default$1() {
            return this.response();
        }

        public String productPrefix() {
            return "SuccessfulRequest";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.response();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SuccessfulRequest;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "response";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SuccessfulRequest)) return false;
            boolean bl = true;
            if (!bl) return false;
            SuccessfulRequest successfulRequest = (SuccessfulRequest)x$1;
            HttpResponse httpResponse = this.response();
            HttpResponse httpResponse2 = successfulRequest.response();
            if (httpResponse != null) {
                if (!httpResponse.equals(httpResponse2)) return false;
                return true;
            }
            if (httpResponse2 == null) return true;
            return false;
        }

        public SuccessfulRequest(HttpResponse response) {
            this.response = response;
            Product.$init$((Product)this);
        }
    }
}

