/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.escher;

import com.emarsys.escher.AuthElements;
import com.emarsys.escher.Config;
import com.emarsys.escher.EscherException;
import com.emarsys.escher.EscherRequest;
import com.emarsys.escher.Logger;
import com.emarsys.escher.util.DateTime;
import com.emarsys.escher.util.Hmac;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;

class Helper {
    private static final char NEW_LINE = '\n';
    private static final String CHARSET = "UTF-8";
    private final Config config;

    public Helper(Config config) {
        this.config = config;
    }

    public String canonicalize(EscherRequest request, List<String> signedHeaders) throws EscherException {
        return request.getHttpMethod() + '\n' + this.canonicalizePath(request) + '\n' + this.canonicalizeQueryParameters(request) + '\n' + this.canonicalizeHeaders(request.getRequestHeaders(), signedHeaders) + '\n' + '\n' + this.signedHeaders(signedHeaders) + '\n' + Hmac.hash(request.getBody());
    }

    private String canonicalizePath(EscherRequest request) throws EscherException {
        try {
            String path = request.getURI().toURL().getPath();
            return path.equals("") ? "/" : path;
        }
        catch (MalformedURLException e) {
            throw new EscherException(e);
        }
    }

    private String canonicalizeQueryParameters(EscherRequest request) {
        return URLEncodedUtils.parse((URI)request.getURI(), (String)CHARSET).stream().filter(entry -> !entry.getName().equals("X-" + this.config.getVendorKey() + "-Signature")).map(this::queryParameterToString).sorted().reduce(this.byJoiningWith('&')).orElse("");
    }

    private String queryParameterToString(NameValuePair entry) {
        try {
            return entry.getName() + "=" + URLEncoder.encode(entry.getValue(), CHARSET);
        }
        catch (UnsupportedEncodingException shouldNeverHappen) {
            throw new RuntimeException(shouldNeverHappen);
        }
    }

    private String canonicalizeHeaders(List<EscherRequest.Header> headers, List<String> signedHeaders) {
        return headers.stream().filter(this.shouldHeaderBeSigned(signedHeaders)).map(header -> header.getFieldName().toLowerCase() + ":" + header.getFieldValue().trim()).sorted().reduce(this.byJoiningWith('\n')).orElse("");
    }

    private Predicate<EscherRequest.Header> shouldHeaderBeSigned(List<String> signedHeaders) {
        return header -> signedHeaders.stream().anyMatch(signedHeader -> signedHeader.equalsIgnoreCase(header.getFieldName()));
    }

    private String signedHeaders(List<String> headers) {
        return headers.stream().map(String::toLowerCase).sorted().reduce(this.byJoiningWith(';')).orElse("");
    }

    private BinaryOperator<String> byJoiningWith(char separator) {
        return (s1, s2) -> s1 + separator + s2;
    }

    public String calculateStringToSign(Date date, String credentialScope, String canonicalizedRequest) throws EscherException {
        return this.config.getFullAlgorithm() + '\n' + DateTime.toLongString(date) + '\n' + DateTime.toShortString(date) + "/" + credentialScope + '\n' + Hmac.hash(canonicalizedRequest);
    }

    public byte[] calculateSigningKey(String secret, Date date, String credentialScope) throws EscherException {
        byte[] key = Hmac.sign(this.config.getHashAlgo(), this.config.getAlgoPrefix() + secret, DateTime.toShortString(date));
        for (String credentialPart : credentialScope.split("/")) {
            key = Hmac.sign(this.config.getHashAlgo(), key, credentialPart);
        }
        return key;
    }

    public String calculateAuthHeader(String accessKeyId, Date date, String credentialScope, List<String> signedHeaders, String signature) {
        return this.config.getFullAlgorithm() + " Credential=" + this.credentials(accessKeyId, date, credentialScope) + ", SignedHeaders=" + ((String)signedHeaders.stream().reduce((s1, s2) -> s1 + ";" + s2).get()).toLowerCase() + ", Signature=" + signature;
    }

    public String calculateSignature(byte[] signingKey, String stringToSign) throws EscherException {
        return DatatypeConverter.printHexBinary((byte[])Hmac.sign(this.config.getHashAlgo(), signingKey, stringToSign)).toLowerCase();
    }

    private String credentials(String accessKeyId, Date date, String credentialScope) {
        return accessKeyId + "/" + DateTime.toShortString(date) + "/" + credentialScope;
    }

    public Map<String, String> calculateSigningParams(String accessKeyId, Date date, String credentialScope, int expires) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("SignedHeaders", "host");
        params.put("Expires", Integer.toString(expires));
        params.put("Algorithm", this.config.getFullAlgorithm());
        params.put("Credentials", this.credentials(accessKeyId, date, credentialScope));
        params.put("Date", DateTime.toLongString(date));
        return params;
    }

    public void addMandatoryHeaders(EscherRequest request, Date date) {
        boolean requestHasHostHeader;
        boolean requestHasDateHeader = request.getRequestHeaders().stream().anyMatch(header -> header.getFieldName().equals(this.config.getDateHeaderName()));
        if (!requestHasDateHeader) {
            String formattedDate = DateTime.toLongString(date);
            request.addHeader(this.config.getDateHeaderName(), formattedDate);
            Logger.log("Header added - " + this.config.getDateHeaderName() + ": " + formattedDate);
        }
        if (!(requestHasHostHeader = request.getRequestHeaders().stream().anyMatch(header -> header.getFieldName().equalsIgnoreCase("host")))) {
            String host = this.calculateHost(request.getURI());
            request.addHeader("host", host);
            Logger.log("Header added - host: " + host);
        }
    }

    private String calculateHost(URI uri) {
        int defaultPort;
        String host = uri.getHost();
        int port = uri.getPort();
        int n = defaultPort = "https".equals(uri.getScheme()) ? 443 : 80;
        if (port != -1 && port != defaultPort) {
            host = host + ":" + port;
        }
        return host;
    }

    public void addMandatorySignedHeaders(List<String> signedHeaders) {
        boolean hasHostHeader;
        boolean asDateHeader = signedHeaders.stream().anyMatch(header -> header.equals(this.config.getDateHeaderName()));
        if (!asDateHeader) {
            signedHeaders.add(this.config.getDateHeaderName());
        }
        if (!(hasHostHeader = signedHeaders.stream().anyMatch(header -> header.equalsIgnoreCase("host")))) {
            signedHeaders.add("host");
        }
        Logger.log("Headers to sign: " + signedHeaders.stream().reduce((s1, s2) -> s1 + ", " + s2).orElse(""));
    }

    public void addAuthHeader(EscherRequest request, String fieldValue) {
        request.getRequestHeaders().removeIf(header -> header.getFieldName().equals(this.config.getAuthHeaderName()));
        request.addHeader(this.config.getAuthHeaderName(), fieldValue);
        Logger.log("Auth header added - " + this.config.getAuthHeaderName() + ": " + fieldValue);
    }

    public String parseHostHeader(EscherRequest request) throws EscherException {
        try {
            return this.findHeader(request, "host").getFieldValue();
        }
        catch (NoSuchElementException e) {
            throw new EscherException("Missing header: host");
        }
    }

    public AuthElements parseAuthElements(EscherRequest request) throws EscherException {
        if (this.hasAuthHeader(request)) {
            return AuthElements.parseHeader(this.findHeader(request, this.config.getAuthHeaderName()).getFieldValue(), this.config);
        }
        if (this.hasSignatureQueryParam(request.getURI())) {
            return AuthElements.parseQuery(request.getURI(), this.config);
        }
        throw new EscherException("Request has not been signed.");
    }

    public Date parseDate(EscherRequest request) throws EscherException {
        String date;
        if (this.hasAuthHeader(request)) {
            try {
                date = this.findHeader(request, this.config.getDateHeaderName()).getFieldValue();
            }
            catch (NoSuchElementException e) {
                throw new EscherException("Missing header: " + this.config.getDateHeaderName());
            }
        }
        String dateParamName = "X-" + this.config.getVendorKey() + "-Date";
        try {
            date = new URIBuilder(request.getURI()).getQueryParams().stream().filter(nameValuePair -> nameValuePair.getName().equals(dateParamName)).map(NameValuePair::getValue).findFirst().get();
        }
        catch (NoSuchElementException e) {
            throw new EscherException("Missing authorization parameter: " + dateParamName);
        }
        return DateTime.parseLongString(date);
    }

    private boolean hasAuthHeader(EscherRequest request) {
        try {
            this.findHeader(request, this.config.getAuthHeaderName());
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private boolean hasSignatureQueryParam(URI uri) {
        String paramName = "X-" + this.config.getVendorKey() + "-Signature";
        URIBuilder uriBuilder = new URIBuilder(uri);
        return uriBuilder.getQueryParams().stream().anyMatch(nameValuePair -> nameValuePair.getName().equals(paramName));
    }

    private EscherRequest.Header findHeader(EscherRequest request, String headerName) throws NoSuchElementException {
        return request.getRequestHeaders().stream().filter(header -> header.getFieldName().replace('_', '-').equalsIgnoreCase(headerName)).findFirst().get();
    }
}

