/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.escher.demo;

import com.emarsys.escher.Escher;
import com.emarsys.escher.EscherException;
import com.emarsys.escher.demo.MyEscherRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ClientTest {
    public static void main(String ... args) {
        try {
            String url = "http://localhost:8888/";
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(url);
            request.addHeader("host", "localhost");
            request.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            request = ClientTest.signRequest((HttpRequestBase)request);
            HttpResponse response = client.execute((HttpUriRequest)request);
            System.out.println("Response Code : " + response.getStatusLine().getStatusCode());
            System.out.println(ClientTest.fetchResponse(response));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static HttpRequestBase signRequest(HttpRequestBase request) throws EscherException {
        MyEscherRequest escherRequest = new MyEscherRequest(request, "");
        Escher escher = new Escher("eu/suite/ems_request").setAuthHeaderName("X-Ems-Auth").setDateHeaderName("X-Ems-Date").setAlgoPrefix("EMS");
        escher.signRequest(escherRequest, "ACCESS_KEY_ID", "SECRET", Arrays.asList("Content-Type", "X-Ems-Date", "host"));
        return escherRequest.getHttpRequest();
    }

    private static String fetchResponse(HttpResponse response) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        String result = "";
        while ((line = rd.readLine()) != null) {
            result = result + line + "\n";
        }
        return result;
    }
}

