/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.escher.demo;

import com.emarsys.escher.EscherRequest;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.client.methods.HttpRequestBase;

class MyEscherRequest
implements EscherRequest {
    private HttpRequestBase httpRequest;
    private String body;

    public MyEscherRequest(HttpRequestBase httpRequest, String body) {
        this.httpRequest = httpRequest;
        this.body = body;
    }

    @Override
    public String getHttpMethod() {
        return this.httpRequest.getMethod();
    }

    @Override
    public URI getURI() {
        return this.httpRequest.getURI();
    }

    @Override
    public List<EscherRequest.Header> getRequestHeaders() {
        return Arrays.asList(this.httpRequest.getAllHeaders()).stream().map(header -> new EscherRequest.Header(header.getName(), header.getValue())).collect(Collectors.toList());
    }

    @Override
    public void addHeader(String fieldName, String fieldValue) {
        this.httpRequest.addHeader(fieldName, fieldValue);
    }

    @Override
    public String getBody() {
        return this.body;
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }
}

