/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.escher.demo;

import com.emarsys.escher.EscherRequest;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;

class MyServerEscherRequest
implements EscherRequest {
    private HttpExchange exchange;

    public MyServerEscherRequest(HttpExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public String getHttpMethod() {
        return this.exchange.getRequestMethod();
    }

    @Override
    public URI getURI() {
        try {
            return new URIBuilder(this.exchange.getRequestURI()).setScheme("http").build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<EscherRequest.Header> getRequestHeaders() {
        ArrayList<EscherRequest.Header> headers = new ArrayList<EscherRequest.Header>();
        this.exchange.getRequestHeaders().forEach((fieldName, fieldValues) -> fieldValues.forEach(fieldValue -> headers.add(new EscherRequest.Header((String)fieldName, (String)fieldValue))));
        return headers;
    }

    @Override
    public void addHeader(String fieldName, String fieldValue) {
        throw new RuntimeException("Should not be called");
    }

    @Override
    public String getBody() {
        try {
            String body = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(this.exchange.getRequestBody()));
            String line = br.readLine();
            while (line != null) {
                body = body + line + "\n";
                line = br.readLine();
            }
            br.close();
            return body;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

