/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.escher.demo;

import com.emarsys.escher.Escher;
import com.emarsys.escher.EscherException;
import com.emarsys.escher.demo.MyServerEscherRequest;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class ServerTest {
    public static void main(String ... args) throws Exception {
        HttpServer server = HttpServer.create(new InetSocketAddress(8888), 0);
        server.createContext("/", exchange -> {
            String response;
            try {
                ServerTest.authenticate(exchange);
                response = "Everything is OK\n";
            }
            catch (EscherException e) {
                response = e.getMessage();
            }
            exchange.sendResponseHeaders(200, response.length());
            OutputStream os = exchange.getResponseBody();
            os.write(response.getBytes());
            os.close();
        });
        server.setExecutor(null);
        server.start();
        System.out.println("started");
    }

    private static void authenticate(HttpExchange exchange) throws EscherException {
        MyServerEscherRequest request = new MyServerEscherRequest(exchange);
        Escher escher = new Escher("eu/suite/ems_request").setAuthHeaderName("X-Ems-Auth").setDateHeaderName("X-Ems-Date").setAlgoPrefix("EMS");
        HashMap<String, String> keyDb = new HashMap<String, String>();
        keyDb.put("ACCESS_KEY_ID", "SECRET");
        escher.authenticate(request, keyDb, new InetSocketAddress("localhost", 8888));
    }
}

