/*
 * Decompiled with CFR 0.152.
 */
package com.emarsys.escher.util;

import com.emarsys.escher.EscherException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTime {
    public static final TimeZone TIMEZONE = TimeZone.getTimeZone("UTC");
    public static final String LONG_DATE_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static final String SHORT_DATE_FORMAT = "yyyyMMdd";

    public static String toLongString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(LONG_DATE_FORMAT);
        dateFormat.setTimeZone(TIMEZONE);
        return dateFormat.format(date);
    }

    public static String toShortString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(SHORT_DATE_FORMAT);
        dateFormat.setTimeZone(TIMEZONE);
        return dateFormat.format(date);
    }

    public static Date parseLongString(String text) throws EscherException {
        return DateTime.parse(text, LONG_DATE_FORMAT);
    }

    public static Date parseShortString(String text) throws EscherException {
        return DateTime.parse(text, SHORT_DATE_FORMAT);
    }

    private static Date parse(String text, String format) throws EscherException {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            dateFormat.setTimeZone(TIMEZONE);
            return dateFormat.parse(text);
        }
        catch (ParseException e) {
            throw new EscherException("Invalid date format");
        }
    }

    public static boolean sameDay(Date date1, Date date2) {
        Calendar cal1 = DateTime.toCalendar(date1);
        Calendar cal2 = DateTime.toCalendar(date2);
        return cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static Date subtractSeconds(Date date, int seconds) {
        return DateTime.addSeconds(date, -seconds);
    }

    public static Date addSeconds(Date date, int seconds) {
        Calendar calendar = DateTime.toCalendar(date);
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance(TIMEZONE);
        calendar.setTime(date);
        return calendar;
    }
}

