/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.alidns.model.v20150109.AddDomainRecordRequest;
import com.aliyuncs.alidns.model.v20150109.AddDomainRecordResponse;
import com.aliyuncs.alidns.model.v20150109.DeleteDomainRecordRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordInfoRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordInfoResponse;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainsRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainsResponse;
import com.aliyuncs.alidns.model.v20150109.SetDomainRecordStatusRequest;
import com.aliyuncs.alidns.model.v20150109.UpdateDomainRecordRequest;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.eworkcloud.dns.DnsClientConfiguration;

public abstract class DnsClientUtils {
    public static IAcsClient getAcsClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)DnsClientConfiguration.getRegionId(), (String)DnsClientConfiguration.getAccessKeyId(), (String)DnsClientConfiguration.getAccessKeySecret());
        return new DefaultAcsClient((IClientProfile)profile);
    }

    public static DescribeDomainRecordInfoResponse getDomain(String recordId) {
        IAcsClient acsClient = null;
        try {
            acsClient = DnsClientUtils.getAcsClient();
            DescribeDomainRecordInfoRequest request = new DescribeDomainRecordInfoRequest();
            request.setRecordId(recordId);
            DescribeDomainRecordInfoResponse describeDomainRecordInfoResponse = (DescribeDomainRecordInfoResponse)acsClient.getAcsResponse((AcsRequest)request);
            return describeDomainRecordInfoResponse;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != acsClient) {
                acsClient.shutdown();
            }
        }
    }

    public static String addDomain(AddDomainRecordRequest request) {
        IAcsClient acsClient = null;
        try {
            acsClient = DnsClientUtils.getAcsClient();
            if (null == request.getType()) {
                request.setType("A");
            }
            if (null == request.getTTL()) {
                request.setTTL(Long.valueOf(600L));
            }
            if (null == request.getLine()) {
                request.setLine("default");
            }
            String string = ((AddDomainRecordResponse)acsClient.getAcsResponse((AcsRequest)request)).getRecordId();
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != acsClient) {
                acsClient.shutdown();
            }
        }
    }

    public static void updateDomain(UpdateDomainRecordRequest request) {
        IAcsClient acsClient = null;
        try {
            acsClient = DnsClientUtils.getAcsClient();
            acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != acsClient) {
                acsClient.shutdown();
            }
        }
    }

    public static void deleteDomain(String recordId) {
        IAcsClient acsClient = null;
        try {
            acsClient = DnsClientUtils.getAcsClient();
            DeleteDomainRecordRequest request = new DeleteDomainRecordRequest();
            request.setRecordId(recordId);
            acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != acsClient) {
                acsClient.shutdown();
            }
        }
    }

    public static void setStatus(String recordId, String status) {
        IAcsClient acsClient = null;
        try {
            acsClient = DnsClientUtils.getAcsClient();
            SetDomainRecordStatusRequest request = new SetDomainRecordStatusRequest();
            request.setRecordId(recordId);
            request.setStatus(status);
            acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != acsClient) {
                acsClient.shutdown();
            }
        }
    }

    public static DescribeDomainsResponse queryDomains(DescribeDomainsRequest request) {
        IAcsClient acsClient = null;
        try {
            acsClient = DnsClientUtils.getAcsClient();
            DescribeDomainsResponse describeDomainsResponse = (DescribeDomainsResponse)acsClient.getAcsResponse((AcsRequest)request);
            return describeDomainsResponse;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (null != acsClient) {
                acsClient.shutdown();
            }
        }
    }
}

