package com.eworkcloud.dns;

import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class DnsClientConfiguration implements EnvironmentAware {

    private static Environment environment;
    private static String regionId;
    private static String accessKeyId;
    private static String accessKeySecret;

    @Override
    public void setEnvironment(Environment environment) {
        DnsClientConfiguration.environment = environment;
    }

    /**
     * 获取区域ID
     *
     * @return 区域ID
     */
    public static String getRegionId() {
        if (StringUtils.hasText(regionId)) {
            return regionId;
        }
        return environment.getProperty("dns.regionId");
    }

    /**
     * 设置区域ID
     *
     * @param regionId 区域ID
     */
    public static void setRegionId(String regionId) {
        DnsClientConfiguration.regionId = regionId;
    }

    /**
     * 获取访问钥匙
     *
     * @return 访问钥匙
     */
    public static String getAccessKeyId() {
        if (StringUtils.hasText(accessKeyId)) {
            return accessKeyId;
        }
        return environment.getProperty("dns.accessKeyId");
    }

    /**
     * 设置访问钥匙
     *
     * @param accessKeyId 访问钥匙
     */
    public static void setAccessKeyId(String accessKeyId) {
        DnsClientConfiguration.accessKeyId = accessKeyId;
    }

    /**
     * 获取安全密钥
     *
     * @return 安全密钥
     */
    public static String getAccessKeySecret() {
        if (StringUtils.hasText(accessKeySecret)) {
            return accessKeySecret;
        }
        return environment.getProperty("dns.accessKeySecret");
    }

    /**
     * 设置安全密钥
     *
     * @param accessKeySecret 安全密钥
     */
    public static void setAccessKeySecret(String accessKeySecret) {
        DnsClientConfiguration.accessKeySecret = accessKeySecret;
    }
}
