/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.alidns.model.v20150109.AddDomainRecordRequest;
import com.aliyuncs.alidns.model.v20150109.AddDomainRecordResponse;
import com.aliyuncs.alidns.model.v20150109.DeleteDomainRecordRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordInfoRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainRecordInfoResponse;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainsRequest;
import com.aliyuncs.alidns.model.v20150109.DescribeDomainsResponse;
import com.aliyuncs.alidns.model.v20150109.SetDomainRecordStatusRequest;
import com.aliyuncs.alidns.model.v20150109.UpdateDomainRecordRequest;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.eworkcloud.dns.DnsConfiguration;

public abstract class DnsClientUtils {
    public static IAcsClient getAcsClient() {
        return DnsClientUtils.getAcsClient(DnsConfiguration.getRegionId(), DnsConfiguration.getAccessKeyId(), DnsConfiguration.getAccessKeySecret());
    }

    public static IAcsClient getAcsClient(String regionId, String accessKeyId, String accessKeySecret) {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        return new DefaultAcsClient((IClientProfile)profile);
    }

    public static DescribeDomainRecordInfoResponse getDomain(IAcsClient acsClient, String recordId) {
        try {
            DescribeDomainRecordInfoRequest request = new DescribeDomainRecordInfoRequest();
            request.setRecordId(recordId);
            return (DescribeDomainRecordInfoResponse)acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String addDomain(IAcsClient acsClient, AddDomainRecordRequest request) {
        try {
            if (null == request.getType()) {
                request.setType("A");
            }
            if (null == request.getTTL()) {
                request.setTTL(Long.valueOf(600L));
            }
            if (null == request.getLine()) {
                request.setLine("default");
            }
            return ((AddDomainRecordResponse)acsClient.getAcsResponse((AcsRequest)request)).getRecordId();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void updateDomain(IAcsClient acsClient, UpdateDomainRecordRequest request) {
        try {
            acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void deleteDomain(IAcsClient acsClient, String recordId) {
        try {
            DeleteDomainRecordRequest request = new DeleteDomainRecordRequest();
            request.setRecordId(recordId);
            acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setStatus(IAcsClient acsClient, String recordId, String status) {
        try {
            SetDomainRecordStatusRequest request = new SetDomainRecordStatusRequest();
            request.setRecordId(recordId);
            request.setStatus(status);
            acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static DescribeDomainsResponse queryDomains(IAcsClient acsClient, DescribeDomainsRequest request) {
        try {
            return (DescribeDomainsResponse)acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

