/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.mail.model;

import com.eworkcloud.mail.enums.ContentType;
import com.eworkcloud.mail.model.MailAddress;
import com.eworkcloud.mail.model.MailFilePart;
import java.util.ArrayList;
import java.util.List;

public class MailMessage {
    private List<MailAddress> to;
    private List<MailAddress> cc;
    private List<MailAddress> bcc;
    private List<MailAddress> replyTo;
    private String inReplyTo;
    private String subject;
    private String content;
    private ContentType contentType;
    private List<MailFilePart> inline;
    private List<MailFilePart> attachment;

    public MailMessage() {
        this.to = new ArrayList<MailAddress>();
        this.cc = new ArrayList<MailAddress>();
        this.bcc = new ArrayList<MailAddress>();
        this.replyTo = new ArrayList<MailAddress>();
        this.contentType = ContentType.text;
        this.inline = new ArrayList<MailFilePart>();
        this.attachment = new ArrayList<MailFilePart>();
    }

    public MailMessage addTo(MailAddress address) {
        this.to.add(address);
        return this;
    }

    public MailMessage addCc(MailAddress address) {
        this.cc.add(address);
        return this;
    }

    public MailMessage addBcc(MailAddress address) {
        this.bcc.add(address);
        return this;
    }

    public MailMessage addReplyTo(MailAddress address) {
        this.replyTo.add(address);
        return this;
    }

    public MailMessage addInline(MailFilePart filePart) {
        this.inline.add(filePart);
        return this;
    }

    public MailMessage addAttachment(MailFilePart filePart) {
        this.attachment.add(filePart);
        return this;
    }

    private static List<MailAddress> $default$to() {
        return new ArrayList<MailAddress>();
    }

    private static List<MailAddress> $default$cc() {
        return new ArrayList<MailAddress>();
    }

    private static List<MailAddress> $default$bcc() {
        return new ArrayList<MailAddress>();
    }

    private static List<MailAddress> $default$replyTo() {
        return new ArrayList<MailAddress>();
    }

    private static ContentType $default$contentType() {
        return ContentType.text;
    }

    private static List<MailFilePart> $default$inline() {
        return new ArrayList<MailFilePart>();
    }

    private static List<MailFilePart> $default$attachment() {
        return new ArrayList<MailFilePart>();
    }

    public static MailMessageBuilder builder() {
        return new MailMessageBuilder();
    }

    public List<MailAddress> getTo() {
        return this.to;
    }

    public List<MailAddress> getCc() {
        return this.cc;
    }

    public List<MailAddress> getBcc() {
        return this.bcc;
    }

    public List<MailAddress> getReplyTo() {
        return this.replyTo;
    }

    public String getInReplyTo() {
        return this.inReplyTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public List<MailFilePart> getInline() {
        return this.inline;
    }

    public List<MailFilePart> getAttachment() {
        return this.attachment;
    }

    public void setTo(List<MailAddress> to) {
        this.to = to;
    }

    public void setCc(List<MailAddress> cc) {
        this.cc = cc;
    }

    public void setBcc(List<MailAddress> bcc) {
        this.bcc = bcc;
    }

    public void setReplyTo(List<MailAddress> replyTo) {
        this.replyTo = replyTo;
    }

    public void setInReplyTo(String inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setInline(List<MailFilePart> inline) {
        this.inline = inline;
    }

    public void setAttachment(List<MailFilePart> attachment) {
        this.attachment = attachment;
    }

    public MailMessage(List<MailAddress> to, List<MailAddress> cc, List<MailAddress> bcc, List<MailAddress> replyTo, String inReplyTo, String subject, String content, ContentType contentType, List<MailFilePart> inline, List<MailFilePart> attachment) {
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.replyTo = replyTo;
        this.inReplyTo = inReplyTo;
        this.subject = subject;
        this.content = content;
        this.contentType = contentType;
        this.inline = inline;
        this.attachment = attachment;
    }

    public static class MailMessageBuilder {
        private boolean to$set;
        private List<MailAddress> to;
        private boolean cc$set;
        private List<MailAddress> cc;
        private boolean bcc$set;
        private List<MailAddress> bcc;
        private boolean replyTo$set;
        private List<MailAddress> replyTo;
        private String inReplyTo;
        private String subject;
        private String content;
        private boolean contentType$set;
        private ContentType contentType;
        private boolean inline$set;
        private List<MailFilePart> inline;
        private boolean attachment$set;
        private List<MailFilePart> attachment;

        MailMessageBuilder() {
        }

        public MailMessageBuilder to(List<MailAddress> to) {
            this.to = to;
            this.to$set = true;
            return this;
        }

        public MailMessageBuilder cc(List<MailAddress> cc) {
            this.cc = cc;
            this.cc$set = true;
            return this;
        }

        public MailMessageBuilder bcc(List<MailAddress> bcc) {
            this.bcc = bcc;
            this.bcc$set = true;
            return this;
        }

        public MailMessageBuilder replyTo(List<MailAddress> replyTo) {
            this.replyTo = replyTo;
            this.replyTo$set = true;
            return this;
        }

        public MailMessageBuilder inReplyTo(String inReplyTo) {
            this.inReplyTo = inReplyTo;
            return this;
        }

        public MailMessageBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public MailMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public MailMessageBuilder contentType(ContentType contentType) {
            this.contentType = contentType;
            this.contentType$set = true;
            return this;
        }

        public MailMessageBuilder inline(List<MailFilePart> inline) {
            this.inline = inline;
            this.inline$set = true;
            return this;
        }

        public MailMessageBuilder attachment(List<MailFilePart> attachment) {
            this.attachment = attachment;
            this.attachment$set = true;
            return this;
        }

        public MailMessage build() {
            List to = this.to;
            if (!this.to$set) {
                to = MailMessage.$default$to();
            }
            List cc = this.cc;
            if (!this.cc$set) {
                cc = MailMessage.$default$cc();
            }
            List bcc = this.bcc;
            if (!this.bcc$set) {
                bcc = MailMessage.$default$bcc();
            }
            List replyTo = this.replyTo;
            if (!this.replyTo$set) {
                replyTo = MailMessage.$default$replyTo();
            }
            ContentType contentType = this.contentType;
            if (!this.contentType$set) {
                contentType = MailMessage.$default$contentType();
            }
            List inline = this.inline;
            if (!this.inline$set) {
                inline = MailMessage.$default$inline();
            }
            List attachment = this.attachment;
            if (!this.attachment$set) {
                attachment = MailMessage.$default$attachment();
            }
            return new MailMessage(to, cc, bcc, replyTo, this.inReplyTo, this.subject, this.content, contentType, inline, attachment);
        }

        public String toString() {
            return "MailMessage.MailMessageBuilder(to=" + this.to + ", cc=" + this.cc + ", bcc=" + this.bcc + ", replyTo=" + this.replyTo + ", inReplyTo=" + this.inReplyTo + ", subject=" + this.subject + ", content=" + this.content + ", contentType=" + (Object)((Object)this.contentType) + ", inline=" + this.inline + ", attachment=" + this.attachment + ")";
        }
    }
}

