/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.web.util;

import com.eworkcloud.mail.MailConfiguration;
import com.eworkcloud.mail.enums.ContentType;
import com.eworkcloud.mail.enums.MultipartType;
import com.eworkcloud.mail.model.MailAccount;
import com.eworkcloud.mail.model.MailAddress;
import com.eworkcloud.mail.model.MailCallback;
import com.eworkcloud.mail.model.MailFilePart;
import com.eworkcloud.mail.model.MailMessage;
import com.eworkcloud.mail.model.MailProtocol;
import com.eworkcloud.mail.model.MailReceive;
import com.eworkcloud.mail.model.MailTextPart;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPMessage;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.InputStream;
import java.security.Security;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class MailClientUtils {
    private static final Logger log = LoggerFactory.getLogger(MailClientUtils.class);
    private static final String ENCODING = "UTF-8";
    public static final String INBOX = "INBOX";

    public static Session getSession(MailProtocol protocol) {
        Properties props = new Properties();
        if (StringUtils.hasText((String)protocol.getSmtpHost())) {
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.host", protocol.getSmtpHost());
            props.put("mail.smtp.port", (Object)protocol.getSmtpPort());
            props.put("mail.smtp.connectiontimeout", (Object)protocol.getSmtpTimeout());
            props.put("mail.smtp.timeout", (Object)protocol.getSmtpTimeout());
            if (protocol.getSmtpPort() == 465) {
                Security.addProvider((java.security.Provider)new Provider());
                String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
                props.put("mail.smtp.socketFactory.port", "465");
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.smtp.socketFactory.fallback", "false");
            }
        }
        if (StringUtils.hasText((String)protocol.getImapHost())) {
            props.put("mail.imap.host", protocol.getImapHost());
            props.put("mail.imap.port", (Object)protocol.getImapPort());
            props.put("mail.imap.connectiontimeout", (Object)protocol.getImapTimeout());
            props.put("mail.imap.timeout", (Object)protocol.getImapTimeout());
            if (protocol.getImapPort() == 993) {
                props.put("mail.imap.ssl.enable", (Object)true);
            }
        }
        return Session.getInstance((Properties)props);
    }

    public static Session getSession() {
        MailProtocol session = new MailProtocol();
        session.setSmtpHost(MailConfiguration.getSmtpHost());
        session.setSmtpPort(MailConfiguration.getSmtpPort());
        session.setSmtpTimeout(MailConfiguration.getSmtpTimeout());
        session.setImapHost(MailConfiguration.getImapHost());
        session.setImapPort(MailConfiguration.getImapPort());
        session.setImapTimeout(MailConfiguration.getImapTimeout());
        return MailClientUtils.getSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testConnect(Session session, String username, String password) {
        Store store = null;
        try {
            store = session.getStore("imap");
            store.connect(username, password);
            boolean bl = store.isConnected();
            return bl;
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != store && store.isConnected()) {
                    store.close();
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }
    }

    public static boolean testConnect(String username, String password) {
        return MailClientUtils.testConnect(MailClientUtils.getSession(), username, password);
    }

    private static void attachText(MailReceive mailReceive, Part part) throws Exception {
        if (part.isMimeType("text/plain")) {
            MailTextPart mailTextPart = new MailTextPart();
            mailTextPart.setContentType("text/plain");
            mailTextPart.setContent((String)part.getContent());
            mailReceive.addContent(mailTextPart);
        } else if (part.isMimeType("text/html")) {
            MailTextPart mailTextPart = new MailTextPart();
            mailTextPart.setContentType("text/html");
            mailTextPart.setContent((String)part.getContent());
            mailReceive.addContent(mailTextPart);
        }
    }

    private static void attachFile(MailReceive mailReceive, Part part) throws Exception {
        String fileName = part.getFileName();
        if (StringUtils.hasText((String)fileName)) {
            String disposition;
            String contentType;
            fileName = MimeUtility.decodeText((String)fileName);
            String contentId = "";
            if (part instanceof MimeBodyPart) {
                contentId = ((MimeBodyPart)part).getContentID();
            }
            if (StringUtils.hasText((String)(contentType = part.getContentType()))) {
                contentType = contentType.split(";")[0];
            }
            if (StringUtils.hasText((String)(disposition = part.getDisposition()))) {
                disposition = disposition.toLowerCase();
            }
            MailFilePart mailFilePart = new MailFilePart();
            mailFilePart.setFileName(fileName);
            mailFilePart.setContentId(contentId);
            mailFilePart.setContentType(contentType);
            mailFilePart.setDisposition(disposition);
            DataSource dataSource = part.getDataHandler().getDataSource();
            mailFilePart.setDataSource(dataSource);
            InputStream inputStream = dataSource.getInputStream();
            mailFilePart.setContent(IOUtils.toByteArray((InputStream)inputStream));
            if ("inline".equalsIgnoreCase(part.getDisposition())) {
                mailReceive.addInline(mailFilePart);
            } else {
                mailReceive.addAttachment(mailFilePart);
            }
        }
    }

    private static void attachContent(MailReceive mailReceive, Part part) throws Exception {
        if (part.isMimeType("text/*")) {
            MailClientUtils.attachText(mailReceive, part);
        } else if ("inline".equalsIgnoreCase(part.getDisposition())) {
            MailClientUtils.attachFile(mailReceive, part);
        } else if ("attachment".equalsIgnoreCase(part.getDisposition())) {
            MailClientUtils.attachFile(mailReceive, part);
        } else if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int count = multipart.getCount();
            for (int m = 0; m < count; ++m) {
                MailClientUtils.attachContent(mailReceive, (Part)multipart.getBodyPart(m));
            }
        } else {
            log.warn("Unknown mime type: {}", (Object)part.getContentType());
        }
    }

    private static void attachAddress(MailReceive mailReceive, Message message) throws Exception {
        Object[] replyAddresses;
        Object[] ccAddresses;
        Object[] fromAddresses = message.getHeader("Resent-From");
        if (!ObjectUtils.isEmpty((Object[])fromAddresses)) {
            MailAddress mailAddress = new MailAddress();
            mailAddress.setAddress((String)fromAddresses[0]);
            mailReceive.setFrom(mailAddress);
        } else if (!ObjectUtils.isEmpty((Object[])message.getFrom())) {
            InternetAddress address = (InternetAddress)message.getFrom()[0];
            Object[] mailAddress = new MailAddress();
            mailAddress.setAddress(address.getAddress());
            mailAddress.setPersonal(address.getPersonal());
            mailReceive.setFrom((MailAddress)mailAddress);
        } else {
            throw new RuntimeException("Failure to obtain the from.");
        }
        Object[] toAddresses = message.getRecipients(Message.RecipientType.TO);
        if (!ObjectUtils.isEmpty((Object[])toAddresses)) {
            for (Object toAddress : toAddresses) {
                InternetAddress address = (InternetAddress)toAddress;
                MailAddress mailAddress = new MailAddress();
                mailAddress.setAddress(address.getAddress());
                mailAddress.setPersonal(address.getPersonal());
                mailReceive.addTo(mailAddress);
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(ccAddresses = message.getRecipients(Message.RecipientType.CC)))) {
            for (Object ccAddress : ccAddresses) {
                InternetAddress address = (InternetAddress)ccAddress;
                MailAddress mailAddress = new MailAddress();
                mailAddress.setAddress(address.getAddress());
                mailAddress.setPersonal(address.getPersonal());
                mailReceive.addCc(mailAddress);
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(replyAddresses = message.getReplyTo()))) {
            for (Object replyAddress : replyAddresses) {
                InternetAddress address = (InternetAddress)replyAddress;
                MailAddress mailAddress = new MailAddress();
                mailAddress.setAddress(address.getAddress());
                mailAddress.setPersonal(address.getPersonal());
                mailReceive.addReplyTo(mailAddress);
            }
        }
    }

    private static void attachMessage(MailReceive mailReceive, Message message) {
        try {
            mailReceive.setMessageId(((IMAPMessage)message).getMessageID());
            mailReceive.setInReplyTo(((IMAPMessage)message).getInReplyTo());
            mailReceive.setSentDate(message.getSentDate());
            mailReceive.setReceivedDate(message.getReceivedDate());
            mailReceive.setSubject(message.getSubject());
            MailClientUtils.attachAddress(mailReceive, message);
            MailClientUtils.attachContent(mailReceive, (Part)message);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
    }

    public static void receive(Session session, MailAccount account, String folderName, MailCallback callback) {
        Store store = null;
        Folder folder = null;
        try {
            Message[] messages;
            store = session.getStore("imap");
            store.connect(account.getUsername(), account.getPassword());
            folder = store.getFolder(folderName);
            if (!folder.exists()) {
                log.error("Don't exist {} folder in {}.", (Object)folderName, (Object)store.getURLName().getUsername());
                return;
            }
            folder.open(1);
            for (Message message : messages = folder.getMessages()) {
                long uid = ((IMAPFolder)folder).getUID(message);
                MailReceive mailReceive = new MailReceive(account.getUsername(), folderName, uid);
                if (!callback.isFetch(uid)) continue;
                MailClientUtils.attachMessage(mailReceive, message);
                callback.receive(mailReceive);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (null != folder && folder.isOpen()) {
                    folder.close(false);
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
            try {
                if (null != store && store.isConnected()) {
                    store.close();
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }
    }

    public static void receive(MailAccount account, String folderName, MailCallback callback) {
        MailClientUtils.receive(MailClientUtils.getSession(), account, folderName, callback);
    }

    public static MailReceive receive(Session session, MailAccount account, String folderName, Long uid) {
        Store store = null;
        Folder folder = null;
        try {
            store = session.getStore("imap");
            store.connect(account.getUsername(), account.getPassword());
            folder = store.getFolder(folderName);
            if (!folder.exists()) {
                throw new RuntimeException(String.format("Don't exist %s folder in %s.", folderName, store.getURLName().getUsername()));
            }
            folder.open(1);
            Message message = ((IMAPFolder)folder).getMessageByUID(uid.longValue());
            if (null == message) {
                throw new RuntimeException(String.format("No message with uid %s in %s %s.", uid, store.getURLName().getUsername(), folderName));
            }
            MailReceive mailReceive = new MailReceive(account.getUsername(), folderName, uid);
            MailClientUtils.attachMessage(mailReceive, message);
            MailReceive mailReceive2 = mailReceive;
            return mailReceive2;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (null != folder && folder.isOpen()) {
                    folder.close(false);
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
            try {
                if (null != store && store.isConnected()) {
                    store.close();
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }
    }

    public static MailReceive receive(MailAccount account, String folderName, Long uid) {
        return MailClientUtils.receive(MailClientUtils.getSession(), account, folderName, uid);
    }

    private static void attachFile(Multipart multipart, List<MailFilePart> files) throws Exception {
        if (!ObjectUtils.isEmpty(files)) {
            for (MailFilePart file : files) {
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setDataHandler(new DataHandler(file.getDataSource()));
                bodyPart.setFileName(file.getFileName());
                bodyPart.setContentID(file.getContentId());
                multipart.addBodyPart((BodyPart)bodyPart);
            }
        }
    }

    private static void attachContent(Message message, MailMessage mailMessage) throws Exception {
        boolean hasAttachment;
        boolean hasInline = !CollectionUtils.isEmpty(mailMessage.getInline());
        boolean bl = hasAttachment = !CollectionUtils.isEmpty(mailMessage.getAttachment());
        if (null == mailMessage.getContent()) {
            mailMessage.setContent("");
        }
        if (hasInline || hasAttachment) {
            MimeBodyPart textPart = new MimeBodyPart();
            if (mailMessage.getContentType() == ContentType.html) {
                textPart.setContent((Object)mailMessage.getContent(), ContentType.html.value());
            } else {
                textPart.setContent((Object)mailMessage.getContent(), ContentType.text.value());
            }
            MimeMultipart multipart = new MimeMultipart();
            if (hasAttachment) {
                multipart.setSubType(MultipartType.mixed.name());
                if (hasInline) {
                    MimeMultipart subMultipart = new MimeMultipart();
                    subMultipart.setSubType(MultipartType.related.name());
                    subMultipart.addBodyPart((BodyPart)textPart);
                    MailClientUtils.attachFile((Multipart)subMultipart, mailMessage.getInline());
                    MimeBodyPart inlinePart = new MimeBodyPart();
                    inlinePart.setContent((Multipart)subMultipart);
                    multipart.addBodyPart((BodyPart)inlinePart);
                } else {
                    multipart.addBodyPart((BodyPart)textPart);
                }
                MailClientUtils.attachFile((Multipart)multipart, mailMessage.getAttachment());
            } else {
                multipart.setSubType(MultipartType.related.name());
                multipart.addBodyPart((BodyPart)textPart);
                MailClientUtils.attachFile((Multipart)multipart, mailMessage.getInline());
            }
            message.setContent((Multipart)multipart);
        } else if (mailMessage.getContentType() == ContentType.html) {
            message.setContent((Object)mailMessage.getContent(), ContentType.html.value());
        } else {
            message.setContent((Object)mailMessage.getContent(), ContentType.text.value());
        }
    }

    private static void attachAddress(Message message, MailMessage mailMessage) throws Exception {
        String inReplyTo;
        List<MailAddress> replyAddresses;
        List<MailAddress> bccAddresses;
        List<MailAddress> ccAddresses;
        List<MailAddress> toAddresses = mailMessage.getTo();
        if (!ObjectUtils.isEmpty(toAddresses)) {
            Address[] addresses = new Address[toAddresses.size()];
            for (int i = 0; i < toAddresses.size(); ++i) {
                MailAddress toAddress = toAddresses.get(i);
                addresses[i] = new InternetAddress(toAddress.getAddress(), toAddress.getPersonal(), ENCODING);
            }
            message.setRecipients(Message.RecipientType.TO, addresses);
        }
        if (!ObjectUtils.isEmpty(ccAddresses = mailMessage.getCc())) {
            Address[] addresses = new Address[ccAddresses.size()];
            for (int i = 0; i < ccAddresses.size(); ++i) {
                MailAddress ccAddress = ccAddresses.get(i);
                addresses[i] = new InternetAddress(ccAddress.getAddress(), ccAddress.getPersonal(), ENCODING);
            }
            message.setRecipients(Message.RecipientType.CC, addresses);
        }
        if (!ObjectUtils.isEmpty(bccAddresses = mailMessage.getBcc())) {
            Address[] addresses = new Address[bccAddresses.size()];
            for (int i = 0; i < bccAddresses.size(); ++i) {
                MailAddress bccAddress = bccAddresses.get(i);
                addresses[i] = new InternetAddress(bccAddress.getAddress(), bccAddress.getPersonal(), ENCODING);
            }
            message.setRecipients(Message.RecipientType.BCC, addresses);
        }
        if (!ObjectUtils.isEmpty(replyAddresses = mailMessage.getReplyTo())) {
            Address[] addresses = new Address[replyAddresses.size()];
            for (int i = 0; i < replyAddresses.size(); ++i) {
                MailAddress replyAddress = replyAddresses.get(i);
                addresses[i] = new InternetAddress(replyAddress.getAddress(), replyAddress.getPersonal(), ENCODING);
            }
            message.setReplyTo(addresses);
        }
        if (!StringUtils.isEmpty((Object)(inReplyTo = mailMessage.getInReplyTo()))) {
            message.setHeader("In-Reply-To", inReplyTo);
        }
    }

    private static void attachAddress(Message message, MailAccount mailAccount) throws Exception {
        message.setFrom((Address)new InternetAddress(mailAccount.getUsername(), mailAccount.getPersonal(), ENCODING));
    }

    public static void send(Session session, MailAccount account, MailMessage message) {
        try {
            MimeMessage mimeMessage = new MimeMessage(session);
            MailClientUtils.attachAddress((Message)mimeMessage, account);
            MailClientUtils.attachAddress((Message)mimeMessage, message);
            mimeMessage.setSubject(message.getSubject(), ENCODING);
            MailClientUtils.attachContent((Message)mimeMessage, message);
            Transport.send((Message)mimeMessage, (String)account.getUsername(), (String)account.getPassword());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void send(MailAccount account, MailMessage message) {
        MailClientUtils.send(MailClientUtils.getSession(), account, message);
    }
}

