/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.mongo;

import com.eworkcloud.mongo.MongoProperties;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

@EnableConfigurationProperties(value={MongoProperties.class})
public class MongoConfiguration {
    @Resource
    private MongoProperties mongoProperties;

    @Bean
    public MongoClient mongoClient() {
        List<ServerAddress> serverAddresses = this.mongoProperties.serverAddresses();
        List<MongoCredential> mongoCredentials = this.mongoProperties.mongoCredentials();
        MongoClientOptions mongoClientOptions = this.mongoProperties.mongoClientOptions();
        return new MongoClient(serverAddresses, mongoCredentials, mongoClientOptions);
    }

    @Bean
    public MongoDbFactory mongoDbFactory(MongoClient mongoClient) {
        return new SimpleMongoDbFactory(mongoClient, this.mongoProperties.getDatabase());
    }
}

