/*
 * Decompiled with CFR 0.152.
 */
package com.eworkcloud.mongo;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="mongodb")
public class MongoProperties {
    private String address;
    private String database;
    private String username;
    private String password;
    private Options options;

    List<ServerAddress> serverAddresses() {
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
        if (StringUtils.hasText((String)this.address)) {
            String[] addresses;
            for (String address : addresses = this.address.split(",")) {
                String[] hostAndPort = address.split(":");
                String host = hostAndPort[0].trim();
                if (hostAndPort.length > 1) {
                    int port = Integer.parseInt(hostAndPort[1].trim());
                    serverAddresses.add(new ServerAddress(host, port));
                    continue;
                }
                serverAddresses.add(new ServerAddress(host));
            }
        }
        return serverAddresses;
    }

    List<MongoCredential> mongoCredentials() {
        ArrayList<MongoCredential> mongoCredentials = new ArrayList<MongoCredential>();
        mongoCredentials.add(MongoCredential.createCredential((String)this.username, (String)this.database, (char[])this.password.toCharArray()));
        return mongoCredentials;
    }

    MongoClientOptions mongoClientOptions() {
        Options options = this.options;
        if (null == options) {
            options = new Options();
        }
        return MongoClientOptions.builder().requiredReplicaSetName(options.replicaSetName).minConnectionsPerHost(options.minConnectionsPerHost).connectionsPerHost(options.connectionsPerHost).threadsAllowedToBlockForConnectionMultiplier(options.threadsAllowedToBlock).maxConnectionIdleTime(options.maxConnectionIdleTime).maxWaitTime(options.maxWaitTime).connectTimeout(options.connectTimeout).build();
    }

    public String getAddress() {
        return this.address;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public static class Options {
        private String replicaSetName;
        private int minConnectionsPerHost = 8;
        private int connectionsPerHost = 64;
        private int threadsAllowedToBlock = 4;
        private int maxConnectionIdleTime = 300000;
        private int maxWaitTime = 120000;
        private int connectTimeout = 10000;

        public String getReplicaSetName() {
            return this.replicaSetName;
        }

        public int getMinConnectionsPerHost() {
            return this.minConnectionsPerHost;
        }

        public int getConnectionsPerHost() {
            return this.connectionsPerHost;
        }

        public int getThreadsAllowedToBlock() {
            return this.threadsAllowedToBlock;
        }

        public int getMaxConnectionIdleTime() {
            return this.maxConnectionIdleTime;
        }

        public int getMaxWaitTime() {
            return this.maxWaitTime;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setReplicaSetName(String replicaSetName) {
            this.replicaSetName = replicaSetName;
        }

        public void setMinConnectionsPerHost(int minConnectionsPerHost) {
            this.minConnectionsPerHost = minConnectionsPerHost;
        }

        public void setConnectionsPerHost(int connectionsPerHost) {
            this.connectionsPerHost = connectionsPerHost;
        }

        public void setThreadsAllowedToBlock(int threadsAllowedToBlock) {
            this.threadsAllowedToBlock = threadsAllowedToBlock;
        }

        public void setMaxConnectionIdleTime(int maxConnectionIdleTime) {
            this.maxConnectionIdleTime = maxConnectionIdleTime;
        }

        public void setMaxWaitTime(int maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }
    }
}

