package com.eworkcloud.mybatis;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Getter
@Setter
@ConfigurationProperties(prefix = "mybatis")
public class MybatisProperties {
    /**
     * 驱动类名
     * 默认：com.mysql.jdbc.Driver
     */
    private String driverClassName = "com.mysql.jdbc.Driver";
    /**
     * JdbcUrl
     */
    private String jdbcUrl;
    /**
     * 用户名称
     */
    private String username;
    /**
     * 登录密码
     */
    private String password;
    /**
     * 连接池中同意的最大连接数。缺省：10
     * 推荐的公式：((core_count * 2) + effective_spindle_count)
     */
    private int maxPoolSize = 10;
    /**
     * 一个连接的生命时长（毫秒），超时并且没被使用则被释放（retired），缺省：30分钟
     * 建议设置比数据库超时时长少30秒，參考MySQL wait_timeout參数（show variables like '%timeout%';）
     */
    private int maxLifetime = 1800000;
    /**
     * 实体类包
     */
    private String typeAliasesPackage;
    /**
     * Mapper文件路径
     */
    private String mapperLocations = "classpath:mappers/**/*.xml";
}
