package com.eworkcloud.mybatis.model;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

@Getter
public class Page {

    @ApiModelProperty(value = "当前页码", example = "1")
    private int pageNum;

    @ApiModelProperty(value = "每页数量", example = "10")
    private int pageSize;

    @ApiModelProperty(value = "总记录数", example = "20")
    private int totalCount;

    @ApiModelProperty(value = "总计页数", example = "2")
    private int totalPages;

    public Page(PageInfo page) {
        this.pageNum = page.getPageNum();
        this.pageSize = page.getPageSize();
        this.totalCount = (int) page.getTotal();
        this.totalPages = page.getPages();
    }

    public Page(int pageNum, int pageSize, int totalCount, int totalPages) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.totalCount = totalCount;
        this.totalPages = totalPages;
    }

}
