package com.eworkcloud.mybatis.model;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

@Getter
public class Pagination<T> {

    @ApiModelProperty(value = "响应数据")
    private List<T> data;

    @ApiModelProperty(value = "分页信息")
    private Page page;

    /**
     * 分页响应构造函数
     *
     * @param data     数据列表
     * @param pageInfo 分页信息
     */
    public Pagination(List<T> data, PageInfo pageInfo) {
        if (null == data) {
            this.data = new ArrayList<>();
        } else {
            this.data = data;
        }
        this.page = new Page(pageInfo);
    }

    /**
     * 内存分页构造函数
     *
     * @param data     数据列表
     * @param pageable 分页参数
     */
    public Pagination(List<T> data, Pageable pageable) {
        int pageNum = pageable.getPageNum();
        int pageSize = pageable.getPageSize();
        int totalCount = null == data ? 0 : data.size();
        int totalPages = 0;

        if (pageSize < 0 || totalCount == 0) {
            this.data = new ArrayList<>();
        } else if (pageSize == 0) {
            this.data = data;
        } else {
            totalPages = totalCount / pageSize;
            if (totalCount > totalPages * pageSize) {
                totalPages = totalPages + 1;
            }

            if (pageNum < 1) {
                pageNum = 1;
            }

            int startIndex = (pageNum - 1) * pageSize;
            int endIndex = pageNum * pageSize;
            if (endIndex > totalCount) {
                endIndex = totalCount;
            }

            this.data = new ArrayList<>();
            for (int i = startIndex; i < endIndex; i++) {
                this.data.add(data.get(i));
            }
        }

        this.page = new Page(pageable.getPageNum(), pageSize, totalCount, totalPages);
    }

}
